/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private final CompressionMetadata metadata;
    private byte[] compressed;
    private final Checksum checksum = new CRC32();
    private final byte[] checksumBytes = new byte[4];
    private final FileInputStream source;
    private final FileChannel channel;

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata) {
        return CompressedRandomAccessReader.open(dataFilePath, metadata, false);
    }

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) {
        try {
            return new CompressedRandomAccessReader(dataFilePath, metadata, skipIOCache);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public CompressedRandomAccessReader(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) throws FileNotFoundException {
        super(new File(dataFilePath), metadata.chunkLength(), skipIOCache);
        this.metadata = metadata;
        this.compressed = new byte[metadata.compressor().initialCompressedBufferLength(metadata.chunkLength())];
        try {
            this.source = new FileInputStream(this.getFD());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.channel = this.source.getChannel();
    }

    @Override
    protected void reBuffer() {
        try {
            this.decompressChunk(this.metadata.chunkFor(this.current));
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    private void decompressChunk(CompressionMetadata.Chunk chunk) throws IOException {
        if (this.channel.position() != chunk.offset) {
            this.channel.position(chunk.offset);
        }
        if (this.compressed.length < chunk.length) {
            this.compressed = new byte[chunk.length];
        }
        if (this.source.read(this.compressed, 0, chunk.length) != chunk.length) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        try {
            this.validBufferBytes = this.metadata.compressor().uncompress(this.compressed, 0, chunk.length, this.buffer, 0);
        }
        catch (IOException e) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        if (this.metadata.parameters.getCrcCheckChance() > FBUtilities.threadLocalRandom().nextDouble()) {
            this.checksum.update(this.buffer, 0, this.validBufferBytes);
            if (this.checksum(chunk) != (int)this.checksum.getValue()) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            this.checksum.reset();
        }
        this.bufferOffset = this.current & (long)(~(this.buffer.length - 1));
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        assert (this.channel.position() == chunk.offset + (long)chunk.length);
        if (this.source.read(this.checksumBytes, 0, this.checksumBytes.length) != this.checksumBytes.length) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        return Ints.fromByteArray((byte[])this.checksumBytes);
    }

    @Override
    public long length() {
        return this.metadata.dataLength;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.source.close();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }
}

