/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IndexSummary {
    public static final IndexSummarySerializer serializer = new IndexSummarySerializer();
    private final ArrayList<Long> positions;
    private final ArrayList<DecoratedKey> keys;
    private long keysWritten = 0L;

    public IndexSummary(long expectedKeys) {
        long expectedEntries = expectedKeys / (long)DatabaseDescriptor.getIndexInterval().intValue();
        if (expectedEntries > Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot use index_interval of " + DatabaseDescriptor.getIndexInterval() + " with " + expectedKeys + " (expected) keys.");
        }
        this.positions = new ArrayList((int)expectedEntries);
        this.keys = new ArrayList((int)expectedEntries);
    }

    private IndexSummary() {
        this.positions = new ArrayList();
        this.keys = new ArrayList();
    }

    public void incrementRowid() {
        ++this.keysWritten;
    }

    public boolean shouldAddEntry() {
        return this.keysWritten % (long)DatabaseDescriptor.getIndexInterval().intValue() == 0L;
    }

    public void addEntry(DecoratedKey key, long indexPosition) {
        this.keys.add(SSTable.getMinimalKey(key));
        this.positions.add(indexPosition);
    }

    public void maybeAddEntry(DecoratedKey decoratedKey, long indexPosition) {
        if (this.shouldAddEntry()) {
            this.addEntry(decoratedKey, indexPosition);
        }
        this.incrementRowid();
    }

    public List<DecoratedKey> getKeys() {
        return this.keys;
    }

    public long getPosition(int index) {
        return this.positions.get(index);
    }

    public void complete() {
        this.keys.trimToSize();
        this.positions.trimToSize();
    }

    public static class IndexSummarySerializer {
        public void serialize(IndexSummary t, DataOutput dos) throws IOException {
            assert (t.keys.size() == t.positions.size()) : "keysize and the position sizes are not same.";
            dos.writeInt(DatabaseDescriptor.getIndexInterval());
            dos.writeInt(t.keys.size());
            for (int i = 0; i < t.keys.size(); ++i) {
                dos.writeLong((Long)t.positions.get(i));
                ByteBufferUtil.writeWithLength(((DecoratedKey)((IndexSummary)t).keys.get((int)i)).key, dos);
            }
        }

        public IndexSummary deserialize(DataInput dis, IPartitioner partitioner) throws IOException {
            IndexSummary summary = new IndexSummary();
            if (dis.readInt() != DatabaseDescriptor.getIndexInterval().intValue()) {
                throw new IOException("Cannot read the saved summary because Index Interval changed.");
            }
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                long location = dis.readLong();
                ByteBuffer key = ByteBufferUtil.readWithLength(dis);
                summary.addEntry(partitioner.decorateKey(key), location);
            }
            return summary;
        }
    }
}

