/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public abstract class AbstractDataOutput
extends OutputStream
implements DataOutput {
    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(bytes);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        byte[] buffer = new byte[]{(byte)(val >> 8), (byte)val};
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        for (int index = 0; index < str.length(); ++index) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8 & 0xFF);
            newBytes[newIndex + 1] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(newBytes);
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public void writeInt(int val) throws IOException {
        byte[] buffer = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void writeLong(long val) throws IOException {
        byte[] buffer = new byte[8];
        int t = (int)(val >> 32);
        buffer[0] = (byte)(t >> 24);
        buffer[1] = (byte)(t >> 16);
        buffer[2] = (byte)(t >> 8);
        buffer[3] = (byte)t;
        buffer[4] = (byte)(val >> 24);
        buffer[5] = (byte)(val >> 16);
        buffer[6] = (byte)(val >> 8);
        buffer[7] = (byte)val;
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        int utfCount = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] utfBytes = new byte[utfCount + 2];
        int utfIndex = 2;
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                utfBytes[utfIndex++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
        }
        utfBytes[0] = (byte)(utfCount >> 8);
        utfBytes[1] = (byte)utfCount;
        this.write(utfBytes);
    }
}

