/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.IStreamCallback;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOut {
    private static final Logger logger = LoggerFactory.getLogger(StreamOut.class);

    public static void transferRanges(InetAddress target, Table table, Collection<Range<Token>> ranges, IStreamCallback callback, OperationType type) {
        StreamOutSession session = StreamOutSession.create(table.name, target, callback);
        StreamOut.transferRanges(session, table.getColumnFamilyStores(), ranges, type);
    }

    private static void flushSSTables(Iterable<ColumnFamilyStore> stores) {
        logger.info("Flushing memtables for {}...", stores);
        ArrayList flushes = new ArrayList();
        for (ColumnFamilyStore cfstore : stores) {
            flushes.add(cfstore.forceFlush());
        }
        FBUtilities.waitOnFutures(flushes);
    }

    public static void transferRanges(StreamOutSession session, Iterable<ColumnFamilyStore> cfses, Collection<Range<Token>> ranges, OperationType type) {
        assert (ranges.size() > 0);
        logger.info("Beginning transfer to {}", (Object)session.getHost());
        logger.debug("Ranges are {}", (Object)StringUtils.join(ranges, (String)","));
        StreamOut.flushSSTables(cfses);
        Iterable<SSTableReader> sstables = Collections.emptyList();
        for (ColumnFamilyStore cfStore : cfses) {
            sstables = Iterables.concat(sstables, cfStore.markCurrentSSTablesReferenced());
        }
        StreamOut.transferSSTables(session, sstables, ranges, type);
    }

    public static void transferSSTables(StreamOutSession session, Iterable<SSTableReader> sstables, Collection<Range<Token>> ranges, OperationType type) {
        List<PendingFile> pending = StreamOut.createPendingFiles(sstables, ranges, type);
        session.addFilesToStream(pending);
        session.begin();
    }

    private static List<PendingFile> createPendingFiles(Iterable<SSTableReader> sstables, Collection<Range<Token>> ranges, OperationType type) {
        ArrayList<PendingFile> pending = new ArrayList<PendingFile>();
        for (SSTableReader sstable : sstables) {
            Descriptor desc = sstable.descriptor;
            List<Pair<Long, Long>> sections = sstable.getPositionsForRanges(ranges);
            if (sections.isEmpty()) {
                sstable.releaseReference();
                continue;
            }
            CompressionInfo compression = null;
            if (sstable.compression) {
                compression = new CompressionInfo(sstable.getCompressionMetadata().getChunksForSections(sections), sstable.getCompressionMetadata().parameters);
            }
            pending.add(new PendingFile(sstable, desc, SSTable.COMPONENT_DATA, sections, type, sstable.estimatedKeysForRanges(ranges), compression));
        }
        logger.info("Stream context metadata {}, {} sstables.", pending, (Object)Iterables.size(sstables));
        return pending;
    }
}

