/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServer
implements Cassandra.Iface {
    private static final Logger logger = LoggerFactory.getLogger(CassandraServer.class);
    private static final int COUNT_PAGE_SIZE = 1024;
    private static final List<ColumnOrSuperColumn> EMPTY_COLUMNS = Collections.emptyList();
    private static final List<Column> EMPTY_SUBCOLUMNS = Collections.emptyList();
    private static final List<CounterColumn> EMPTY_COUNTER_SUBCOLUMNS = Collections.emptyList();
    private final IRequestScheduler requestScheduler = DatabaseDescriptor.getRequestScheduler();

    public ThriftClientState state() {
        return ThriftSessionManager.instance.currentSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<DecoratedKey, ColumnFamily> readColumnFamily(List<ReadCommand> commands, org.apache.cassandra.db.ConsistencyLevel consistency_level) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        HashMap<DecoratedKey, ColumnFamily> columnFamilyKeyMap = new HashMap<DecoratedKey, ColumnFamily>();
        List<Row> rows = null;
        try {
            this.schedule(DatabaseDescriptor.getReadRpcTimeout());
            try {
                rows = StorageProxy.read(commands, consistency_level);
            }
            finally {
                this.release();
            }
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key, row.cf);
        }
        return columnFamilyKeyMap;
    }

    public List<Column> thriftifySubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_SUBCOLUMNS;
        }
        ArrayList<Column> thriftColumns = new ArrayList<Column>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column thrift_column = new Column(column.name()).setValue(column.value()).setTimestamp(column.timestamp());
            if (column instanceof ExpiringColumn) {
                thrift_column.setTtl(((ExpiringColumn)column).getTimeToLive());
            }
            thriftColumns.add(thrift_column);
        }
        return thriftColumns;
    }

    public List<CounterColumn> thriftifyCounterSubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_COUNTER_SUBCOLUMNS;
        }
        ArrayList<CounterColumn> thriftColumns = new ArrayList<CounterColumn>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            assert (column instanceof org.apache.cassandra.db.CounterColumn);
            CounterColumn thrift_column = new CounterColumn(column.name(), CounterContext.instance().total(column.value()));
            thriftColumns.add(thrift_column);
        }
        return thriftColumns;
    }

    public List<ColumnOrSuperColumn> thriftifyColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            CounterColumn thrift_column;
            if (column.isMarkedForDelete()) continue;
            if (column instanceof org.apache.cassandra.db.CounterColumn) {
                thrift_column = new CounterColumn(column.name(), CounterContext.instance().total(column.value()));
                thriftColumns.add(new ColumnOrSuperColumn().setCounter_column(thrift_column));
                continue;
            }
            thrift_column = new Column(column.name()).setValue(column.value()).setTimestamp(column.timestamp());
            if (column instanceof ExpiringColumn) {
                thrift_column.setTtl(((ExpiringColumn)column).getTimeToLive());
            }
            thriftColumns.add(new ColumnOrSuperColumn().setColumn((Column)thrift_column));
        }
        if (reverseOrder) {
            Collections.reverse(thriftColumns);
        }
        return thriftColumns;
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<IColumn> columns, boolean reverseOrder, boolean isCounterCF) {
        if (isCounterCF) {
            return this.thriftifyCounterSuperColumns(columns, reverseOrder);
        }
        return this.thriftifySuperColumns(columns, reverseOrder);
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            List<Column> subcolumns = this.thriftifySubColumns(column.getSubColumns());
            if (subcolumns.isEmpty()) continue;
            SuperColumn superColumn = new SuperColumn(column.name(), subcolumns);
            thriftSuperColumns.add(new ColumnOrSuperColumn().setSuper_column(superColumn));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private List<ColumnOrSuperColumn> thriftifyCounterSuperColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            List<CounterColumn> subcolumns = this.thriftifyCounterSubColumns(column.getSubColumns());
            if (subcolumns.isEmpty()) continue;
            CounterSuperColumn superColumn = new CounterSuperColumn(column.name(), subcolumns);
            thriftSuperColumns.add(new ColumnOrSuperColumn().setCounter_super_column(superColumn));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> getSlice(List<ReadCommand> commands, org.apache.cassandra.db.ConsistencyLevel consistency_level) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        Map<DecoratedKey, ColumnFamily> columnFamilies = this.readColumnFamily(commands, consistency_level);
        HashMap<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = new HashMap<ByteBuffer, List<ColumnOrSuperColumn>>();
        for (ReadCommand command : commands) {
            ColumnFamily cf = columnFamilies.get(StorageService.getPartitioner().decorateKey(command.key));
            boolean reverseOrder = command instanceof SliceFromReadCommand && ((SliceFromReadCommand)command).filter.reversed;
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(cf, command.queryPath.superColumnName != null, reverseOrder);
            columnFamiliesMap.put(command.key, thriftifiedColumns);
        }
        return columnFamiliesMap;
    }

    private List<ColumnOrSuperColumn> thriftifyColumnFamily(ColumnFamily cf, boolean subcolumnsOnly, boolean reverseOrder) {
        if (cf == null || cf.isEmpty()) {
            return EMPTY_COLUMNS;
        }
        if (subcolumnsOnly) {
            IColumn column = cf.iterator().next();
            Collection<IColumn> subcolumns = column.getSubColumns();
            if (subcolumns == null || subcolumns.isEmpty()) {
                return EMPTY_COLUMNS;
            }
            return this.thriftifyColumns(subcolumns, reverseOrder);
        }
        if (cf.isSuper()) {
            boolean isCounterCF = cf.metadata().getDefaultValidator().isCommutative();
            return this.thriftifySuperColumns(cf.getSortedColumns(), reverseOrder, isCounterCF);
        }
        return this.thriftifyColumns(cf.getSortedColumns(), reverseOrder);
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            this.state().hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            List<ColumnOrSuperColumn> list = this.multigetSliceInternal(keyspace, Collections.singletonList(key), column_parent, predicate, consistency_level).get(key);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("multiget_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Map<ByteBuffer, List<ColumnOrSuperColumn>> map = this.multigetSliceInternal(keyspace, keys, column_parent, predicate, consistency_level);
            return map;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> multigetSliceInternal(String keyspace, List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        ThriftValidation.validatePredicate(metadata, column_parent, predicate);
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForRead(keyspace);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        if (predicate.column_names != null) {
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey(metadata, key);
                commands.add(new SliceByNamesReadCommand(keyspace, key, column_parent, (Collection<ByteBuffer>)predicate.column_names));
            }
        } else {
            SliceRange range = predicate.slice_range;
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey(metadata, key);
                commands.add(new SliceFromReadCommand(keyspace, key, column_parent, range.start, range.finish, range.reversed, range.count));
            }
        }
        return this.getSlice(commands, consistencyLevel);
    }

    private ColumnOrSuperColumn internal_get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws RequestValidationException, NotFoundException, UnavailableException, TimedOutException {
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_path.column_family, Permission.SELECT);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_path.column_family);
        ThriftValidation.validateColumnPath(metadata, column_path);
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForRead(keyspace);
        QueryPath path = new QueryPath(column_path.column_family, column_path.column == null ? null : column_path.super_column);
        List<ByteBuffer> nameAsList = Arrays.asList(column_path.column == null ? column_path.super_column : column_path.column);
        ThriftValidation.validateKey(metadata, key);
        SliceByNamesReadCommand command = new SliceByNamesReadCommand(keyspace, key, path, nameAsList);
        Map<DecoratedKey, ColumnFamily> cfamilies = this.readColumnFamily(Arrays.asList(command), consistencyLevel);
        ColumnFamily cf = cfamilies.get(StorageService.getPartitioner().decorateKey(command.key));
        if (cf == null) {
            throw new NotFoundException();
        }
        List<ColumnOrSuperColumn> tcolumns = this.thriftifyColumnFamily(cf, command.queryPath.superColumnName != null, false);
        if (tcolumns.isEmpty()) {
            throw new NotFoundException();
        }
        assert (tcolumns.size() == 1);
        return tcolumns.get(0);
    }

    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        ColumnOrSuperColumn traceParameters;
        if (this.startSessionIfRequested()) {
            traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)column_path.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get");
        }
        try {
            traceParameters = this.internal_get(key, column_path, consistency_level);
            return traceParameters;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_count");
        }
        try {
            int requestedCount;
            int pageSize;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Table table = Table.open(keyspace);
            ColumnFamilyStore cfs = table.getColumnFamilyStore(column_parent.column_family);
            if (predicate.column_names != null) {
                int n = this.get_slice(key, column_parent, predicate, consistency_level).size();
                return n;
            }
            if (cfs.getMeanColumns() > 0) {
                int averageColumnSize = (int)(cfs.getMeanRowSize() / (long)cfs.getMeanColumns());
                pageSize = Math.min(1024, DatabaseDescriptor.getInMemoryCompactionLimit() / averageColumnSize);
                pageSize = Math.max(2, pageSize);
                logger.debug("average row column size is {}; using pageSize of {}", (Object)averageColumnSize, (Object)pageSize);
            } else {
                pageSize = 1024;
            }
            int totalCount = 0;
            if (predicate.slice_range == null) {
                predicate.slice_range = new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE);
            }
            int remaining = requestedCount = predicate.slice_range.count;
            int pages = 0;
            while (true) {
                int newColumns;
                predicate.slice_range.count = Math.min(pageSize, Math.max(2, remaining));
                List<ColumnOrSuperColumn> columns = this.get_slice(key, column_parent, predicate, consistency_level);
                if (columns.isEmpty()) break;
                ByteBuffer firstName = CassandraServer.getName(columns.get(0));
                int n = newColumns = pages == 0 || !firstName.equals(predicate.slice_range.start) ? columns.size() : columns.size() - 1;
                if ((totalCount += newColumns) > requestedCount) {
                    int n2 = requestedCount;
                    return n2;
                }
                ++pages;
                if ((remaining -= newColumns) == 0 || columns.size() < predicate.slice_range.count) break;
                predicate.slice_range.start = CassandraServer.getName(columns.get(columns.size() - 1));
            }
            int n = totalCount;
            return n;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private static ByteBuffer getName(ColumnOrSuperColumn cosc) {
        return cosc.isSetSuper_column() ? cosc.super_column.name : (cosc.isSetColumn() ? cosc.column.name : (cosc.isSetCounter_column() ? cosc.counter_column.name : cosc.counter_super_column.name));
    }

    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("multiget_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_count");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            HashMap<ByteBuffer, Integer> counts = new HashMap<ByteBuffer, Integer>();
            Map<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = this.multigetSliceInternal(keyspace, keys, column_parent, predicate, consistency_level);
            for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> cf : columnFamiliesMap.entrySet()) {
                counts.put(cf.getKey(), cf.getValue().size());
            }
            HashMap<ByteBuffer, Integer> hashMap = counts;
            return hashMap;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private void internal_insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws RequestValidationException, UnavailableException, TimedOutException {
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, false);
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        if (metadata.cfType == ColumnFamilyType.Super && column_parent.super_column == null) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
        }
        ThriftValidation.validateColumnNames(metadata, column_parent, Arrays.asList(column.name));
        ThriftValidation.validateColumnData(metadata, column, column_parent.super_column != null);
        RowMutation rm = new RowMutation(cState.getKeyspace(), key);
        try {
            rm.add(new QueryPath(column_parent.column_family, column_parent.super_column, column.name), column.value, column.timestamp, column.ttl);
        }
        catch (MarshalException e) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
        }
        this.doInsert(consistency_level, Arrays.asList(rm));
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("insert", (Map<String, String>)traceParameters);
        } else {
            logger.debug("insert");
        }
        try {
            this.internal_insert(key, column_parent, column, consistency_level);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private List<IMutation> createMutationList(ConsistencyLevel consistency_level, Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, boolean allowCounterMutations) throws RequestValidationException {
        ArrayList<String> cfamsSeen = new ArrayList<String>();
        ArrayList<IMutation> rowMutations = new ArrayList<IMutation>();
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
            ByteBuffer key = mutationEntry.getKey();
            RowMutation rmStandard = null;
            RowMutation rmCounter = null;
            Map<String, List<Mutation>> columnFamilyToMutations = mutationEntry.getValue();
            for (Map.Entry<String, List<Mutation>> columnFamilyMutations : columnFamilyToMutations.entrySet()) {
                RowMutation rm;
                String cfName = columnFamilyMutations.getKey();
                if (!cfamsSeen.contains(cfName)) {
                    cState.hasColumnFamilyAccess(keyspace, cfName, Permission.MODIFY);
                    cfamsSeen.add(cfName);
                }
                CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, cfName);
                ThriftValidation.validateKey(metadata, key);
                if (metadata.getDefaultValidator().isCommutative()) {
                    ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
                    rm = rmCounter = rmCounter == null ? new RowMutation(keyspace, key) : rmCounter;
                } else {
                    rm = rmStandard = rmStandard == null ? new RowMutation(keyspace, key) : rmStandard;
                }
                for (Mutation mutation : columnFamilyMutations.getValue()) {
                    ThriftValidation.validateMutation(metadata, mutation);
                    if (mutation.deletion != null) {
                        rm.deleteColumnOrSuperColumn(cfName, mutation.deletion);
                    }
                    if (mutation.column_or_supercolumn == null) continue;
                    rm.addColumnOrSuperColumn(cfName, mutation.column_or_supercolumn);
                }
            }
            if (rmStandard != null && !rmStandard.isEmpty()) {
                rowMutations.add(rmStandard);
            }
            if (rmCounter == null || rmCounter.isEmpty()) continue;
            if (allowCounterMutations) {
                rowMutations.add(new CounterMutation(rmCounter, ThriftConversion.fromThrift(consistency_level)));
                continue;
            }
            throw new org.apache.cassandra.exceptions.InvalidRequestException("Counter mutations are not allowed in atomic batches");
        }
        return rowMutations;
    }

    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance().begin("batch_mutate", traceParameters);
        } else {
            logger.debug("batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, true));
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public void atomic_batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance().begin("atomic_batch_mutate", traceParameters);
        } else {
            logger.debug("atomic_batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, false), true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private void internal_remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, boolean isCommutativeOp) throws RequestValidationException, UnavailableException, TimedOutException {
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_path.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_path.column_family, isCommutativeOp);
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnPathOrParent(metadata, column_path);
        if (isCommutativeOp) {
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
        }
        RowMutation rm = new RowMutation(keyspace, key);
        rm.delete(new QueryPath(column_path), timestamp);
        if (isCommutativeOp) {
            this.doInsert(consistency_level, Arrays.asList(new CounterMutation(rm, ThriftConversion.fromThrift(consistency_level))));
        } else {
            this.doInsert(consistency_level, Arrays.asList(rm));
        }
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)column_path.toString(), (Object)"timestamp", (Object)(timestamp + ""), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("remove", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove");
        }
        try {
            this.internal_remove(key, column_path, timestamp, consistency_level, false);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        this.doInsert(consistency_level, mutations, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations, boolean mutateAtomically) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForWrite(this.state().getKeyspace());
        if (mutations.isEmpty()) {
            return;
        }
        this.schedule(DatabaseDescriptor.getWriteRpcTimeout());
        try {
            if (mutateAtomically) {
                StorageProxy.mutateAtomically(mutations, consistencyLevel);
            } else {
                StorageProxy.mutate(mutations, consistencyLevel);
            }
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
        }
        finally {
            this.release();
        }
    }

    public KsDef describe_keyspace(String table) throws NotFoundException, InvalidRequestException {
        KSMetaData ksm = Schema.instance.getTableDefinition(table);
        if (ksm == null) {
            throw new NotFoundException();
        }
        return ksm.toThrift();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"range", (Object)range.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get_range_slices", (Map<String, String>)traceParameters);
        } else {
            logger.debug("range_slice");
        }
        try {
            AbstractBounds bounds;
            String keyspace = null;
            CFMetaData metadata = null;
            ThriftClientState cState = this.state();
            keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            ThriftValidation.validatePredicate(metadata, column_parent, predicate);
            ThriftValidation.validateKeyRange(metadata, column_parent.super_column, range);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            List<Row> rows = null;
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(range.start_token);
                Token right = tokenFactory.fromString(range.end_token);
                bounds = Range.makeRowRange(left, right, p);
            } else {
                RowPosition end = range.end_key == null ? p.getTokenFactory().fromString(range.end_token).maxKeyBound(p) : RowPosition.forKey(range.end_key, p);
                bounds = new Bounds<RowPosition>(RowPosition.forKey(range.start_key, p), end);
            }
            this.schedule(DatabaseDescriptor.getRangeRpcTimeout());
            try {
                IDiskAtomFilter filter = ThriftValidation.asIFilter(predicate, metadata.getComparatorFor(column_parent.super_column));
                rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, column_parent, filter, bounds, range.row_filter, range.count), consistencyLevel);
            }
            finally {
                this.release();
            }
            assert (rows != null);
            List<KeySlice> list = this.thriftifyKeySlices(rows, column_parent, predicate);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            logger.debug("... timed out");
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeySlice> get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_family", (Object)column_family, (Object)"range", (Object)range.toString(), (Object)"start_column", (Object)ByteBufferUtil.bytesToHex(start_column), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get_paged_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_paged_slice");
        }
        try {
            List<Row> rows;
            AbstractBounds bounds;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_family);
            ThriftValidation.validateKeyRange(metadata, null, range);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            SlicePredicate predicate = new SlicePredicate().setSlice_range(new SliceRange(start_column, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, -1));
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(range.start_token);
                Token right = tokenFactory.fromString(range.end_token);
                bounds = Range.makeRowRange(left, right, p);
            } else {
                RowPosition end = range.end_key == null ? p.getTokenFactory().fromString(range.end_token).maxKeyBound(p) : RowPosition.forKey(range.end_key, p);
                bounds = new Bounds<RowPosition>(RowPosition.forKey(range.start_key, p), end);
            }
            this.schedule(DatabaseDescriptor.getRangeRpcTimeout());
            try {
                IDiskAtomFilter filter = ThriftValidation.asIFilter(predicate, metadata.comparator);
                rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, column_family, null, filter, bounds, range.row_filter, range.count, true, true), consistencyLevel);
            }
            finally {
                this.release();
            }
            assert (rows != null);
            List<KeySlice> list = this.thriftifyKeySlices(rows, new ColumnParent(column_family), predicate);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            logger.debug("... timed out");
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private List<KeySlice> thriftifyKeySlices(List<Row> rows, ColumnParent column_parent, SlicePredicate predicate) {
        ArrayList<KeySlice> keySlices = new ArrayList<KeySlice>(rows.size());
        boolean reversed = predicate.slice_range != null && predicate.slice_range.reversed;
        for (Row row : rows) {
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(row.cf, column_parent.super_column != null, reversed);
            keySlices.add(new KeySlice(row.key.key, thriftifiedColumns));
        }
        return keySlices;
    }

    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"index_clause", (Object)index_clause.toString(), (Object)"slice_predicate", (Object)column_predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("get_indexed_slices", (Map<String, String>)traceParameters);
        } else {
            logger.debug("scan");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, false);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            ThriftValidation.validatePredicate(metadata, column_parent, column_predicate);
            ThriftValidation.validateIndexClauses(metadata, index_clause);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            IPartitioner p = StorageService.getPartitioner();
            Bounds<RowPosition> bounds = new Bounds<RowPosition>(RowPosition.forKey(index_clause.start_key, p), ((Token)p.getMinimumToken()).minKeyBound());
            IDiskAtomFilter filter = ThriftValidation.asIFilter(column_predicate, metadata.getComparatorFor(column_parent.super_column));
            RangeSliceCommand command = new RangeSliceCommand(keyspace, column_parent.column_family, null, filter, bounds, index_clause.expressions, index_clause.count);
            List<Row> rows = StorageProxy.getRangeSlice(command, consistencyLevel);
            List<KeySlice> list = this.thriftifyKeySlices(rows, column_parent, column_predicate);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            logger.debug("... timed out");
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public List<KsDef> describe_keyspaces() throws TException, InvalidRequestException {
        Set<String> keyspaces = Schema.instance.getTables();
        ArrayList<KsDef> ksset = new ArrayList<KsDef>(keyspaces.size());
        for (String ks : keyspaces) {
            try {
                ksset.add(this.describe_keyspace(ks));
            }
            catch (NotFoundException nfe) {
                logger.info("Failed to find metadata for keyspace '" + ks + "'. Continuing... ");
            }
        }
        return ksset;
    }

    public String describe_cluster_name() throws TException {
        return DatabaseDescriptor.getClusterName();
    }

    public String describe_version() throws TException {
        return "19.35.0";
    }

    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException {
        try {
            return StorageService.instance.describeRing(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, String> describe_token_map() throws InvalidRequestException {
        return StorageService.instance.getTokenToEndpointMap();
    }

    public String describe_partitioner() throws TException {
        return StorageService.getPartitioner().getClass().getName();
    }

    public String describe_snitch() throws TException {
        if (DatabaseDescriptor.getEndpointSnitch() instanceof DynamicEndpointSnitch) {
            return ((DynamicEndpointSnitch)DatabaseDescriptor.getEndpointSnitch()).subsnitch.getClass().getName();
        }
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }

    @Deprecated
    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws TException, InvalidRequestException {
        List<CfSplit> splits = this.describe_splits_ex(cfName, start_token, end_token, keys_per_split);
        ArrayList<String> result = new ArrayList<String>(splits.size() + 1);
        result.add(splits.get(0).getStart_token());
        for (CfSplit cfSplit : splits) {
            result.add(cfSplit.getEnd_token());
        }
        return result;
    }

    public List<CfSplit> describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, TException {
        try {
            Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
            Range<Token> tr = new Range<Token>(tf.fromString(start_token), tf.fromString(end_token));
            List<Pair<Range<Token>, Long>> splits = StorageService.instance.getSplits(this.state().getKeyspace(), cfName, tr, keys_per_split);
            ArrayList<CfSplit> result = new ArrayList<CfSplit>(splits.size());
            for (Pair<Range<Token>, Long> split : splits) {
                result.add(new CfSplit(((Token)((Range)split.left).left).toString(), ((Token)((Range)split.left).right).toString(), ((Long)split.right).longValue()));
            }
            return result;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, TException {
        try {
            this.state().login(auth_request.getCredentials());
        }
        catch (org.apache.cassandra.exceptions.AuthenticationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    private void schedule(long timeoutMS) throws UnavailableException {
        try {
            this.requestScheduler.queue(Thread.currentThread(), this.state().getSchedulingValue(), timeoutMS);
        }
        catch (TimeoutException e) {
            throw new UnavailableException();
        }
    }

    private void release() {
        this.requestScheduler.release();
    }

    public String system_add_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("add_column_family");
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasKeyspaceAccess(keyspace, Permission.CREATE);
            cf_def.unsetId();
            CFMetaData cfm = CFMetaData.fromThrift(cf_def);
            cfm.addDefaultIndexNames();
            MigrationManager.announceNewColumnFamily(cfm);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_column_family(String column_family) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_column_family");
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.DROP);
            MigrationManager.announceColumnFamilyDrop(keyspace, column_family);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("add_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasAllKeyspacesAccess(Permission.CREATE);
            ThriftValidation.validateKeyspaceNotYetExisting(ks_def.name);
            for (CfDef cf : ks_def.cf_defs) {
                if (cf.getKeyspace().equals(ks_def.getName())) continue;
                throw new InvalidRequestException("CfDef (" + cf.getName() + ") had a keyspace definition that did not match KsDef");
            }
            ArrayList<CFMetaData> cfDefs = new ArrayList<CFMetaData>(ks_def.cf_defs.size());
            for (CfDef cf_def : ks_def.cf_defs) {
                cf_def.unsetId();
                CFMetaData cfm = CFMetaData.fromThrift(cf_def);
                cfm.addDefaultIndexNames();
                cfDefs.add(cfm);
            }
            MigrationManager.announceNewKeyspace(KSMetaData.fromThrift(ks_def, cfDefs.toArray(new CFMetaData[cfDefs.size()])));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(keyspace);
            this.state().hasKeyspaceAccess(keyspace, Permission.DROP);
            MigrationManager.announceKeyspaceDrop(keyspace);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasKeyspaceAccess(ks_def.name, Permission.ALTER);
            ThriftValidation.validateTable(ks_def.name);
            if (ks_def.getCf_defs() != null && ks_def.getCf_defs().size() > 0) {
                throw new InvalidRequestException("Keyspace update must not contain any column family definitions.");
            }
            MigrationManager.announceKeyspaceUpdate(KSMetaData.fromThrift(ks_def, new CFMetaData[0]));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_column_family");
        try {
            if (cf_def.keyspace == null || cf_def.name == null) {
                throw new InvalidRequestException("Keyspace and CF name must be set.");
            }
            CFMetaData oldCfm = Schema.instance.getCFMetaData(cf_def.keyspace, cf_def.name);
            if (oldCfm == null) {
                throw new InvalidRequestException("Could not find column family definition to modify.");
            }
            this.state().hasColumnFamilyAccess(cf_def.keyspace, cf_def.name, Permission.ALTER);
            CFMetaData.applyImplicitDefaults(cf_def);
            CFMetaData cfm = CFMetaData.fromThrift(cf_def);
            cfm.addDefaultIndexNames();
            MigrationManager.announceColumnFamilyUpdate(cfm);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, cfname, Permission.MODIFY);
            if (this.startSessionIfRequested()) {
                Tracing.instance().begin("truncate", (Map<String, String>)ImmutableMap.of((Object)"cf", (Object)cfname, (Object)"ks", (Object)keyspace));
            } else {
                logger.debug("truncating {}.{}", (Object)cState.getKeyspace(), (Object)cfname);
            }
            this.schedule(DatabaseDescriptor.getTruncateRpcTimeout());
            try {
                StorageProxy.truncateBlocking(cState.getKeyspace(), cfname);
            }
            finally {
                this.release();
            }
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (TimeoutException e) {
            logger.debug("... timed out");
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public void set_keyspace(String keyspace) throws InvalidRequestException, TException {
        try {
            ThriftValidation.validateTable(keyspace);
            this.state().setKeyspace(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, List<String>> describe_schema_versions() throws TException, InvalidRequestException {
        logger.debug("checking schema agreement");
        return StorageProxy.describeSchemaVersions();
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("add", (Map<String, String>)traceParameters);
        } else {
            logger.debug("add");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, true);
            ThriftValidation.validateKey(metadata, key);
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            if (metadata.cfType == ColumnFamilyType.Super && column_parent.super_column == null) {
                throw new InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
            }
            ThriftValidation.validateColumnNames(metadata, column_parent, Arrays.asList(column.name));
            RowMutation rm = new RowMutation(keyspace, key);
            try {
                rm.addCounter(new QueryPath(column_parent.column_family, column_parent.super_column, column.name), column.value);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
            this.doInsert(consistency_level, Arrays.asList(new CounterMutation(rm, ThriftConversion.fromThrift(consistency_level))));
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)path.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance().begin("remove_counter", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove_counter");
        }
        try {
            this.internal_remove(key, path, System.currentTimeMillis(), consistency_level, true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    private static String uncompress(ByteBuffer query, Compression compression) throws InvalidRequestException {
        String queryString = null;
        try {
            switch (compression) {
                case GZIP: {
                    DataOutputBuffer decompressed = new DataOutputBuffer();
                    byte[] outBuffer = new byte[1024];
                    byte[] inBuffer = new byte[1024];
                    Inflater decompressor = new Inflater();
                    int lenRead = 0;
                    do {
                        if (decompressor.needsInput()) {
                            lenRead = query.remaining() < 1024 ? query.remaining() : 1024;
                        }
                        query.get(inBuffer, 0, lenRead);
                        decompressor.setInput(inBuffer, 0, lenRead);
                        int lenWrite = 0;
                        while ((lenWrite = decompressor.inflate(outBuffer)) != 0) {
                            decompressed.write(outBuffer, 0, lenWrite);
                        }
                    } while (!decompressor.finished());
                    decompressor.end();
                    queryString = new String(decompressed.getData(), 0, decompressed.size(), "UTF-8");
                    break;
                }
                case NONE: {
                    try {
                        queryString = ByteBufferUtil.string(query);
                        break;
                    }
                    catch (CharacterCodingException ex) {
                        throw new InvalidRequestException(ex.getMessage());
                    }
                }
            }
        }
        catch (DataFormatException e) {
            throw new InvalidRequestException("Error deflating query string.");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unknown query string encoding.");
        }
        return queryString;
    }

    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        try {
            String queryString = CassandraServer.uncompress(query, compression);
            if (this.startSessionIfRequested()) {
                Tracing.instance().begin("execute_cql_query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)queryString));
            } else {
                logger.debug("execute_cql_query");
            }
            CqlResult cqlResult = org.apache.cassandra.cql.QueryProcessor.process(queryString, this.state());
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
            CqlResult cqlResult = null;
            return cqlResult;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public CqlResult execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel cLevel) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        try {
            String queryString = CassandraServer.uncompress(query, compression);
            if (this.startSessionIfRequested()) {
                Tracing.instance().begin("execute_cql3_query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)queryString));
            } else {
                logger.debug("execute_cql3_query");
            }
            ThriftClientState cState = this.state();
            CqlResult cqlResult = QueryProcessor.process(queryString, ThriftConversion.fromThrift(cLevel), cState.getQueryState()).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
            CqlResult cqlResult = null;
            return cqlResult;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public CqlPreparedResult prepare_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, TException {
        if (logger.isDebugEnabled()) {
            logger.debug("prepare_cql_query");
        }
        try {
            ThriftClientState cState = this.state();
            String queryString = CassandraServer.uncompress(query, compression);
            return org.apache.cassandra.cql.QueryProcessor.prepare(queryString, cState);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public CqlPreparedResult prepare_cql3_query(ByteBuffer query, Compression compression) throws InvalidRequestException, TException {
        if (logger.isDebugEnabled()) {
            logger.debug("prepare_cql3_query");
        }
        try {
            ThriftClientState cState = this.state();
            String queryString = CassandraServer.uncompress(query, compression);
            return QueryProcessor.prepare(queryString, cState, true).toThriftPreparedResult();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public CqlResult execute_prepared_cql_query(int itemId, List<ByteBuffer> bindVariables) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        if (this.startSessionIfRequested()) {
            Tracing.instance().begin("execute_prepared_cql_query", Collections.<String, String>emptyMap());
        } else {
            logger.debug("execute_prepared_cql_query");
        }
        try {
            ThriftClientState cState = this.state();
            org.apache.cassandra.cql.CQLStatement statement = cState.getPrepared().get(itemId);
            if (statement == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found", itemId));
            }
            logger.trace("Retrieved prepared statement #{} with {} bind markers", (Object)itemId, (Object)statement.boundTerms);
            CqlResult cqlResult = org.apache.cassandra.cql.QueryProcessor.processPrepared(statement, cState, bindVariables);
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
            CqlResult cqlResult = null;
            return cqlResult;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public CqlResult execute_prepared_cql3_query(int itemId, List<ByteBuffer> bindVariables, ConsistencyLevel cLevel) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        if (this.startSessionIfRequested()) {
            Tracing.instance().begin("execute_prepared_cql3_query", Collections.<String, String>emptyMap());
        } else {
            logger.debug("execute_prepared_cql3_query");
        }
        try {
            ThriftClientState cState = this.state();
            CQLStatement statement = QueryProcessor.getPrepared(itemId);
            if (statement == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found (either the query was not prepared on this host (maybe the host has been restarted?) or you have prepared more than %d queries and queries %d has been evicted from the internal cache)", itemId, 100000, itemId));
            }
            logger.trace("Retrieved prepared statement #{} with {} bind markers", (Object)itemId, (Object)statement.getBoundsTerms());
            CqlResult cqlResult = QueryProcessor.processPrepared(statement, ThriftConversion.fromThrift(cLevel), cState.getQueryState(), bindVariables).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
            CqlResult cqlResult = null;
            return cqlResult;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public void set_cql_version(String version) throws InvalidRequestException {
    }

    public ByteBuffer trace_next_query() throws TException {
        UUID sessionId = UUIDGen.getTimeUUID();
        this.state().getQueryState().prepareTracingSession(sessionId);
        return TimeUUIDType.instance.decompose(sessionId);
    }

    private boolean startSessionIfRequested() {
        if (this.state().getQueryState().traceNextQuery()) {
            this.state().getQueryState().createTracingSession();
            return true;
        }
        return false;
    }
}

