/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata {
    public static final String PIG_INPUT_RPC_PORT = "PIG_INPUT_RPC_PORT";
    public static final String PIG_INPUT_INITIAL_ADDRESS = "PIG_INPUT_INITIAL_ADDRESS";
    public static final String PIG_INPUT_PARTITIONER = "PIG_INPUT_PARTITIONER";
    public static final String PIG_OUTPUT_RPC_PORT = "PIG_OUTPUT_RPC_PORT";
    public static final String PIG_OUTPUT_INITIAL_ADDRESS = "PIG_OUTPUT_INITIAL_ADDRESS";
    public static final String PIG_OUTPUT_PARTITIONER = "PIG_OUTPUT_PARTITIONER";
    public static final String PIG_RPC_PORT = "PIG_RPC_PORT";
    public static final String PIG_INITIAL_ADDRESS = "PIG_INITIAL_ADDRESS";
    public static final String PIG_PARTITIONER = "PIG_PARTITIONER";
    public static final String PIG_INPUT_FORMAT = "PIG_INPUT_FORMAT";
    public static final String PIG_OUTPUT_FORMAT = "PIG_OUTPUT_FORMAT";
    public static final String PIG_INPUT_SPLIT_SIZE = "PIG_INPUT_SPLIT_SIZE";
    protected String DEFAULT_INPUT_FORMAT;
    protected String DEFAULT_OUTPUT_FORMAT;
    public static final String PARTITION_FILTER_SIGNATURE = "cassandra.partition.filter";
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCassandraStorage.class);
    protected String username;
    protected String password;
    protected String keyspace;
    protected String column_family;
    protected String loadSignature;
    protected String storeSignature;
    protected Configuration conf;
    protected String inputFormatClass;
    protected String outputFormatClass;
    protected int splitSize = 65536;
    protected String partitionerClass;
    protected boolean usePartitionFilter = false;

    protected Tuple composeComposite(AbstractCompositeType comparator, ByteBuffer name) throws IOException {
        List<AbstractCompositeType.CompositeComponent> result = comparator.deconstruct(name);
        Tuple t = TupleFactory.getInstance().newTuple(result.size());
        for (int i = 0; i < result.size(); ++i) {
            this.setTupleValue(t, i, result.get((int)i).comparator.compose(result.get((int)i).value));
        }
        return t;
    }

    protected Tuple columnToTuple(IColumn col, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple pair = TupleFactory.getInstance().newTuple(2);
        if (comparator instanceof AbstractCompositeType) {
            this.setTupleValue(pair, 0, this.composeComposite((AbstractCompositeType)comparator, col.name()));
        } else {
            this.setTupleValue(pair, 0, comparator.compose(col.name()));
        }
        if (col instanceof org.apache.cassandra.db.Column) {
            Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
            if (validators.get(col.name()) == null) {
                Map<MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
                this.setTupleValue(pair, 1, marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR).compose(col.value()));
            } else {
                this.setTupleValue(pair, 1, validators.get(col.name()).compose(col.value()));
            }
            return pair;
        }
        ArrayList<Tuple> subcols = new ArrayList<Tuple>();
        for (IColumn subcol : col.getSubColumns()) {
            subcols.add(this.columnToTuple(subcol, cfDef, this.parseType(cfDef.getSubcomparator_type())));
        }
        pair.set(1, (Object)new DefaultDataBag(subcols));
        return pair;
    }

    protected void setTupleValue(Tuple pair, int position, Object value) throws ExecException {
        if (value instanceof BigInteger) {
            pair.set(position, (Object)((BigInteger)value).intValue());
        } else if (value instanceof ByteBuffer) {
            pair.set(position, (Object)new DataByteArray(ByteBufferUtil.getArray((ByteBuffer)value)));
        } else if (value instanceof UUID) {
            pair.set(position, (Object)new DataByteArray(UUIDGen.decompose((UUID)value)));
        } else if (value instanceof Date) {
            pair.set(position, (Object)DateType.instance.decompose((Date)value).getLong());
        } else {
            pair.set(position, value);
        }
    }

    protected CfDef getCfDef(String signature) {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(AbstractCassandraStorage.class);
        return AbstractCassandraStorage.cfdefFromString(property.getProperty(signature));
    }

    protected Map<MarshallerType, AbstractType> getDefaultMarshallers(CfDef cfDef) throws IOException {
        EnumMap<MarshallerType, AbstractType> marshallers = new EnumMap<MarshallerType, AbstractType>(MarshallerType.class);
        AbstractType comparator = this.parseType(cfDef.getComparator_type());
        AbstractType subcomparator = this.parseType(cfDef.getSubcomparator_type());
        AbstractType default_validator = this.parseType(cfDef.getDefault_validation_class());
        AbstractType key_validator = this.parseType(cfDef.getKey_validation_class());
        marshallers.put(MarshallerType.COMPARATOR, comparator);
        marshallers.put(MarshallerType.DEFAULT_VALIDATOR, default_validator);
        marshallers.put(MarshallerType.KEY_VALIDATOR, key_validator);
        marshallers.put(MarshallerType.SUBCOMPARATOR, subcomparator);
        return marshallers;
    }

    protected Map<ByteBuffer, AbstractType> getValidatorMap(CfDef cfDef) throws IOException {
        HashMap<ByteBuffer, AbstractType> validators = new HashMap<ByteBuffer, AbstractType>();
        for (ColumnDef cd : cfDef.getColumn_metadata()) {
            if (cd.getValidation_class() == null || cd.getValidation_class().isEmpty()) continue;
            LongType validator = null;
            try {
                validator = TypeParser.parse(cd.getValidation_class());
                if (validator instanceof CounterColumnType) {
                    validator = LongType.instance;
                }
                validators.put(cd.name, validator);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            catch (SyntaxException e) {
                throw new IOException(e);
            }
        }
        return validators;
    }

    protected AbstractType parseType(String type) throws IOException {
        try {
            if (type != null && type.equals("org.apache.cassandra.db.marshal.CounterColumnType")) {
                return LongType.instance;
            }
            return TypeParser.parse(type);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        catch (SyntaxException e) {
            throw new IOException(e);
        }
    }

    public InputFormat getInputFormat() {
        try {
            return (InputFormat)FBUtilities.construct(this.inputFormatClass, "inputformat");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getQueryMap(String query) throws UnsupportedEncodingException {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] keyValue = param.split("=");
            map.put(keyValue[0], URLDecoder.decode(keyValue[1], "UTF-8"));
        }
        return map;
    }

    protected void setConnectionInformation() throws IOException {
        if (System.getenv(PIG_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(this.conf, System.getenv(PIG_RPC_PORT));
            ConfigHelper.setOutputRpcPort(this.conf, System.getenv(PIG_RPC_PORT));
        }
        if (System.getenv(PIG_INPUT_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(this.conf, System.getenv(PIG_INPUT_RPC_PORT));
        }
        if (System.getenv(PIG_OUTPUT_RPC_PORT) != null) {
            ConfigHelper.setOutputRpcPort(this.conf, System.getenv(PIG_OUTPUT_RPC_PORT));
        }
        if (System.getenv(PIG_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(this.conf, System.getenv(PIG_INITIAL_ADDRESS));
            ConfigHelper.setOutputInitialAddress(this.conf, System.getenv(PIG_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_INPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(this.conf, System.getenv(PIG_INPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_OUTPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setOutputInitialAddress(this.conf, System.getenv(PIG_OUTPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(this.conf, System.getenv(PIG_PARTITIONER));
            ConfigHelper.setOutputPartitioner(this.conf, System.getenv(PIG_PARTITIONER));
        }
        if (System.getenv(PIG_INPUT_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(this.conf, System.getenv(PIG_INPUT_PARTITIONER));
        }
        if (System.getenv(PIG_OUTPUT_PARTITIONER) != null) {
            ConfigHelper.setOutputPartitioner(this.conf, System.getenv(PIG_OUTPUT_PARTITIONER));
        }
        this.inputFormatClass = System.getenv(PIG_INPUT_FORMAT) != null ? this.getFullyQualifiedClassName(System.getenv(PIG_INPUT_FORMAT)) : this.DEFAULT_INPUT_FORMAT;
        this.outputFormatClass = System.getenv(PIG_OUTPUT_FORMAT) != null ? this.getFullyQualifiedClassName(System.getenv(PIG_OUTPUT_FORMAT)) : this.DEFAULT_OUTPUT_FORMAT;
    }

    protected String getFullyQualifiedClassName(String classname) {
        return classname.contains(".") ? classname : "org.apache.cassandra.hadoop." + classname;
    }

    protected byte getPigType(AbstractType type) {
        if (type instanceof LongType || type instanceof DateType) {
            return 15;
        }
        if (type instanceof IntegerType || type instanceof Int32Type) {
            return 10;
        }
        if (type instanceof AsciiType) {
            return 55;
        }
        if (type instanceof UTF8Type) {
            return 55;
        }
        if (type instanceof FloatType) {
            return 20;
        }
        if (type instanceof DoubleType) {
            return 25;
        }
        if (type instanceof AbstractCompositeType || type instanceof CollectionType) {
            return 110;
        }
        return 50;
    }

    public ResourceStatistics getStatistics(String location, Job job) {
        return null;
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public void setUDFContextSignature(String signature) {
        this.loadSignature = signature;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.storeSignature = signature;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return this.relativeToAbsolutePath(location, curDir);
    }

    public OutputFormat getOutputFormat() {
        try {
            return (OutputFormat)FBUtilities.construct(this.outputFormatClass, "outputformat");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
    }

    protected ByteBuffer objToBB(Object o) {
        if (o == null) {
            return (ByteBuffer)o;
        }
        if (o instanceof String) {
            return ByteBuffer.wrap(new DataByteArray((String)o).get());
        }
        if (o instanceof Integer) {
            return Int32Type.instance.decompose((Integer)o);
        }
        if (o instanceof Long) {
            return LongType.instance.decompose((Long)o);
        }
        if (o instanceof Float) {
            return FloatType.instance.decompose((Float)o);
        }
        if (o instanceof Double) {
            return DoubleType.instance.decompose((Double)o);
        }
        if (o instanceof UUID) {
            return ByteBuffer.wrap(UUIDGen.decompose((UUID)o));
        }
        if (o instanceof Tuple) {
            List objects = ((Tuple)o).getAll();
            if (objects.size() > 0 && objects.get(0) instanceof String) {
                String collectionType = (String)objects.get(0);
                if ("set".equalsIgnoreCase(collectionType) || "list".equalsIgnoreCase(collectionType)) {
                    return this.objToListOrSetBB(objects.subList(1, objects.size()));
                }
                if ("map".equalsIgnoreCase(collectionType)) {
                    return this.objToMapBB(objects.subList(1, objects.size()));
                }
            }
            return this.objToCompositeBB(objects);
        }
        return ByteBuffer.wrap(((DataByteArray)o).get());
    }

    private ByteBuffer objToListOrSetBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
        }
        return CollectionType.pack(serialized, objects.size());
    }

    private ByteBuffer objToMapBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size() * 2);
        for (Object sub : objects) {
            List keyValue = ((Tuple)sub).getAll();
            for (Object entry : keyValue) {
                ByteBuffer buffer = this.objToBB(entry);
                serialized.add(buffer);
            }
        }
        return CollectionType.pack(serialized, objects.size());
    }

    private ByteBuffer objToCompositeBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        int totalLength = 0;
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
            totalLength += 2 + buffer.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : serialized) {
            int length = bb.remaining();
            out.put((byte)(length >> 8 & 0xFF));
            out.put((byte)(length & 0xFF));
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    public void cleanupOnFailure(String failure, Job job) {
    }

    protected void initSchema(String signature) {
        Properties properties = UDFContext.getUDFContext().getUDFProperties(AbstractCassandraStorage.class);
        if (!properties.containsKey(signature)) {
            try {
                CfDef cfDef;
                Cassandra.Client client = ConfigHelper.getClientFromInputAddressList(this.conf);
                client.set_keyspace(this.keyspace);
                if (this.username != null && this.password != null) {
                    HashMap<String, String> credentials = new HashMap<String, String>(2);
                    credentials.put("username", this.username);
                    credentials.put("password", this.password);
                    try {
                        client.login(new AuthenticationRequest(credentials));
                    }
                    catch (AuthenticationException e) {
                        logger.error("Authentication exception: invalid username and/or password");
                        throw new RuntimeException(e);
                    }
                    catch (AuthorizationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                if ((cfDef = this.getCfDef(client)) == null) {
                    throw new RuntimeException(String.format("Column family '%s' not found in keyspace '%s'", this.column_family, this.keyspace));
                }
                properties.setProperty(signature, AbstractCassandraStorage.cfdefToString(cfDef));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static String cfdefToString(CfDef cfDef) {
        assert (cfDef != null);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)cfDef));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    protected static CfDef cfdefFromString(String st) {
        assert (st != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        CfDef cfDef = new CfDef();
        try {
            deserializer.deserialize((TBase)cfDef, Hex.hexToBytes(st));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return cfDef;
    }

    protected CfDef getCfDef(Cassandra.Client client) throws org.apache.cassandra.thrift.InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException, NotFoundException, InvalidRequestException, ConfigurationException {
        String query = "SELECT type,       comparator,       subcomparator,       default_validator,       key_validator,       key_aliases,       key_alias FROM system.schema_columnfamilies WHERE keyspace_name = '%s'   AND columnfamily_name = '%s' ";
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(String.format(query, this.keyspace, this.column_family)), Compression.NONE, ConsistencyLevel.ONE);
        if (result == null || result.rows == null || result.rows.isEmpty()) {
            return null;
        }
        Iterator iteraRow = result.rows.iterator();
        CfDef cfDef = new CfDef();
        cfDef.keyspace = this.keyspace;
        cfDef.name = this.column_family;
        boolean cql3Table = false;
        if (iteraRow.hasNext()) {
            CqlRow cqlRow = (CqlRow)iteraRow.next();
            cfDef.column_type = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)0)).value);
            cfDef.comparator_type = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)1)).value);
            ByteBuffer subComparator = ((Column)cqlRow.columns.get((int)2)).value;
            if (subComparator != null) {
                cfDef.subcomparator_type = ByteBufferUtil.string(subComparator);
            }
            cfDef.default_validation_class = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)3)).value);
            cfDef.key_validation_class = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)4)).value);
            List<String> keys = null;
            if (((Column)cqlRow.columns.get((int)5)).value != null) {
                String keyAliases = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)5)).value);
                keys = FBUtilities.fromJsonList(keyAliases);
                if (keys.size() == 0 && ((Column)cqlRow.columns.get((int)6)).value == null) {
                    CFDefinition cfDefinition = this.getCfDefinition(this.keyspace, this.column_family, client);
                    for (ColumnIdentifier column : cfDefinition.keys.keySet()) {
                        String key = column.toString();
                        String type = cfDefinition.keys.get((Object)column).type.toString();
                        logger.debug("name: {}, type: {} ", (Object)key, (Object)type);
                        keys.add(key);
                    }
                } else {
                    cql3Table = true;
                }
            } else {
                String keyAlias = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)6)).value);
                keys = new ArrayList<String>(1);
                keys.add(keyAlias);
            }
        }
        cfDef.column_metadata = this.getColumnMetadata(client, cql3Table);
        return cfDef;
    }

    protected abstract List<ColumnDef> getColumnMetadata(Cassandra.Client var1, boolean var2) throws org.apache.cassandra.thrift.InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException, InvalidRequestException, ConfigurationException, NotFoundException;

    protected List<ColumnDef> getColumnMeta(Cassandra.Client client, boolean cassandraStorage) throws org.apache.cassandra.thrift.InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException, InvalidRequestException, ConfigurationException, NotFoundException {
        String query = "SELECT column_name,        validator,        index_type FROM system.schema_columns WHERE keyspace_name = '%s'   AND columnfamily_name = '%s'";
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(String.format(query, this.keyspace, this.column_family)), Compression.NONE, ConsistencyLevel.ONE);
        List rows = result.rows;
        ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
        if (!cassandraStorage && (rows == null || rows.isEmpty())) {
            CFDefinition cfDefinition = this.getCfDefinition(this.keyspace, this.column_family, client);
            for (ColumnIdentifier column : cfDefinition.metadata.keySet()) {
                ColumnDef cDef = new ColumnDef();
                String columnName = column.toString();
                String type = cfDefinition.metadata.get((Object)column).type.toString();
                logger.debug("name: {}, type: {} ", (Object)columnName, (Object)type);
                cDef.name = ByteBufferUtil.bytes(columnName);
                cDef.validation_class = type;
                columnDefs.add(cDef);
            }
            if (columnDefs.size() == 0) {
                String value;
                String string = value = cfDefinition.value != null ? cfDefinition.value.toString() : null;
                if ("value".equals(value)) {
                    ColumnDef cDef = new ColumnDef();
                    cDef.name = ByteBufferUtil.bytes(value);
                    cDef.validation_class = cfDefinition.value.type.toString();
                    columnDefs.add(cDef);
                }
            }
            return columnDefs;
        }
        if (rows == null || rows.isEmpty()) {
            return columnDefs;
        }
        for (CqlRow row : rows) {
            ColumnDef cDef = new ColumnDef();
            cDef.setName(ByteBufferUtil.clone(((Column)row.getColumns().get((int)0)).value));
            cDef.validation_class = ByteBufferUtil.string(((Column)row.getColumns().get((int)1)).value);
            ByteBuffer indexType = ((Column)row.getColumns().get((int)2)).value;
            if (indexType != null) {
                cDef.index_type = this.getIndexType(ByteBufferUtil.string(indexType));
            }
            columnDefs.add(cDef);
        }
        return columnDefs;
    }

    protected List<ColumnDef> getKeysMeta(Cassandra.Client client) throws Exception {
        String query = "SELECT key_aliases,        column_aliases,        key_validator,        comparator,        keyspace_name,        value_alias,        default_validator,       key_alias  FROM system.schema_columnfamilies WHERE keyspace_name = '%s'  AND columnfamily_name = '%s' ";
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(String.format(query, this.keyspace, this.column_family)), Compression.NONE, ConsistencyLevel.ONE);
        if (result == null || result.rows == null || result.rows.isEmpty()) {
            return null;
        }
        List rows = result.rows;
        Iterator iteraRow = rows.iterator();
        ArrayList<ColumnDef> keys = new ArrayList<ColumnDef>();
        if (iteraRow.hasNext()) {
            Iterator<String> iterator;
            List<String> keyNames;
            String keyString;
            ColumnDef cDef;
            CqlRow cqlRow = (CqlRow)iteraRow.next();
            String name = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)4)).value);
            logger.debug("Found ksDef name: {}", (Object)name);
            if (((Column)cqlRow.columns.get(0)).getValue() == null) {
                cDef = new ColumnDef();
                cDef.name = ByteBuffer.wrap(((Column)((CqlRow)result.rows.get((int)0)).columns.get(7)).getValue());
                keys.add(cDef);
            } else {
                keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(0)).getValue()));
                logger.debug("partition keys: {}", (Object)keyString);
                keyNames = FBUtilities.fromJsonList(keyString);
                iterator = keyNames.iterator();
                while (iterator.hasNext()) {
                    cDef = new ColumnDef();
                    cDef.name = ByteBufferUtil.bytes(iterator.next());
                    keys.add(cDef);
                }
                if (keys.size() == 0) {
                    ColumnDef cDef2;
                    String key;
                    CFDefinition cfDefinition = this.getCfDefinition(this.keyspace, this.column_family, client);
                    for (ColumnIdentifier column : cfDefinition.keys.keySet()) {
                        key = column.toString();
                        logger.debug("name: {} ", (Object)key);
                        cDef2 = new ColumnDef();
                        cDef2.name = ByteBufferUtil.bytes(key);
                        keys.add(cDef2);
                    }
                    for (ColumnIdentifier column : cfDefinition.columns.keySet()) {
                        key = column.toString();
                        logger.debug("name: {} ", (Object)key);
                        cDef2 = new ColumnDef();
                        cDef2.name = ByteBufferUtil.bytes(key);
                        keys.add(cDef2);
                    }
                }
            }
            keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(1)).getValue()));
            logger.debug("cluster keys: {}", (Object)keyString);
            keyNames = FBUtilities.fromJsonList(keyString);
            iterator = keyNames.iterator();
            while (iterator.hasNext()) {
                cDef = new ColumnDef();
                cDef.name = ByteBufferUtil.bytes(iterator.next());
                keys.add(cDef);
            }
            String validator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(2)).getValue()));
            logger.debug("row key validator: {}", (Object)validator);
            AbstractType keyValidator = this.parseType(validator);
            Iterator keyItera = keys.iterator();
            if (keyValidator instanceof CompositeType) {
                Iterator<AbstractType<?>> typeItera = ((CompositeType)keyValidator).types.iterator();
                while (typeItera.hasNext()) {
                    ((ColumnDef)keyItera.next()).validation_class = typeItera.next().toString();
                }
            } else {
                ((ColumnDef)keyItera.next()).validation_class = keyValidator.toString();
            }
            validator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(3)).getValue()));
            logger.debug("cluster key validator: {}", (Object)validator);
            if (keyItera.hasNext() && validator != null && !validator.isEmpty()) {
                AbstractType clusterKeyValidator = this.parseType(validator);
                if (clusterKeyValidator instanceof CompositeType) {
                    Iterator<AbstractType<?>> typeItera = ((CompositeType)clusterKeyValidator).types.iterator();
                    while (keyItera.hasNext()) {
                        ((ColumnDef)keyItera.next()).validation_class = typeItera.next().toString();
                    }
                } else {
                    ((ColumnDef)keyItera.next()).validation_class = clusterKeyValidator.toString();
                }
            }
            if (((Column)cqlRow.columns.get((int)5)).value != null) {
                try {
                    String compactValidator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(6)).getValue()));
                    logger.debug("default validator: {}", (Object)compactValidator);
                    AbstractType defaultValidator = this.parseType(compactValidator);
                    ColumnDef cDef3 = new ColumnDef();
                    cDef3.name = ((Column)cqlRow.columns.get((int)5)).value;
                    cDef3.validation_class = defaultValidator.toString();
                    keys.add(cDef3);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return keys;
    }

    protected IndexType getIndexType(String type) {
        if ("keys".equals(type = type.toLowerCase())) {
            return IndexType.KEYS;
        }
        if ("custom".equals(type)) {
            return IndexType.CUSTOM;
        }
        if ("composites".equals(type)) {
            return IndexType.COMPOSITES;
        }
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) {
        if (!this.usePartitionFilter) {
            return null;
        }
        List<ColumnDef> indexes = this.getIndexes();
        String[] partitionKeys = new String[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            partitionKeys[i] = new String(indexes.get(i).getName());
        }
        return partitionKeys;
    }

    protected List<ColumnDef> getIndexes() {
        CfDef cfdef = this.getCfDef(this.loadSignature);
        ArrayList<ColumnDef> indexes = new ArrayList<ColumnDef>();
        for (ColumnDef cdef : cfdef.column_metadata) {
            if (cdef.index_type == null) continue;
            indexes.add(cdef);
        }
        return indexes;
    }

    private CFDefinition getCfDefinition(String ks, String cf, Cassandra.Client client) throws NotFoundException, org.apache.cassandra.thrift.InvalidRequestException, TException, InvalidRequestException, ConfigurationException {
        KsDef ksDef = client.describe_keyspace(ks);
        for (CfDef cfDef : ksDef.cf_defs) {
            if (!cfDef.name.equalsIgnoreCase(cf)) continue;
            return new CFDefinition(CFMetaData.fromThrift(cfDef));
        }
        return null;
    }

    protected static enum MarshallerType {
        COMPARATOR,
        DEFAULT_VALIDATOR,
        KEY_VALIDATOR,
        SUBCOMPARATOR;

    }
}

