/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTables;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnDefinition {
    public final ByteBuffer name;
    private AbstractType<?> validator;
    private IndexType index_type;
    private Map<String, String> index_options;
    private String index_name;
    public final Type type;
    public final Integer componentIndex;

    public static ColumnDefinition partitionKeyDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.PARTITION_KEY);
    }

    public static ColumnDefinition clusteringKeyDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.CLUSTERING_KEY);
    }

    public static ColumnDefinition regularDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.REGULAR);
    }

    public static ColumnDefinition compactValueDef(ByteBuffer name, AbstractType<?> validator) {
        return new ColumnDefinition(name, validator, null, Type.COMPACT_VALUE);
    }

    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, Integer componentIndex, Type type) {
        this(name, validator, null, null, null, componentIndex, type);
    }

    @VisibleForTesting
    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, IndexType index_type, Map<String, String> index_options, String index_name, Integer componentIndex, Type type) {
        assert (name != null && validator != null);
        this.name = name;
        this.index_name = index_name;
        this.validator = validator;
        this.componentIndex = componentIndex;
        this.setIndexType(index_type, index_options);
        this.type = type;
    }

    public ColumnDefinition clone() {
        return new ColumnDefinition(this.name, this.validator, this.index_type, this.index_options, this.index_name, this.componentIndex, this.type);
    }

    public ColumnDefinition cloneWithNewName(ByteBuffer newName) {
        return new ColumnDefinition(newName, this.validator, this.index_type, this.index_options, this.index_name, this.componentIndex, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.validator, that.validator) && Objects.equal((Object)this.componentIndex, (Object)that.componentIndex) && Objects.equal((Object)this.index_name, (Object)that.index_name) && Objects.equal((Object)this.index_type, (Object)that.index_type) && Objects.equal(this.index_options, that.index_options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.validator, this.componentIndex, this.index_name, this.index_type, this.index_options});
    }

    public boolean isThriftCompatible() {
        return this.type == Type.REGULAR && this.componentIndex == null;
    }

    public ColumnDef toThrift() {
        ColumnDef cd = new ColumnDef();
        cd.setName(ByteBufferUtil.clone(this.name));
        cd.setValidation_class(this.validator.toString());
        cd.setIndex_type(this.index_type == null ? null : IndexType.valueOf((String)this.index_type.name()));
        cd.setIndex_name(this.index_name == null ? null : this.index_name);
        cd.setIndex_options(this.index_options == null ? null : Maps.newHashMap(this.index_options));
        return cd;
    }

    public static ColumnDefinition fromThrift(ColumnDef thriftColumnDef, boolean isSuper) throws SyntaxException, ConfigurationException {
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type, thriftColumnDef.index_options, thriftColumnDef.index_name, isSuper ? Integer.valueOf(1) : null, Type.REGULAR);
    }

    public static Map<ByteBuffer, ColumnDefinition> fromThrift(List<ColumnDef> thriftDefs, boolean isSuper) throws SyntaxException, ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromThrift(thriftColumnDef, isSuper));
        }
        return cds;
    }

    public void deleteFromSchema(RowMutation rm, String cfName, AbstractType<?> comparator, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columns");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        ColumnNameBuilder builder = CFMetaData.SchemaColumnsCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(this.name);
        cf.addAtom(new RangeTombstone(builder.build(), builder.buildAsEndOfRange(), timestamp, ldt));
    }

    public void toSchema(RowMutation rm, String cfName, AbstractType<?> comparator, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columns");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(Column.create("", timestamp, cfName, comparator.getString(this.name), ""));
        cf.addColumn(Column.create(this.validator.toString(), timestamp, cfName, comparator.getString(this.name), "validator"));
        cf.addColumn(this.index_type == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_type") : Column.create(this.index_type.toString(), timestamp, cfName, comparator.getString(this.name), "index_type"));
        cf.addColumn(this.index_options == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_options") : Column.create(FBUtilities.json(this.index_options), timestamp, cfName, comparator.getString(this.name), "index_options"));
        cf.addColumn(this.index_name == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_name") : Column.create(this.index_name, timestamp, cfName, comparator.getString(this.name), "index_name"));
        cf.addColumn(this.componentIndex == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "component_index") : Column.create(this.componentIndex, timestamp, cfName, comparator.getString(this.name), "component_index"));
        cf.addColumn(Column.create(this.type.toString().toLowerCase(), timestamp, cfName, comparator.getString(this.name), "type"));
    }

    public void apply(ColumnDefinition def, AbstractType<?> comparator) throws ConfigurationException {
        assert (this.type == def.type && Objects.equal((Object)this.componentIndex, (Object)def.componentIndex));
        if (this.getIndexType() != null && def.getIndexType() != null) {
            if (!def.getValidator().isCompatibleWith(this.getValidator())) {
                throw new ConfigurationException(String.format("Cannot modify validator to a non-compatible one for column %s since an index is set", comparator.getString(this.name)));
            }
            assert (this.getIndexName() != null);
            if (!this.getIndexName().equals(def.getIndexName())) {
                throw new ConfigurationException("Cannot modify index name");
            }
        }
        this.setValidator(def.getValidator());
        this.setIndexType(def.getIndexType(), def.getIndexOptions());
        this.setIndexName(def.getIndexName());
    }

    public static List<ColumnDefinition> fromSchema(Row row, CFMetaData cfm) {
        if (row.cf == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDefinition> cds = new ArrayList<ColumnDefinition>();
        for (UntypedResultSet.Row result : QueryProcessor.resultify("SELECT * FROM system.schema_columns", row)) {
            try {
                Type type;
                IndexType index_type = null;
                Map<String, String> index_options = null;
                String index_name = null;
                Integer componentIndex = null;
                Type type2 = type = result.has("type") ? Enum.valueOf(Type.class, result.getString("type").toUpperCase()) : Type.REGULAR;
                if (result.has("index_type")) {
                    index_type = IndexType.valueOf((String)result.getString("index_type"));
                }
                if (result.has("index_options")) {
                    index_options = FBUtilities.fromJsonMap(result.getString("index_options"));
                }
                if (result.has("index_name")) {
                    index_name = result.getString("index_name");
                }
                if (result.has("component_index")) {
                    componentIndex = result.getInt("component_index");
                } else if (type == Type.CLUSTERING_KEY && cfm.isSuper()) {
                    componentIndex = 1;
                }
                cds.add(new ColumnDefinition(cfm.getComponentComparator(componentIndex, type).fromString(result.getString("column_name")), TypeParser.parse(result.getString("validator")), index_type, index_options, index_name, componentIndex, type));
            }
            catch (RequestValidationException e) {
                throw new RuntimeException(e);
            }
        }
        return cds;
    }

    public static Row readSchema(String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemKeyspace.getSchemaKSKey(ksName));
        ColumnFamilyStore columnsStore = SystemKeyspace.schemaCFS("schema_columns");
        ColumnFamily cf = columnsStore.getColumnFamily(key, DefsTables.searchComposite(cfName, true), DefsTables.searchComposite(cfName, false), false, Integer.MAX_VALUE, System.currentTimeMillis());
        return new Row(key, cf);
    }

    public String toString() {
        return "ColumnDefinition{name=" + ByteBufferUtil.bytesToHex(this.name) + ", validator=" + this.validator + ", index_type=" + this.index_type + ", index_name='" + this.index_name + '\'' + (this.componentIndex != null ? ", component_index=" + this.componentIndex : "") + ", type=" + (Object)((Object)this.type) + '}';
    }

    public String getIndexName() {
        return this.index_name;
    }

    public ColumnDefinition setIndexName(String s) {
        this.index_name = s;
        return this;
    }

    public ColumnDefinition setIndexType(IndexType index_type, Map<String, String> index_options) {
        this.index_type = index_type;
        this.index_options = index_options;
        return this;
    }

    public ColumnDefinition setIndex(String s, IndexType index_type, Map<String, String> index_options) {
        return this.setIndexName(s).setIndexType(index_type, index_options);
    }

    public boolean isIndexed() {
        return this.index_type != null;
    }

    public IndexType getIndexType() {
        return this.index_type;
    }

    public Map<String, String> getIndexOptions() {
        return this.index_options;
    }

    public AbstractType<?> getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType<?> validator) {
        this.validator = validator;
    }

    public static enum Type {
        PARTITION_KEY,
        CLUSTERING_KEY,
        REGULAR,
        COMPACT_VALUE;

    }
}

