/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class UntypedResultSet
implements Iterable<Row> {
    private final ResultSet cqlRows;

    public UntypedResultSet(ResultSet cqlRows) {
        this.cqlRows = cqlRows;
    }

    public boolean isEmpty() {
        return this.cqlRows.size() == 0;
    }

    public int size() {
        return this.cqlRows.size();
    }

    public Row one() {
        if (this.cqlRows.rows.size() != 1) {
            throw new IllegalStateException("One row required, " + this.cqlRows.rows.size() + " found");
        }
        return new Row(this.cqlRows.metadata.names, this.cqlRows.rows.get(0));
    }

    @Override
    public Iterator<Row> iterator() {
        return new AbstractIterator<Row>(){
            Iterator<List<ByteBuffer>> iter;
            {
                this.iter = ((UntypedResultSet)UntypedResultSet.this).cqlRows.rows.iterator();
            }

            protected Row computeNext() {
                if (!this.iter.hasNext()) {
                    return (Row)this.endOfData();
                }
                return new Row(((UntypedResultSet)UntypedResultSet.this).cqlRows.metadata.names, this.iter.next());
            }
        };
    }

    public static class Row {
        Map<String, ByteBuffer> data = new HashMap<String, ByteBuffer>();

        public Row(List<ColumnSpecification> names, List<ByteBuffer> columns) {
            for (int i = 0; i < names.size(); ++i) {
                this.data.put(names.get(i).toString(), columns.get(i));
            }
        }

        public boolean has(String column) {
            return this.data.get(column) != null;
        }

        public String getString(String column) {
            return UTF8Type.instance.compose(this.data.get(column));
        }

        public boolean getBoolean(String column) {
            return BooleanType.instance.compose(this.data.get(column));
        }

        public int getInt(String column) {
            return Int32Type.instance.compose(this.data.get(column));
        }

        public double getDouble(String column) {
            return DoubleType.instance.compose(this.data.get(column));
        }

        public ByteBuffer getBytes(String column) {
            return this.data.get(column);
        }

        public InetAddress getInetAddress(String column) {
            return InetAddressType.instance.compose(this.data.get(column));
        }

        public UUID getUUID(String column) {
            return UUIDType.instance.compose(this.data.get(column));
        }

        public Date getTimestamp(String column) {
            return TimestampType.instance.compose(this.data.get(column));
        }

        public long getLong(String column) {
            return LongType.instance.compose(this.data.get(column));
        }

        public <T> Set<T> getSet(String column, AbstractType<T> type) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : SetType.getInstance(type).compose(raw);
        }

        public <K, V> Map<K, V> getMap(String column, AbstractType<K> keyType, AbstractType<V> valueType) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : MapType.getInstance(keyType, valueType).compose(raw);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

