/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RetriedSliceFromReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommandSerializer;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceFromReadCommand
extends ReadCommand {
    static final Logger logger = LoggerFactory.getLogger(SliceFromReadCommand.class);
    static final SliceFromReadCommandSerializer serializer = new SliceFromReadCommandSerializer();
    public final SliceQueryFilter filter;

    public SliceFromReadCommand(String keyspaceName, ByteBuffer key, String cfName, long timestamp, SliceQueryFilter filter) {
        super(keyspaceName, key, cfName, timestamp, ReadCommand.Type.GET_SLICES);
        this.filter = filter;
    }

    @Override
    public ReadCommand copy() {
        SliceFromReadCommand readCommand = new SliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, this.filter);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Keyspace keyspace) {
        DecoratedKey dk = StorageService.getPartitioner().decorateKey(this.key);
        return keyspace.getRow(new QueryFilter(dk, this.cfName, this.filter, this.timestamp));
    }

    @Override
    public ReadCommand maybeGenerateRetryCommand(RowDataResolver resolver, Row row) {
        int liveCountInRow;
        int count;
        int maxLiveColumns = resolver.getMaxLiveCount();
        if (maxLiveColumns < (count = this.filter.count)) {
            return null;
        }
        int n = liveCountInRow = row == null || row.cf == null ? 0 : this.filter.getLiveCount(row.cf, this.timestamp);
        if (liveCountInRow < this.getOriginalRequestedCount()) {
            int retryCount = liveCountInRow == 0 ? count + 1 : count * count / liveCountInRow + 1;
            SliceQueryFilter newFilter = this.filter.withUpdatedCount(retryCount);
            return new RetriedSliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, newFilter, this.getOriginalRequestedCount());
        }
        return null;
    }

    @Override
    public void maybeTrim(Row row) {
        if (row == null || row.cf == null) {
            return;
        }
        this.filter.trim(row.cf, this.getOriginalRequestedCount(), this.timestamp);
    }

    @Override
    public IDiskAtomFilter filter() {
        return this.filter;
    }

    public SliceFromReadCommand withUpdatedFilter(SliceQueryFilter newFilter) {
        return new SliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, newFilter);
    }

    protected int getOriginalRequestedCount() {
        return this.filter.count;
    }

    public String toString() {
        return "SliceFromReadCommand(keyspace='" + this.ksName + '\'' + ", key='" + ByteBufferUtil.bytesToHex(this.key) + '\'' + ", cfName='" + this.cfName + '\'' + ", timestamp='" + this.timestamp + '\'' + ", filter='" + this.filter + '\'' + ')';
    }
}

