/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableNamesIterator;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class NamesQueryFilter
implements IDiskAtomFilter {
    public static final Serializer serializer = new Serializer();
    public final SortedSet<ByteBuffer> columns;
    private final boolean countCQL3Rows;

    public NamesQueryFilter(SortedSet<ByteBuffer> columns) {
        this(columns, false);
    }

    public NamesQueryFilter(SortedSet<ByteBuffer> columns, boolean countCQL3Rows) {
        this.columns = columns;
        this.countCQL3Rows = countCQL3Rows;
    }

    public NamesQueryFilter(ByteBuffer column) {
        this(FBUtilities.singleton(column));
    }

    @Override
    public NamesQueryFilter cloneShallow() {
        return this;
    }

    public NamesQueryFilter withUpdatedColumns(SortedSet<ByteBuffer> newColumns) {
        return new NamesQueryFilter(newColumns, this.countCQL3Rows);
    }

    @Override
    public OnDiskAtomIterator getColumnFamilyIterator(DecoratedKey key, ColumnFamily cf) {
        assert (cf != null);
        return new ByNameColumnIterator(this.columns.iterator(), cf, key);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableNamesIterator(sstable, key, this.columns);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableNamesIterator(sstable, file, key, this.columns, indexEntry);
    }

    @Override
    public void collectReducedColumns(ColumnFamily container, Iterator<Column> reducedColumns, int gcBefore, long now) {
        while (reducedColumns.hasNext()) {
            container.addIfRelevant(reducedColumns.next(), gcBefore);
        }
    }

    @Override
    public Comparator<Column> getColumnComparator(AbstractType<?> comparator) {
        return comparator.columnComparator;
    }

    public String toString() {
        return "NamesQueryFilter(columns=" + StringUtils.join(this.columns, (String)",") + ')';
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
    }

    @Override
    public int getLiveCount(ColumnFamily cf, long now) {
        if (this.countCQL3Rows) {
            return cf.hasOnlyTombstones(now) ? 0 : 1;
        }
        int count = 0;
        for (Column column : cf) {
            if (!column.isLive(now)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean maySelectPrefix(Comparator<ByteBuffer> cmp, ByteBuffer prefix) {
        for (ByteBuffer column : this.columns) {
            if (!ByteBufferUtil.isPrefix(prefix, column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        return true;
    }

    public boolean countCQL3Rows() {
        return this.countCQL3Rows;
    }

    @Override
    public ColumnCounter columnCounter(AbstractType<?> comparator, long now) {
        return this.countCQL3Rows ? new ColumnCounter.GroupByPrefix(now, null, 0) : new ColumnCounter(now);
    }

    public static class Serializer
    implements IVersionedSerializer<NamesQueryFilter> {
        @Override
        public void serialize(NamesQueryFilter f, DataOutput out, int version) throws IOException {
            out.writeInt(f.columns.size());
            for (ByteBuffer cName : f.columns) {
                ByteBufferUtil.writeWithShortLength(cName, out);
            }
            out.writeBoolean(f.countCQL3Rows);
        }

        @Override
        public NamesQueryFilter deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public NamesQueryFilter deserialize(DataInput in, int version, AbstractType comparator) throws IOException {
            int size = in.readInt();
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(comparator);
            for (int i = 0; i < size; ++i) {
                columns.add(ByteBufferUtil.readWithShortLength(in));
            }
            boolean countCQL3Rows = in.readBoolean();
            return new NamesQueryFilter(columns, countCQL3Rows);
        }

        @Override
        public long serializedSize(NamesQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = sizes.sizeof(f.columns.size());
            for (ByteBuffer cName : f.columns) {
                int cNameSize = cName.remaining();
                size += sizes.sizeof((short)cNameSize) + cNameSize;
            }
            return size += sizes.sizeof(f.countCQL3Rows);
        }
    }

    private static class ByNameColumnIterator
    extends AbstractIterator<OnDiskAtom>
    implements OnDiskAtomIterator {
        private final ColumnFamily cf;
        private final DecoratedKey key;
        private final Iterator<ByteBuffer> iter;

        public ByNameColumnIterator(Iterator<ByteBuffer> iter, ColumnFamily cf, DecoratedKey key) {
            this.iter = iter;
            this.cf = cf;
            this.key = key;
        }

        @Override
        public ColumnFamily getColumnFamily() {
            return this.cf;
        }

        @Override
        public DecoratedKey getKey() {
            return this.key;
        }

        protected OnDiskAtom computeNext() {
            while (this.iter.hasNext()) {
                ByteBuffer current = this.iter.next();
                Column column = this.cf.getColumn(current);
                if (column == null) continue;
                return column;
            }
            return (OnDiskAtom)this.endOfData();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

