/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.io.IVersionedSerializer;

class GossipDigestSynSerializer
implements IVersionedSerializer<GossipDigestSyn> {
    GossipDigestSynSerializer() {
    }

    @Override
    public void serialize(GossipDigestSyn gDigestSynMessage, DataOutput out, int version) throws IOException {
        out.writeUTF(gDigestSynMessage.clusterId);
        out.writeUTF(gDigestSynMessage.partioner);
        GossipDigestSerializationHelper.serialize(gDigestSynMessage.gDigests, out, version);
    }

    @Override
    public GossipDigestSyn deserialize(DataInput in, int version) throws IOException {
        String clusterId = in.readUTF();
        String partioner = null;
        partioner = in.readUTF();
        List<GossipDigest> gDigests = GossipDigestSerializationHelper.deserialize(in, version);
        return new GossipDigestSyn(clusterId, partioner, gDigests);
    }

    @Override
    public long serializedSize(GossipDigestSyn syn, int version) {
        long size = TypeSizes.NATIVE.sizeof(syn.clusterId);
        size += (long)TypeSizes.NATIVE.sizeof(syn.partioner);
        return size += (long)GossipDigestSerializationHelper.serializedSize(syn.gDigests, version);
    }
}

