/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.hadoop.AbstractColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class ColumnFamilyInputFormat
extends AbstractColumnFamilyInputFormat<ByteBuffer, SortedMap<ByteBuffer, Column>> {
    public RecordReader<ByteBuffer, SortedMap<ByteBuffer, Column>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new ColumnFamilyRecordReader();
    }

    public org.apache.hadoop.mapred.RecordReader<ByteBuffer, SortedMap<ByteBuffer, Column>> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, final Reporter reporter) throws IOException {
        TaskAttemptContext tac = new TaskAttemptContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id"))){

            public void progress() {
                reporter.progress();
            }
        };
        ColumnFamilyRecordReader recordReader = new ColumnFamilyRecordReader(jobConf.getInt("cassandra.hadoop.max_key_size", 8192));
        recordReader.initialize((InputSplit)split, tac);
        return recordReader;
    }

    @Override
    protected void validateConfiguration(Configuration conf) {
        super.validateConfiguration(conf);
        if (ConfigHelper.getInputSlicePredicate(conf) == null) {
            throw new UnsupportedOperationException("you must set the predicate with setInputSlicePredicate");
        }
    }
}

