/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;

public class ColumnNameHelper {
    public static List<ByteBuffer> maxComponents(List<ByteBuffer> maxSeen, ByteBuffer candidate, AbstractType<?> comparator) {
        if (comparator instanceof CompositeType) {
            int i;
            CompositeType ct = (CompositeType)comparator;
            if (maxSeen.isEmpty()) {
                return Arrays.asList(ct.split(candidate));
            }
            int typeCount = ColumnNameHelper.getTypeCount(ct);
            List<ByteBuffer> components = Arrays.asList(ct.split(candidate));
            List<ByteBuffer> biggest = maxSeen.size() > components.size() ? maxSeen : components;
            int minSize = Math.min(typeCount, Math.min(components.size(), maxSeen.size()));
            int maxSize = Math.min(typeCount, biggest.size());
            ArrayList<ByteBuffer> retList = new ArrayList<ByteBuffer>(maxSize);
            for (i = 0; i < minSize; ++i) {
                retList.add(ColumnNameHelper.max(maxSeen.get(i), components.get(i), ct.types.get(i)));
            }
            for (i = minSize; i < maxSize; ++i) {
                retList.add(biggest.get(i));
            }
            return retList;
        }
        if (maxSeen.size() == 0) {
            return Collections.singletonList(candidate);
        }
        return Collections.singletonList(ColumnNameHelper.max(maxSeen.get(0), candidate, comparator));
    }

    public static List<ByteBuffer> minComponents(List<ByteBuffer> minSeen, ByteBuffer candidate, AbstractType<?> comparator) {
        if (comparator instanceof CompositeType) {
            int i;
            CompositeType ct = (CompositeType)comparator;
            if (minSeen.isEmpty()) {
                return Arrays.asList(ct.split(candidate));
            }
            int typeCount = ColumnNameHelper.getTypeCount(ct);
            List<ByteBuffer> components = Arrays.asList(ct.split(candidate));
            List<ByteBuffer> biggest = minSeen.size() > components.size() ? minSeen : components;
            int minSize = Math.min(typeCount, Math.min(components.size(), minSeen.size()));
            int maxSize = Math.min(typeCount, biggest.size());
            ArrayList<ByteBuffer> retList = new ArrayList<ByteBuffer>(maxSize);
            for (i = 0; i < minSize; ++i) {
                retList.add(ColumnNameHelper.min(minSeen.get(i), components.get(i), ct.types.get(i)));
            }
            for (i = minSize; i < maxSize; ++i) {
                retList.add(biggest.get(i));
            }
            return retList;
        }
        if (minSeen.size() == 0) {
            return Collections.singletonList(candidate);
        }
        return Collections.singletonList(ColumnNameHelper.min(minSeen.get(0), candidate, comparator));
    }

    private static ByteBuffer min(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (comparator.compare(b1, b2) >= 0) {
            return b2;
        }
        return b1;
    }

    private static ByteBuffer max(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (comparator.compare(b1, b2) >= 0) {
            return b1;
        }
        return b2;
    }

    public static List<ByteBuffer> mergeMin(List<ByteBuffer> minColumnNames, List<ByteBuffer> candidates, AbstractType<?> columnNameComparator) {
        if (minColumnNames.isEmpty()) {
            return candidates;
        }
        if (candidates.isEmpty()) {
            return minColumnNames;
        }
        if (columnNameComparator instanceof CompositeType) {
            int i;
            CompositeType ct = (CompositeType)columnNameComparator;
            List<ByteBuffer> biggest = minColumnNames.size() > candidates.size() ? minColumnNames : candidates;
            int typeCount = ColumnNameHelper.getTypeCount(ct);
            int minSize = Math.min(typeCount, Math.min(minColumnNames.size(), candidates.size()));
            int maxSize = Math.min(typeCount, biggest.size());
            ArrayList<ByteBuffer> retList = new ArrayList<ByteBuffer>(maxSize);
            for (i = 0; i < minSize; ++i) {
                retList.add(ColumnNameHelper.min(minColumnNames.get(i), candidates.get(i), ct.types.get(i)));
            }
            for (i = minSize; i < maxSize; ++i) {
                retList.add(biggest.get(i));
            }
            return retList;
        }
        return Collections.singletonList(ColumnNameHelper.min(minColumnNames.get(0), candidates.get(0), columnNameComparator));
    }

    public static List<ByteBuffer> mergeMax(List<ByteBuffer> maxColumnNames, List<ByteBuffer> candidates, AbstractType<?> columnNameComparator) {
        if (maxColumnNames.isEmpty()) {
            return candidates;
        }
        if (candidates.isEmpty()) {
            return maxColumnNames;
        }
        if (columnNameComparator instanceof CompositeType) {
            int i;
            CompositeType ct = (CompositeType)columnNameComparator;
            List<ByteBuffer> biggest = maxColumnNames.size() > candidates.size() ? maxColumnNames : candidates;
            int typeCount = ColumnNameHelper.getTypeCount(ct);
            int minSize = Math.min(typeCount, Math.min(maxColumnNames.size(), candidates.size()));
            int maxSize = Math.min(typeCount, biggest.size());
            ArrayList<ByteBuffer> retList = new ArrayList<ByteBuffer>(maxSize);
            for (i = 0; i < minSize; ++i) {
                retList.add(ColumnNameHelper.max(maxColumnNames.get(i), candidates.get(i), ct.types.get(i)));
            }
            for (i = minSize; i < maxSize; ++i) {
                retList.add(biggest.get(i));
            }
            return retList;
        }
        return Collections.singletonList(ColumnNameHelper.max(maxColumnNames.get(0), candidates.get(0), columnNameComparator));
    }

    private static int getTypeCount(CompositeType ct) {
        return ct.types.get(ct.types.size() - 1) instanceof ColumnToCollectionType ? ct.types.size() - 1 : ct.types.size();
    }
}

