/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.Differencer;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RequestCoordinator;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairJob {
    private static Logger logger = LoggerFactory.getLogger(RepairJob.class);
    public final RepairJobDesc desc;
    private final boolean isSequential;
    private final RequestCoordinator<InetAddress> treeRequests;
    private final List<TreeResponse> trees = new ArrayList<TreeResponse>();
    private final RequestCoordinator<Differencer> differencers;
    private final Condition requestsSent = new SimpleCondition();
    private CountDownLatch snapshotLatch = null;
    private int gcBefore = -1;
    private volatile boolean failed = false;

    public RepairJob(UUID sessionId, String keyspace, String columnFamily, Range<Token> range, boolean isSequential) {
        this.desc = new RepairJobDesc(sessionId, keyspace, columnFamily, range);
        this.isSequential = isSequential;
        this.treeRequests = new RequestCoordinator<InetAddress>(isSequential){

            @Override
            public void send(InetAddress endpoint) {
                ValidationRequest request = new ValidationRequest(RepairJob.this.desc, RepairJob.this.gcBefore);
                MessagingService.instance().sendOneWay(request.createMessage(), endpoint);
            }
        };
        this.differencers = new RequestCoordinator<Differencer>(isSequential){

            @Override
            public void send(Differencer d) {
                StageManager.getStage(Stage.ANTI_ENTROPY).execute(d);
            }
        };
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void sendTreeRequests(Collection<InetAddress> endpoints) {
        ArrayList<InetAddress> allEndpoints = new ArrayList<InetAddress>(endpoints);
        allEndpoints.add(FBUtilities.getBroadcastAddress());
        if (this.isSequential) {
            this.makeSnapshots(endpoints);
        }
        this.gcBefore = Keyspace.open(this.desc.keyspace).getColumnFamilyStore(this.desc.columnFamily).gcBefore(System.currentTimeMillis());
        for (InetAddress endpoint : allEndpoints) {
            this.treeRequests.add(endpoint);
        }
        logger.info(String.format("[repair #%s] requesting merkle trees for %s (to %s)", this.desc.sessionId, this.desc.columnFamily, allEndpoints));
        this.treeRequests.start();
        this.requestsSent.signalAll();
    }

    public void makeSnapshots(Collection<InetAddress> endpoints) {
        try {
            this.snapshotLatch = new CountDownLatch(endpoints.size());
            IAsyncCallback callback = new IAsyncCallback(){

                @Override
                public boolean isLatencyForSnitch() {
                    return false;
                }

                public void response(MessageIn msg) {
                    RepairJob.this.snapshotLatch.countDown();
                }
            };
            for (InetAddress endpoint : endpoints) {
                MessagingService.instance().sendRR(new SnapshotCommand(this.desc.keyspace, this.desc.columnFamily, this.desc.sessionId.toString(), false).createMessage(), endpoint, callback);
            }
            this.snapshotLatch.await();
            this.snapshotLatch = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized int addTree(InetAddress endpoint, MerkleTree tree) {
        try {
            this.requestsSent.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Interrupted while waiting for requests to be sent");
        }
        if (tree == null) {
            this.failed = true;
        } else {
            this.trees.add(new TreeResponse(endpoint, tree));
        }
        return this.treeRequests.completed(endpoint);
    }

    public void submitDifferencers() {
        assert (!this.failed);
        for (int i = 0; i < this.trees.size() - 1; ++i) {
            TreeResponse r1 = this.trees.get(i);
            for (int j = i + 1; j < this.trees.size(); ++j) {
                TreeResponse r2 = this.trees.get(j);
                Differencer differencer = new Differencer(this.desc, r1, r2);
                logger.debug("Queueing comparison {}", (Object)differencer);
                this.differencers.add(differencer);
            }
        }
        this.differencers.start();
        this.trees.clear();
    }

    synchronized boolean completedSynchronization(NodePair nodes, boolean success) {
        Differencer completed;
        if (!success) {
            this.failed = true;
        }
        return this.differencers.completed(completed = new Differencer(this.desc, new TreeResponse(nodes.endpoint1, null), new TreeResponse(nodes.endpoint2, null))) == 0;
    }

    public void terminate() {
        if (this.snapshotLatch != null) {
            while (this.snapshotLatch.getCount() > 0L) {
                this.snapshotLatch.countDown();
            }
        }
    }
}

