/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class ValidationRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new ValidationRequestSerializer();
    public final int gcBefore;

    public ValidationRequest(RepairJobDesc desc, int gcBefore) {
        super(RepairMessage.Type.VALIDATION_REQUEST, desc);
        this.gcBefore = gcBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest that = (ValidationRequest)o;
        return this.gcBefore == that.gcBefore;
    }

    public int hashCode() {
        return this.gcBefore;
    }

    public static class ValidationRequestSerializer
    implements RepairMessage.MessageSerializer<ValidationRequest> {
        @Override
        public void serialize(ValidationRequest message, DataOutput out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeInt(message.gcBefore);
        }

        @Override
        public ValidationRequest deserialize(DataInput dis, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(dis, version);
            return new ValidationRequest(desc, dis.readInt());
        }

        @Override
        public long serializedSize(ValidationRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            return size += (long)TypeSizes.NATIVE.sizeof(message.gcBefore);
        }
    }
}

