/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public abstract class CollectionSerializer<T>
implements TypeSerializer<T> {
    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesSerializer.instance.getString(bytes);
    }

    protected static ByteBuffer pack(List<ByteBuffer> buffers, int elements, int size) {
        ByteBuffer result = ByteBuffer.allocate(2 + size);
        result.putShort((short)elements);
        for (ByteBuffer bb : buffers) {
            result.putShort((short)bb.remaining());
            result.put(bb.duplicate());
        }
        return (ByteBuffer)result.flip();
    }

    public static ByteBuffer pack(List<ByteBuffer> buffers, int elements) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            size += 2 + bb.remaining();
        }
        return CollectionSerializer.pack(buffers, elements, size);
    }

    protected static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }
}

