/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.pager.NamesQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.service.pager.SliceQueryPager;

class MultiPartitionPager
implements QueryPager {
    private final SinglePartitionPager[] pagers;
    private final long timestamp;
    private volatile int current;

    MultiPartitionPager(List<ReadCommand> commands, ConsistencyLevel consistencyLevel, boolean localQuery) {
        this(commands, consistencyLevel, localQuery, null);
    }

    MultiPartitionPager(List<ReadCommand> commands, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        this.pagers = new SinglePartitionPager[commands.size()];
        long tstamp = -1L;
        for (int i = 0; i < commands.size(); ++i) {
            ReadCommand command = commands.get(i);
            if (tstamp == -1L) {
                tstamp = command.timestamp;
            } else if (tstamp != command.timestamp) {
                throw new IllegalArgumentException("All commands must have the same timestamp or weird results may happen.");
            }
            PagingState tmpState = state != null && command.key.equals(state.partitionKey) ? state : null;
            this.pagers[i] = command instanceof SliceFromReadCommand ? new SliceQueryPager((SliceFromReadCommand)command, consistencyLevel, localQuery, tmpState) : new NamesQueryPager((SliceByNamesReadCommand)command, consistencyLevel, localQuery, tmpState);
        }
        this.timestamp = tstamp;
    }

    @Override
    public PagingState state() {
        PagingState state = this.pagers[this.current].state();
        return state == null ? null : new PagingState(state.partitionKey, state.cellName, this.maxRemaining());
    }

    @Override
    public boolean isExhausted() {
        while (this.current < this.pagers.length) {
            if (!this.pagers[this.current].isExhausted()) {
                return false;
            }
            ++this.current;
        }
        return true;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        int remaining = pageSize;
        ArrayList<Row> result = new ArrayList<Row>();
        while (!this.isExhausted() && remaining > 0) {
            List<Row> page = this.pagers[this.current].fetchPage(remaining);
            if (page.isEmpty()) continue;
            Row row = page.get(0);
            remaining -= this.pagers[this.current].columnCounter().countAll(row.cf).live();
            result.add(row);
        }
        return result;
    }

    @Override
    public int maxRemaining() {
        int max = 0;
        for (int i = this.current; i < this.pagers.length; ++i) {
            max += this.pagers[i].maxRemaining();
        }
        return max;
    }

    public long timestamp() {
        return this.timestamp;
    }
}

