/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Throwables;
import com.ning.compress.lzf.LZFInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.BytesReadTracker;
import org.apache.cassandra.utils.Pair;

public class StreamReader {
    protected final UUID cfId;
    protected final long estimatedKeys;
    protected final Collection<Pair<Long, Long>> sections;
    protected final StreamSession session;
    protected Descriptor desc;

    public StreamReader(FileMessageHeader header, StreamSession session) {
        this.session = session;
        this.cfId = header.cfId;
        this.estimatedKeys = header.estimatedKeys;
        this.sections = header.sections;
    }

    public SSTableReader read(ReadableByteChannel channel) throws IOException {
        long totalSize = this.totalSize();
        Pair<String, String> kscf = Schema.instance.getCF(this.cfId);
        ColumnFamilyStore cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
        Directories.DataDirectory localDir = cfs.directories.getLocationCapableOfSize(totalSize);
        if (localDir == null) {
            throw new IOException("Insufficient disk space to store " + totalSize + " bytes");
        }
        this.desc = Descriptor.fromFilename(cfs.getTempSSTablePath(cfs.directories.getLocationForDisk(localDir)));
        SSTableWriter writer = new SSTableWriter(this.desc.filenameFor(Component.DATA), this.estimatedKeys);
        try {
            DataInputStream dis = new DataInputStream((InputStream)new LZFInputStream(Channels.newInputStream(channel)));
            BytesReadTracker in = new BytesReadTracker(dis);
            while (in.getBytesRead() < totalSize) {
                this.writeRow(writer, in, cfs);
                this.session.progress(this.desc, ProgressInfo.Direction.IN, in.getBytesRead(), totalSize);
            }
            return writer.closeAndOpenReader();
        }
        catch (Throwable e) {
            writer.abort();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected long totalSize() {
        long size = 0L;
        for (Pair<Long, Long> section : this.sections) {
            size += (Long)section.right - (Long)section.left;
        }
        return size;
    }

    protected void writeRow(SSTableWriter writer, DataInput in, ColumnFamilyStore cfs) throws IOException {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(in));
        writer.appendFromStream(key, cfs.metadata, in);
        cfs.invalidateCachedRow(key);
    }
}

