/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.streaming.messages.FileMessage;
import org.apache.cassandra.utils.Pair;

public class StreamTransferTask
extends StreamTask {
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);
    private final Map<Integer, FileMessage> files = new HashMap<Integer, FileMessage>();
    private long totalSize;

    public StreamTransferTask(StreamSession session, UUID cfId) {
        super(session, cfId);
    }

    public void addTransferFile(SSTableReader sstable, long estimatedKeys, List<Pair<Long, Long>> sections) {
        assert (sstable != null && this.cfId.equals(sstable.metadata.cfId));
        FileMessage message = new FileMessage(sstable, this.sequenceNumber.getAndIncrement(), estimatedKeys, sections);
        this.files.put(message.header.sequenceNumber, message);
        this.totalSize += message.header.size();
    }

    public void complete(int sequenceNumber) {
        this.files.remove(sequenceNumber);
        if (this.files.isEmpty()) {
            this.session.taskCompleted(this);
        }
    }

    @Override
    public int getTotalNumberOfFiles() {
        return this.files.size();
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public Collection<FileMessage> getFileMessages() {
        return this.files.values();
    }

    public FileMessage createMessageForRetry(int sequenceNumber) {
        return this.files.get(sequenceNumber);
    }
}

