/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.concurrent.TracingAwareExecutorService;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.PagedRangeCommand;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.EchoMessage;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.metrics.ConnectionMetrics;
import org.apache.cassandra.metrics.DroppedMessageMetrics;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.IncomingStreamingConnection;
import org.apache.cassandra.net.IncomingTcpConnection;
import org.apache.cassandra.net.MessageDeliveryTask;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.net.WriteCallbackInfo;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.sink.SinkManager;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.BooleanSerializer;
import org.apache.cassandra.utils.ExpiringMap;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.StatusLogger;
import org.apache.cassandra.utils.UUIDSerializer;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingService
implements MessagingServiceMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=MessagingService";
    public static final int VERSION_12 = 6;
    public static final int VERSION_20 = 7;
    public static final int current_version = 7;
    public boolean allNodesAtLeast20 = true;
    public static final String FAILURE_CALLBACK_PARAM = "CAL_BAC";
    public static final byte[] ONE_BYTE = new byte[1];
    public static final String FAILURE_RESPONSE_PARAM = "FAIL";
    public static final int PROTOCOL_MAGIC = -900387334;
    public static final EnumMap<Verb, Stage> verbStages = new EnumMap<Verb, Stage>(Verb.class){
        {
            this.put(Verb.MUTATION, Stage.MUTATION);
            this.put(Verb.READ_REPAIR, Stage.MUTATION);
            this.put(Verb.TRUNCATE, Stage.MUTATION);
            this.put(Verb.COUNTER_MUTATION, Stage.MUTATION);
            this.put(Verb.PAXOS_PREPARE, Stage.MUTATION);
            this.put(Verb.PAXOS_PROPOSE, Stage.MUTATION);
            this.put(Verb.PAXOS_COMMIT, Stage.MUTATION);
            this.put(Verb.READ, Stage.READ);
            this.put(Verb.RANGE_SLICE, Stage.READ);
            this.put(Verb.INDEX_SCAN, Stage.READ);
            this.put(Verb.PAGED_RANGE, Stage.READ);
            this.put(Verb.REQUEST_RESPONSE, Stage.REQUEST_RESPONSE);
            this.put(Verb.INTERNAL_RESPONSE, Stage.INTERNAL_RESPONSE);
            this.put(Verb.STREAM_REPLY, Stage.MISC);
            this.put(Verb.STREAM_REQUEST, Stage.MISC);
            this.put(Verb.REPLICATION_FINISHED, Stage.MISC);
            this.put(Verb.SNAPSHOT, Stage.MISC);
            this.put(Verb.TREE_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.TREE_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.REPAIR_MESSAGE, Stage.ANTI_ENTROPY);
            this.put(Verb.GOSSIP_DIGEST_ACK, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_ACK2, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_SYN, Stage.GOSSIP);
            this.put(Verb.GOSSIP_SHUTDOWN, Stage.GOSSIP);
            this.put(Verb.DEFINITIONS_UPDATE, Stage.MIGRATION);
            this.put(Verb.SCHEMA_CHECK, Stage.MIGRATION);
            this.put(Verb.MIGRATION_REQUEST, Stage.MIGRATION);
            this.put(Verb.INDEX_SCAN, Stage.READ);
            this.put(Verb.REPLICATION_FINISHED, Stage.MISC);
            this.put(Verb.COUNTER_MUTATION, Stage.MUTATION);
            this.put(Verb.SNAPSHOT, Stage.MISC);
            this.put(Verb.ECHO, Stage.GOSSIP);
            this.put(Verb.UNUSED_1, Stage.INTERNAL_RESPONSE);
            this.put(Verb.UNUSED_2, Stage.INTERNAL_RESPONSE);
            this.put(Verb.UNUSED_3, Stage.INTERNAL_RESPONSE);
        }
    };
    public static final EnumMap<Verb, IVersionedSerializer<?>> verbSerializers = new EnumMap<Verb, IVersionedSerializer<?>>(Verb.class){
        {
            this.put(Verb.REQUEST_RESPONSE, CallbackDeterminedSerializer.instance);
            this.put(Verb.INTERNAL_RESPONSE, CallbackDeterminedSerializer.instance);
            this.put(Verb.MUTATION, RowMutation.serializer);
            this.put(Verb.READ_REPAIR, RowMutation.serializer);
            this.put(Verb.READ, ReadCommand.serializer);
            this.put(Verb.RANGE_SLICE, RangeSliceCommand.serializer);
            this.put(Verb.PAGED_RANGE, PagedRangeCommand.serializer);
            this.put(Verb.BOOTSTRAP_TOKEN, BootStrapper.StringSerializer.instance);
            this.put(Verb.REPAIR_MESSAGE, RepairMessage.serializer);
            this.put(Verb.GOSSIP_DIGEST_ACK, GossipDigestAck.serializer);
            this.put(Verb.GOSSIP_DIGEST_ACK2, GossipDigestAck2.serializer);
            this.put(Verb.GOSSIP_DIGEST_SYN, GossipDigestSyn.serializer);
            this.put(Verb.DEFINITIONS_UPDATE, MigrationManager.MigrationsSerializer.instance);
            this.put(Verb.TRUNCATE, Truncation.serializer);
            this.put(Verb.REPLICATION_FINISHED, null);
            this.put(Verb.COUNTER_MUTATION, CounterMutation.serializer);
            this.put(Verb.SNAPSHOT, SnapshotCommand.serializer);
            this.put(Verb.ECHO, EchoMessage.serializer);
            this.put(Verb.PAXOS_PREPARE, Commit.serializer);
            this.put(Verb.PAXOS_PROPOSE, Commit.serializer);
            this.put(Verb.PAXOS_COMMIT, Commit.serializer);
        }
    };
    public static final EnumMap<Verb, IVersionedSerializer<?>> callbackDeserializers = new EnumMap<Verb, IVersionedSerializer<?>>(Verb.class){
        {
            this.put(Verb.MUTATION, WriteResponse.serializer);
            this.put(Verb.READ_REPAIR, WriteResponse.serializer);
            this.put(Verb.COUNTER_MUTATION, WriteResponse.serializer);
            this.put(Verb.RANGE_SLICE, RangeSliceReply.serializer);
            this.put(Verb.PAGED_RANGE, RangeSliceReply.serializer);
            this.put(Verb.READ, ReadResponse.serializer);
            this.put(Verb.TRUNCATE, TruncateResponse.serializer);
            this.put(Verb.SNAPSHOT, null);
            this.put(Verb.MIGRATION_REQUEST, MigrationManager.MigrationsSerializer.instance);
            this.put(Verb.SCHEMA_CHECK, UUIDSerializer.serializer);
            this.put(Verb.BOOTSTRAP_TOKEN, BootStrapper.StringSerializer.instance);
            this.put(Verb.REPLICATION_FINISHED, null);
            this.put(Verb.PAXOS_PREPARE, PrepareResponse.serializer);
            this.put(Verb.PAXOS_PROPOSE, BooleanSerializer.serializer);
        }
    };
    private final ExpiringMap<Integer, CallbackInfo> callbacks;
    private final Map<Verb, IVerbHandler> verbHandlers;
    private final ConcurrentMap<InetAddress, OutboundTcpConnectionPool> connectionManagers = new NonBlockingHashMap();
    private static final Logger logger = LoggerFactory.getLogger(MessagingService.class);
    private static final int LOG_DROPPED_INTERVAL_IN_MS = 5000;
    private final List<SocketThread> socketThreads = Lists.newArrayList();
    private final SimpleCondition listenGate;
    public static final EnumSet<Verb> DROPPABLE_VERBS = EnumSet.of(Verb.BINARY, new Verb[]{Verb._TRACE, Verb.MUTATION, Verb.COUNTER_MUTATION, Verb.READ_REPAIR, Verb.READ, Verb.RANGE_SLICE, Verb.PAGED_RANGE, Verb.REQUEST_RESPONSE});
    private final Map<Verb, DroppedMessageMetrics> droppedMessages = new EnumMap<Verb, DroppedMessageMetrics>(Verb.class);
    private final Map<Verb, Integer> lastDroppedInternal = new EnumMap<Verb, Integer>(Verb.class);
    private final List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();
    private final ConcurrentMap<InetAddress, Integer> versions = new NonBlockingHashMap();
    private static final AtomicInteger idGen = new AtomicInteger(0);

    public static MessagingService instance() {
        return MSHandle.instance;
    }

    private MessagingService() {
        for (Verb verb : DROPPABLE_VERBS) {
            this.droppedMessages.put(verb, new DroppedMessageMetrics(verb));
            this.lastDroppedInternal.put(verb, 0);
        }
        this.listenGate = new SimpleCondition();
        this.verbHandlers = new EnumMap<Verb, IVerbHandler>(Verb.class);
        Runnable logDropped = new Runnable(){

            @Override
            public void run() {
                MessagingService.this.logDroppedMessages();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(logDropped, 5000L, 5000L, TimeUnit.MILLISECONDS);
        Function<Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>>, Object> timeoutReporter = new Function<Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>>, Object>(){

            public Object apply(Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>> pair) {
                final CallbackInfo expiredCallbackInfo = (CallbackInfo)((ExpiringMap.CacheableObject)pair.right).value;
                MessagingService.this.maybeAddLatency(expiredCallbackInfo.callback, expiredCallbackInfo.target, ((ExpiringMap.CacheableObject)pair.right).timeout);
                ConnectionMetrics.totalTimeouts.mark();
                MessagingService.this.getConnectionPool(expiredCallbackInfo.target).incrementTimeout();
                if (expiredCallbackInfo.isFailureCallback()) {
                    StageManager.getStage(Stage.INTERNAL_RESPONSE).submit(new Runnable(){

                        @Override
                        public void run() {
                            ((IAsyncCallbackWithFailure)expiredCallbackInfo.callback).onFailure(expiredCallbackInfo.target);
                        }
                    });
                }
                if (expiredCallbackInfo.shouldHint()) {
                    RowMutation rm = (RowMutation)((WriteCallbackInfo)expiredCallbackInfo).sentMessage.payload;
                    return StorageProxy.submitHint(rm, expiredCallbackInfo.target, null);
                }
                return null;
            }
        };
        this.callbacks = new ExpiringMap<Integer, CallbackInfo>(DatabaseDescriptor.getMinRpcTimeout(), timeoutReporter);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void maybeAddLatency(IAsyncCallback cb, InetAddress address, long latency) {
        if (cb.isLatencyForSnitch()) {
            this.addLatency(address, latency);
        }
    }

    public void addLatency(InetAddress address, long latency) {
        for (ILatencySubscriber subscriber : this.subscribers) {
            subscriber.receiveTiming(address, latency);
        }
    }

    public void convict(InetAddress ep) {
        logger.debug("Resetting pool for " + ep);
        this.getConnectionPool(ep).reset();
    }

    public void listen(InetAddress localEp) throws ConfigurationException {
        this.callbacks.reset();
        for (ServerSocket ss : this.getServerSockets(localEp)) {
            SocketThread th = new SocketThread(ss, "ACCEPT-" + localEp);
            th.start();
            this.socketThreads.add(th);
        }
        this.listenGate.signalAll();
    }

    private List<ServerSocket> getServerSockets(InetAddress localEp) throws ConfigurationException {
        ArrayList<ServerSocket> ss = new ArrayList<ServerSocket>(2);
        if (DatabaseDescriptor.getServerEncryptionOptions().internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none) {
            try {
                ss.add(SSLFactory.getServerSocket(DatabaseDescriptor.getServerEncryptionOptions(), localEp, DatabaseDescriptor.getSSLStoragePort()));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to create ssl socket", e);
            }
            logger.info("Starting Encrypted Messaging Service on SSL port {}", (Object)DatabaseDescriptor.getSSLStoragePort());
        }
        if (DatabaseDescriptor.getServerEncryptionOptions().internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.all) {
            ServerSocketChannel serverChannel = null;
            try {
                serverChannel = ServerSocketChannel.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ServerSocket socket = serverChannel.socket();
            try {
                socket.setReuseAddress(true);
            }
            catch (SocketException e) {
                throw new ConfigurationException("Insufficient permissions to setReuseAddress", e);
            }
            InetSocketAddress address = new InetSocketAddress(localEp, DatabaseDescriptor.getStoragePort());
            try {
                socket.bind(address, 500);
            }
            catch (BindException e) {
                if (e.getMessage().contains("in use")) {
                    throw new ConfigurationException(address + " is in use by another process.  Change listen_address:storage_port in cassandra.yaml to values that do not conflict with other services");
                }
                if (e.getMessage().contains("Cannot assign requested address")) {
                    throw new ConfigurationException("Unable to bind to address " + address + ". Set listen_address in cassandra.yaml to an interface you can bind to, e.g., your private IP address on EC2");
                }
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.info("Starting Messaging Service on port {}", (Object)DatabaseDescriptor.getStoragePort());
            ss.add(socket);
        }
        return ss;
    }

    public void waitUntilListening() {
        try {
            this.listenGate.await();
        }
        catch (InterruptedException ie) {
            logger.debug("await interrupted");
        }
    }

    public boolean isListening() {
        return this.listenGate.isSignaled();
    }

    public void destroyConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)this.connectionManagers.get(to);
        if (cp == null) {
            return;
        }
        cp.close();
        this.connectionManagers.remove(to);
    }

    public OutboundTcpConnectionPool getConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)this.connectionManagers.get(to);
        if (cp == null) {
            cp = new OutboundTcpConnectionPool(to);
            OutboundTcpConnectionPool existingPool = this.connectionManagers.putIfAbsent(to, cp);
            if (existingPool != null) {
                cp = existingPool;
            } else {
                cp.start();
            }
        }
        cp.waitForStarted();
        return cp;
    }

    public OutboundTcpConnection getConnection(InetAddress to, MessageOut msg) {
        return this.getConnectionPool(to).getConnection(msg);
    }

    public void registerVerbHandlers(Verb verb, IVerbHandler verbHandler) {
        assert (!this.verbHandlers.containsKey((Object)verb));
        this.verbHandlers.put(verb, verbHandler);
    }

    public IVerbHandler getVerbHandler(Verb type) {
        return this.verbHandlers.get((Object)type);
    }

    public int addCallback(IAsyncCallback cb, MessageOut message, InetAddress to, long timeout, boolean failureCallback) {
        assert (message.verb != Verb.MUTATION);
        int messageId = MessagingService.nextId();
        CallbackInfo previous = this.callbacks.put(messageId, new CallbackInfo(to, cb, callbackDeserializers.get((Object)message.verb), failureCallback), timeout);
        assert (previous == null) : String.format("Callback already exists for id %d! (%s)", messageId, previous);
        return messageId;
    }

    public int addCallback(IAsyncCallback cb, MessageOut<? extends IMutation> message, InetAddress to, long timeout, ConsistencyLevel consistencyLevel, boolean allowHints) {
        assert (message.verb == Verb.MUTATION || message.verb == Verb.COUNTER_MUTATION);
        int messageId = MessagingService.nextId();
        CallbackInfo previous = this.callbacks.put(messageId, new WriteCallbackInfo(to, cb, message, callbackDeserializers.get((Object)message.verb), consistencyLevel, allowHints), timeout);
        assert (previous == null) : String.format("Callback already exists for id %d! (%s)", messageId, previous);
        return messageId;
    }

    private static int nextId() {
        return idGen.incrementAndGet();
    }

    public int sendRR(MessageOut message, InetAddress to, IAsyncCallback cb) {
        return this.sendRR(message, to, cb, message.getTimeout(), false);
    }

    public int sendRRWithFailure(MessageOut message, InetAddress to, IAsyncCallbackWithFailure cb) {
        return this.sendRR(message, to, cb, message.getTimeout(), true);
    }

    public int sendRR(MessageOut message, InetAddress to, IAsyncCallback cb, long timeout, boolean failureCallback) {
        int id = this.addCallback(cb, message, to, timeout, failureCallback);
        this.sendOneWay(failureCallback ? message.withParameter(FAILURE_CALLBACK_PARAM, ONE_BYTE) : message, id, to);
        return id;
    }

    public int sendRR(MessageOut<? extends IMutation> message, InetAddress to, AbstractWriteResponseHandler handler, boolean allowHints) {
        int id = this.addCallback(handler, message, to, message.getTimeout(), handler.consistencyLevel, allowHints);
        this.sendOneWay(message, id, to);
        return id;
    }

    public void sendOneWay(MessageOut message, InetAddress to) {
        this.sendOneWay(message, MessagingService.nextId(), to);
    }

    public void sendReply(MessageOut message, int id, InetAddress to) {
        this.sendOneWay(message, id, to);
    }

    public void sendOneWay(MessageOut message, int id, InetAddress to) {
        MessageOut processedMessage;
        if (logger.isTraceEnabled()) {
            logger.trace(FBUtilities.getBroadcastAddress() + " sending " + (Object)((Object)message.verb) + " to " + id + "@" + to);
        }
        if (to.equals(FBUtilities.getBroadcastAddress())) {
            logger.trace("Message-to-self {} going over MessagingService", (Object)message);
        }
        if ((processedMessage = SinkManager.processOutboundMessage(message, id, to)) == null) {
            return;
        }
        OutboundTcpConnection connection = this.getConnection(to, processedMessage);
        connection.enqueue(processedMessage, id);
    }

    public <T> AsyncOneResponse<T> sendRR(MessageOut message, InetAddress to) {
        AsyncOneResponse iar = new AsyncOneResponse();
        this.sendRR(message, to, iar);
        return iar;
    }

    public void register(ILatencySubscriber subcriber) {
        this.subscribers.add(subcriber);
    }

    public void clearCallbacksUnsafe() {
        this.callbacks.reset();
    }

    public void shutdown() {
        logger.info("Waiting for messaging service to quiesce");
        assert (!StageManager.getStage(Stage.MUTATION).isShutdown());
        this.callbacks.shutdownBlocking();
        try {
            for (SocketThread th : this.socketThreads) {
                th.close();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void receive(MessageIn message, int id, long timestamp) {
        TraceState state = Tracing.instance.initializeFromMessage(message);
        if (state != null) {
            state.trace("Message received from {}", message.from);
        }
        Verb verb = message.verb;
        if ((message = SinkManager.processInboundMessage(message, id)) == null) {
            this.incrementRejectedMessages(verb);
            return;
        }
        MessageDeliveryTask runnable = new MessageDeliveryTask(message, id, timestamp);
        TracingAwareExecutorService stage = StageManager.getStage(message.getMessageType());
        assert (stage != null) : "No stage for message type " + (Object)((Object)message.verb);
        stage.execute(runnable, state);
    }

    public void setCallbackForTests(int messageId, CallbackInfo callback) {
        this.callbacks.put(messageId, callback);
    }

    public CallbackInfo getRegisteredCallback(int messageId) {
        return this.callbacks.get(messageId);
    }

    public CallbackInfo removeRegisteredCallback(int messageId) {
        return this.callbacks.remove(messageId);
    }

    public long getRegisteredCallbackAge(int messageId) {
        return this.callbacks.getAge(messageId);
    }

    public static void validateMagic(int magic) throws IOException {
        if (magic != -900387334) {
            throw new IOException("invalid protocol header");
        }
    }

    public static int getBits(int packed, int start, int count) {
        return packed >>> start + 1 - count & ~(-1 << count);
    }

    public int setVersion(InetAddress endpoint, int version) {
        Integer v;
        logger.debug("Setting version {} for {}", (Object)version, (Object)endpoint);
        if (version < 7) {
            this.allNodesAtLeast20 = false;
        }
        if ((v = this.versions.put(endpoint, version)) != null && v < 7 && version >= 7) {
            this.refreshAllNodesAtLeast20();
        }
        return v == null ? version : v;
    }

    public void resetVersion(InetAddress endpoint) {
        logger.debug("Resetting version for {}", (Object)endpoint);
        Integer removed = (Integer)this.versions.remove(endpoint);
        if (removed != null && removed <= 7) {
            this.refreshAllNodesAtLeast20();
        }
    }

    private void refreshAllNodesAtLeast20() {
        for (Integer version : this.versions.values()) {
            if (version >= 7) continue;
            this.allNodesAtLeast20 = false;
            return;
        }
        this.allNodesAtLeast20 = true;
    }

    public int getVersion(InetAddress endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            logger.trace("Assuming current protocol version for {}", (Object)endpoint);
            return 7;
        }
        return Math.min(v, 7);
    }

    @Override
    public int getVersion(String endpoint) throws UnknownHostException {
        return this.getVersion(InetAddress.getByName(endpoint));
    }

    public int getRawVersion(InetAddress endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            throw new IllegalStateException("getRawVersion() was called without checking knowsVersion() result first");
        }
        return v;
    }

    public boolean knowsVersion(InetAddress endpoint) {
        return this.versions.containsKey(endpoint);
    }

    public void incrementDroppedMessages(Verb verb) {
        assert (DROPPABLE_VERBS.contains((Object)verb)) : "Verb " + (Object)((Object)verb) + " should not legally be dropped";
        this.droppedMessages.get((Object)((Object)verb)).dropped.mark();
    }

    private void incrementRejectedMessages(Verb verb) {
        DroppedMessageMetrics metrics = this.droppedMessages.get((Object)verb);
        if (metrics == null) {
            metrics = new DroppedMessageMetrics(verb);
            this.droppedMessages.put(verb, metrics);
        }
        metrics.dropped.mark();
    }

    private void logDroppedMessages() {
        boolean logTpstats = false;
        for (Map.Entry<Verb, DroppedMessageMetrics> entry : this.droppedMessages.entrySet()) {
            Verb verb;
            int dropped = (int)entry.getValue().dropped.count();
            int recent = dropped - this.lastDroppedInternal.get((Object)(verb = entry.getKey()));
            if (recent <= 0) continue;
            logTpstats = true;
            logger.info("{} {} messages dropped in last {}ms", new Object[]{recent, verb, 5000});
            this.lastDroppedInternal.put(verb, dropped);
        }
        if (logTpstats) {
            StatusLogger.log();
        }
    }

    @Override
    public Map<String, Integer> getCommandPendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getPendingMessages());
        }
        return pendingTasks;
    }

    public int getCommandPendingTasks(InetAddress address) {
        OutboundTcpConnectionPool connection = (OutboundTcpConnectionPool)this.connectionManagers.get(address);
        return connection == null ? 0 : connection.cmdCon.getPendingMessages();
    }

    @Override
    public Map<String, Long> getCommandCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getCommandDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            droppedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getDroppedMessages());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getResponsePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getResponseCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Integer> getDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<Verb, DroppedMessageMetrics> entry : this.droppedMessages.entrySet()) {
            map.put(entry.getKey().toString(), (int)entry.getValue().dropped.count());
        }
        return map;
    }

    @Override
    public Map<String, Integer> getRecentlyDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<Verb, DroppedMessageMetrics> entry : this.droppedMessages.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().getRecentlyDropped());
        }
        return map;
    }

    @Override
    public long getTotalTimeouts() {
        return ConnectionMetrics.totalTimeouts.count();
    }

    @Override
    public long getRecentTotalTimouts() {
        return ConnectionMetrics.getRecentTotalTimeout();
    }

    @Override
    public Map<String, Long> getTimeoutsPerHost() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            String ip = ((InetAddress)entry.getKey()).getHostAddress();
            long recent = ((OutboundTcpConnectionPool)entry.getValue()).getTimeouts();
            result.put(ip, recent);
        }
        return result;
    }

    @Override
    public Map<String, Long> getRecentTimeoutsPerHost() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            String ip = ((InetAddress)entry.getKey()).getHostAddress();
            long recent = ((OutboundTcpConnectionPool)entry.getValue()).getRecentTimeouts();
            result.put(ip, recent);
        }
        return result;
    }

    private static class SocketThread
    extends Thread {
        private final ServerSocket server;

        SocketThread(ServerSocket server, String name) {
            super(name);
            this.server = server;
        }

        @Override
        public void run() {
            while (!this.server.isClosed()) {
                Socket socket = null;
                try {
                    socket = this.server.accept();
                    if (!this.authenticate(socket)) {
                        logger.debug("remote failed to authenticate");
                        socket.close();
                        continue;
                    }
                    socket.setKeepAlive(true);
                    socket.setSoTimeout(10000);
                    DataInputStream in = new DataInputStream(socket.getInputStream());
                    MessagingService.validateMagic(in.readInt());
                    int header = in.readInt();
                    boolean isStream = MessagingService.getBits(header, 3, 1) == 1;
                    int version = MessagingService.getBits(header, 15, 8);
                    logger.debug("Connection version {} from {}", (Object)version, (Object)socket.getInetAddress());
                    socket.setSoTimeout(0);
                    Thread thread = isStream ? new IncomingStreamingConnection(version, socket) : new IncomingTcpConnection(version, MessagingService.getBits(header, 2, 1) == 1, socket);
                    thread.start();
                }
                catch (AsynchronousCloseException e) {
                    logger.debug("Asynchronous close seen by server thread");
                    break;
                }
                catch (ClosedChannelException e) {
                    logger.debug("MessagingService server thread already closed");
                    break;
                }
                catch (IOException e) {
                    logger.debug("Error reading the socket " + socket, (Throwable)e);
                    FileUtils.closeQuietly(socket);
                }
            }
            logger.info("MessagingService has terminated the accept() thread");
        }

        void close() throws IOException {
            logger.debug("Closing accept() thread");
            this.server.close();
        }

        private boolean authenticate(Socket socket) {
            return DatabaseDescriptor.getInternodeAuthenticator().authenticate(socket.getInetAddress(), socket.getPort());
        }
    }

    private static class MSHandle {
        public static final MessagingService instance = new MessagingService();

        private MSHandle() {
        }
    }

    static class CallbackDeterminedSerializer
    implements IVersionedSerializer<Object> {
        public static final CallbackDeterminedSerializer instance = new CallbackDeterminedSerializer();

        CallbackDeterminedSerializer() {
        }

        @Override
        public Object deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(Object o, DataOutput out, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long serializedSize(Object o, int version) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Verb {
        MUTATION,
        BINARY,
        READ_REPAIR,
        READ,
        REQUEST_RESPONSE,
        STREAM_INITIATE,
        STREAM_INITIATE_DONE,
        STREAM_REPLY,
        STREAM_REQUEST,
        RANGE_SLICE,
        BOOTSTRAP_TOKEN,
        TREE_REQUEST,
        TREE_RESPONSE,
        JOIN,
        GOSSIP_DIGEST_SYN,
        GOSSIP_DIGEST_ACK,
        GOSSIP_DIGEST_ACK2,
        DEFINITIONS_ANNOUNCE,
        DEFINITIONS_UPDATE,
        TRUNCATE,
        SCHEMA_CHECK,
        INDEX_SCAN,
        REPLICATION_FINISHED,
        INTERNAL_RESPONSE,
        COUNTER_MUTATION,
        STREAMING_REPAIR_REQUEST,
        STREAMING_REPAIR_RESPONSE,
        SNAPSHOT,
        MIGRATION_REQUEST,
        GOSSIP_SHUTDOWN,
        _TRACE,
        ECHO,
        REPAIR_MESSAGE,
        PAXOS_PREPARE,
        PAXOS_PROPOSE,
        PAXOS_COMMIT,
        PAGED_RANGE,
        UNUSED_1,
        UNUSED_2,
        UNUSED_3;

    }
}

