/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.statements.Selectable;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnIdentifier
implements Selectable {
    public final ByteBuffer key;
    private final String text;

    public ColumnIdentifier(String rawText, boolean keepCase) {
        this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        this.key = ByteBufferUtil.bytes(this.text);
    }

    public ColumnIdentifier(ByteBuffer key, AbstractType<?> type) {
        this.key = key;
        this.text = type.getString(key);
    }

    private ColumnIdentifier(ByteBuffer key, String text) {
        this.key = key;
        this.text = text;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier that = (ColumnIdentifier)o;
        return this.key.equals(that.key);
    }

    public String toString() {
        return this.text;
    }

    public static class Raw
    implements Selectable.Raw {
        private final String rawText;
        private final String text;

        public Raw(String rawText, boolean keepCase) {
            this.rawText = rawText;
            this.text = keepCase ? rawText : rawText.toLowerCase();
        }

        @Override
        public ColumnIdentifier prepare(CFMetaData cfm) {
            if (cfm.getIsDense().booleanValue() || cfm.comparator instanceof CompositeType || cfm.comparator instanceof UTF8Type) {
                return new ColumnIdentifier(this.text, true);
            }
            ByteBuffer bufferName = ByteBufferUtil.bytes(this.text);
            for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                if (!def.name.equals(bufferName)) continue;
                return new ColumnIdentifier(this.text, true);
            }
            return new ColumnIdentifier(cfm.comparator.fromString(this.rawText), this.text);
        }

        @Override
        public boolean processesSelection() {
            return false;
        }

        public final int hashCode() {
            return this.text.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Raw)) {
                return false;
            }
            Raw that = (Raw)o;
            return this.text.equals(that.text);
        }

        public String toString() {
            return this.text;
        }
    }
}

