/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;

public class PagedRangeCommand
extends AbstractRangeCommand {
    public static final IVersionedSerializer<PagedRangeCommand> serializer = new Serializer();
    public final ByteBuffer start;
    public final ByteBuffer stop;
    public final int limit;

    public PagedRangeCommand(String keyspace, String columnFamily, long timestamp, AbstractBounds<RowPosition> keyRange, SliceQueryFilter predicate, ByteBuffer start, ByteBuffer stop, List<IndexExpression> rowFilter, int limit) {
        super(keyspace, columnFamily, timestamp, keyRange, predicate, rowFilter);
        this.start = start;
        this.stop = stop;
        this.limit = limit;
    }

    public MessageOut<PagedRangeCommand> createMessage() {
        return new MessageOut<PagedRangeCommand>(MessagingService.Verb.PAGED_RANGE, this, serializer);
    }

    @Override
    public AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> subRange) {
        ByteBuffer newStart = ((RowPosition)subRange.left).equals(this.keyRange.left) ? this.start : ((SliceQueryFilter)this.predicate).start();
        ByteBuffer newStop = ((RowPosition)subRange.right).equals(this.keyRange.right) ? this.stop : ((SliceQueryFilter)this.predicate).finish();
        return new PagedRangeCommand(this.keyspace, this.columnFamily, this.timestamp, subRange, (SliceQueryFilter)this.predicate, newStart, newStop, this.rowFilter, this.limit);
    }

    @Override
    public AbstractRangeCommand withUpdatedLimit(int newLimit) {
        return new PagedRangeCommand(this.keyspace, this.columnFamily, this.timestamp, this.keyRange, (SliceQueryFilter)this.predicate, this.start, this.stop, this.rowFilter, newLimit);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public boolean countCQL3Rows() {
        return ((SliceQueryFilter)this.predicate).count != 1;
    }

    @Override
    public List<Row> executeLocally() {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace).getColumnFamilyStore(this.columnFamily);
        ExtendedFilter exFilter = cfs.makeExtendedFilter(this.keyRange, (SliceQueryFilter)this.predicate, this.start, this.stop, this.rowFilter, this.limit, this.countCQL3Rows(), this.timestamp);
        if (cfs.indexManager.hasIndexFor(this.rowFilter)) {
            return cfs.search(exFilter);
        }
        return cfs.getRangeSlice(exFilter);
    }

    public String toString() {
        return String.format("PagedRange(%s, %s, %d, %s, %s, %s, %s, %s, %d)", this.keyspace, this.columnFamily, this.timestamp, this.keyRange, this.predicate, this.start, this.stop, this.rowFilter, this.limit);
    }

    private static class Serializer
    implements IVersionedSerializer<PagedRangeCommand> {
        private Serializer() {
        }

        @Override
        public void serialize(PagedRangeCommand cmd, DataOutput out, int version) throws IOException {
            out.writeUTF(cmd.keyspace);
            out.writeUTF(cmd.columnFamily);
            out.writeLong(cmd.timestamp);
            AbstractBounds.serializer.serialize(cmd.keyRange, out, version);
            SliceQueryFilter filter = (SliceQueryFilter)cmd.predicate;
            SliceQueryFilter.serializer.serialize(filter, out, version);
            ByteBufferUtil.writeWithShortLength(cmd.start, out);
            ByteBufferUtil.writeWithShortLength(cmd.stop, out);
            out.writeInt(cmd.rowFilter.size());
            for (IndexExpression expr : cmd.rowFilter) {
                ByteBufferUtil.writeWithShortLength(expr.column_name, out);
                out.writeInt(expr.op.getValue());
                ByteBufferUtil.writeWithShortLength(expr.value, out);
            }
            out.writeInt(cmd.limit);
        }

        @Override
        public PagedRangeCommand deserialize(DataInput in, int version) throws IOException {
            String columnFamily;
            String keyspace = in.readUTF();
            if (Schema.instance.getCFMetaData(keyspace, columnFamily = in.readUTF()) == null) {
                String message = String.format("Got paged range command for nonexistent table %s.%s.  If the table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", keyspace, columnFamily);
                throw new UnknownColumnFamilyException(message, null);
            }
            long timestamp = in.readLong();
            AbstractBounds<RowPosition> keyRange = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
            SliceQueryFilter predicate = SliceQueryFilter.serializer.deserialize(in, version);
            ByteBuffer start = ByteBufferUtil.readWithShortLength(in);
            ByteBuffer stop = ByteBufferUtil.readWithShortLength(in);
            int filterCount = in.readInt();
            ArrayList<IndexExpression> rowFilter = new ArrayList<IndexExpression>(filterCount);
            for (int i = 0; i < filterCount; ++i) {
                IndexExpression expr = new IndexExpression(ByteBufferUtil.readWithShortLength(in), IndexOperator.findByValue((int)in.readInt()), ByteBufferUtil.readWithShortLength(in));
                rowFilter.add(expr);
            }
            int limit = in.readInt();
            return new PagedRangeCommand(keyspace, columnFamily, timestamp, keyRange, predicate, start, stop, rowFilter, limit);
        }

        @Override
        public long serializedSize(PagedRangeCommand cmd, int version) {
            long size = 0L;
            size += (long)TypeSizes.NATIVE.sizeof(cmd.keyspace);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.columnFamily);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.timestamp);
            size += AbstractBounds.serializer.serializedSize(cmd.keyRange, version);
            size += SliceQueryFilter.serializer.serializedSize((SliceQueryFilter)cmd.predicate, version);
            size += (long)TypeSizes.NATIVE.sizeofWithShortLength(cmd.start);
            size += (long)TypeSizes.NATIVE.sizeofWithShortLength(cmd.stop);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.rowFilter.size());
            for (IndexExpression expr : cmd.rowFilter) {
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column_name);
                size += (long)TypeSizes.NATIVE.sizeof(expr.op.getValue());
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.value);
            }
            return size += (long)TypeSizes.NATIVE.sizeof(cmd.limit);
        }
    }
}

