/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.Upgrader;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneUpgrader {
    private static final String TOOL_NAME = "sstableupgrade";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";

    public static void main(String[] args) throws IOException {
        Options options = Options.parseArgs(args);
        try {
            DatabaseDescriptor.loadSchemas(false);
            if (Schema.instance.getCFMetaData(options.keyspace, options.cf) == null) {
                throw new IllegalArgumentException(String.format("Unknown keyspace/columnFamily %s.%s", options.keyspace, options.cf));
            }
            Keyspace keyspace = Keyspace.openWithoutSSTables(options.keyspace);
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(options.cf);
            OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(false, options.debug);
            Directories.SSTableLister lister = cfs.directories.sstableLister();
            if (options.snapshot != null) {
                lister.onlyBackups(true).snapshots(options.snapshot);
            } else {
                lister.includeBackups(false);
            }
            ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>();
            for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
                Set<Component> components = entry.getValue();
                if (!components.contains(Component.DATA) || !components.contains(Component.PRIMARY_INDEX)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation(entry.getKey(), components, cfs.metadata);
                    if (sstable.descriptor.version.equals(Descriptor.Version.CURRENT)) continue;
                    readers.add(sstable);
                }
                catch (Exception e) {
                    System.err.println(String.format("Error Loading %s: %s", entry.getKey(), e.getMessage()));
                    if (!options.debug) continue;
                    e.printStackTrace(System.err);
                }
            }
            int numSSTables = readers.size();
            handler.output("Found " + numSSTables + " sstables that need upgrading.");
            for (SSTableReader sstable : readers) {
                try {
                    Upgrader upgrader = new Upgrader(cfs, sstable, handler);
                    upgrader.upgrade();
                    sstable.markObsolete();
                    sstable.releaseReference();
                }
                catch (Exception e) {
                    System.err.println(String.format("Error upgrading %s: %s", sstable, e.getMessage()));
                    if (!options.debug) continue;
                    e.printStackTrace(System.err);
                }
            }
            SSTableDeletingTask.waitForDeletions();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    static {
        CassandraDaemon.initLog4j();
    }

    private static class Options {
        public final String keyspace;
        public final String cf;
        public final String snapshot;
        public boolean debug;

        private Options(String keyspace, String cf, String snapshot) {
            this.keyspace = keyspace;
            this.cf = cf;
            this.snapshot = snapshot;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneUpgrader.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length >= 4 || args.length < 2) {
                    String msg = args.length < 2 ? "Missing arguments" : "Too many arguments";
                    Options.errorMsg(msg, options);
                    System.exit(1);
                }
                String keyspace = args[0];
                String cf = args[1];
                String snapshot = null;
                if (args.length == 3) {
                    snapshot = args[2];
                }
                Options opts = new Options(keyspace, cf, snapshot);
                opts.debug = cmd.hasOption(StandaloneUpgrader.DEBUG_OPTION);
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption(null, StandaloneUpgrader.DEBUG_OPTION, "display stack traces");
            options.addOption("h", StandaloneUpgrader.HELP_OPTION, "display this help message");
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <cf> [snapshot]", StandaloneUpgrader.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Upgrade the sstables in the given cf (or snapshot) to the current version of Cassandra.");
            header.append("This operation will rewrite the sstables in the specified cf to match the ");
            header.append("currently installed version of Cassandra.\n");
            header.append("The snapshot option will only upgrade the specified snapshot. Upgrading ");
            header.append("snapshots is required before attempting to restore a snapshot taken in a ");
            header.append("major version older than the major version Cassandra is currently running. ");
            header.append("This will replace the files in the given snapshot as well as break any ");
            header.append("hard links to live sstables.");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }
    }
}

