/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;

public class UUIDSerializer
implements IVersionedSerializer<UUID> {
    public static UUIDSerializer serializer = new UUIDSerializer();

    @Override
    public void serialize(UUID uuid, DataOutput out, int version) throws IOException {
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public UUID deserialize(DataInput in, int version) throws IOException {
        return new UUID(in.readLong(), in.readLong());
    }

    @Override
    public long serializedSize(UUID uuid, int version) {
        return TypeSizes.NATIVE.sizeof(uuid.getMostSignificantBits()) + TypeSizes.NATIVE.sizeof(uuid.getLeastSignificantBits());
    }
}

