/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.primitives.Ints;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.SemanticVersion;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
implements QueryHandler {
    public static final SemanticVersion CQL_VERSION = new SemanticVersion("3.1.7");
    public static final QueryProcessor instance = new QueryProcessor();
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final MemoryMeter meter = new MemoryMeter();
    private static final long MAX_CACHE_PREPARED_MEMORY = Runtime.getRuntime().maxMemory() / 256L;
    private static final int MAX_CACHE_PREPARED_COUNT = 10000;
    private static EntryWeigher<MD5Digest, CQLStatement> cqlMemoryUsageWeigher = new EntryWeigher<MD5Digest, CQLStatement>(){

        public int weightOf(MD5Digest key, CQLStatement value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value)));
        }
    };
    private static EntryWeigher<Integer, CQLStatement> thriftMemoryUsageWeigher = new EntryWeigher<Integer, CQLStatement>(){

        public int weightOf(Integer key, CQLStatement value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value)));
        }
    };
    private static final ConcurrentLinkedHashMap<MD5Digest, CQLStatement> preparedStatements;
    private static final ConcurrentLinkedHashMap<Integer, CQLStatement> thriftPreparedStatements;

    private QueryProcessor() {
    }

    @Override
    public CQLStatement getPrepared(MD5Digest id) {
        return (CQLStatement)preparedStatements.get((Object)id);
    }

    @Override
    public CQLStatement getPreparedForThrift(Integer id) {
        return (CQLStatement)thriftPreparedStatements.get((Object)id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateCellNames(Iterable<ByteBuffer> cellNames) throws InvalidRequestException {
        for (ByteBuffer name : cellNames) {
            QueryProcessor.validateCellName(name);
        }
    }

    public static void validateCellName(ByteBuffer name) throws InvalidRequestException {
        if (name.remaining() > 65535) {
            throw new InvalidRequestException(String.format("The sum of all clustering columns is too long (%s > %s)", name.remaining(), 65535));
        }
        if (name.remaining() == 0) {
            throw new InvalidRequestException("Invalid empty value for clustering column of COMPACT TABLE");
        }
    }

    public static ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(queryState, options);
        return result == null ? new ResultMessage.Void() : result;
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState) throws RequestExecutionException, RequestValidationException {
        return instance.process(queryString, queryState, new QueryOptions(cl, Collections.emptyList()));
    }

    @Override
    public ResultMessage process(String queryString, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        CQLStatement prepared = QueryProcessor.getStatement((String)queryString, (ClientState)queryState.getClientState()).statement;
        if (prepared.getBoundTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        return QueryProcessor.processStatement(prepared, queryState, options);
    }

    public static CQLStatement parseStatement(String queryStr, QueryState queryState) throws RequestValidationException {
        return QueryProcessor.getStatement((String)queryStr, (ClientState)queryState.getClientState()).statement;
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        try {
            ResultMessage result = instance.process(query, QueryState.forInternalCalls(), new QueryOptions(cl, Collections.emptyList()));
            if (result instanceof ResultMessage.Rows) {
                return new UntypedResultSet(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static UntypedResultSet processInternal(String query) {
        try {
            ClientState state = ClientState.forInternalCalls();
            QueryState qState = new QueryState(state);
            state.setKeyspace("system");
            CQLStatement statement = QueryProcessor.getStatement((String)query, (ClientState)state).statement;
            statement.validate(state);
            ResultMessage result = statement.executeInternal(qState, QueryOptions.DEFAULT);
            if (result instanceof ResultMessage.Rows) {
                return new UntypedResultSet(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet resultify(String query, Row row) {
        try {
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(Collections.singletonList(row));
            return new UntypedResultSet(cqlRows);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ResultMessage.Prepared prepare(String queryString, QueryState queryState) throws RequestValidationException {
        ClientState cState = queryState.getClientState();
        return QueryProcessor.prepare(queryString, cState, cState instanceof ThriftClientState);
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState, boolean forThrift) throws RequestValidationException {
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        int boundTerms = prepared.statement.getBoundTerms();
        if (boundTerms > 65535) {
            throw new InvalidRequestException(String.format("Too many markers(?). %d markers exceed the allowed maximum of %d", boundTerms, 65535));
        }
        assert (boundTerms == prepared.boundNames.size());
        return QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared, forThrift);
    }

    private static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, ParsedStatement.Prepared prepared, boolean forThrift) throws InvalidRequestException {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        long statementSize = QueryProcessor.measure(prepared.statement);
        if (statementSize > MAX_CACHE_PREPARED_MEMORY) {
            throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d bytes.", statementSize, MAX_CACHE_PREPARED_MEMORY));
        }
        if (forThrift) {
            int statementId = toHash.hashCode();
            thriftPreparedStatements.put((Object)statementId, (Object)prepared.statement);
            logger.trace(String.format("Stored prepared statement #%d with %d bind markers", statementId, prepared.statement.getBoundTerms()));
            return ResultMessage.Prepared.forThrift(statementId, prepared.boundNames);
        }
        MD5Digest statementId = MD5Digest.compute(toHash);
        preparedStatements.put((Object)statementId, (Object)prepared.statement);
        logger.trace(String.format("Stored prepared statement %s with %d bind markers", statementId, prepared.statement.getBoundTerms()));
        return new ResultMessage.Prepared(statementId, prepared);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || statement.getBoundTerms() != 0) {
            if (variables.size() != statement.getBoundTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        return QueryProcessor.processStatement(statement, queryState, options);
    }

    @Override
    public ResultMessage processBatch(BatchStatement batch, QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState();
        batch.checkAccess(clientState);
        batch.validate(clientState);
        return batch.executeWithPerStatementVariables(options.getConsistency(), queryState, options.getValues());
    }

    public static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", queryStr);
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        Tracing.trace("Preparing statement");
        return statement.prepare();
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            ParsedStatement statement = parser.query();
            lexer.throwLastRecognitionError();
            parser.throwLastRecognitionError();
            return statement;
        }
        catch (RuntimeException re) {
            throw new SyntaxException(String.format("Failed parsing statement: [%s] reason: %s %s", queryStr, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
        }
    }

    private static long measure(Object key) {
        if (!MemoryMeter.isInitialized()) {
            return 1L;
        }
        return key instanceof MeasurableForPreparedCache ? ((MeasurableForPreparedCache)key).measureForPreparedCache(meter) : meter.measureDeep(key);
    }

    static {
        if (MemoryMeter.isInitialized()) {
            preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(cqlMemoryUsageWeigher).build();
            thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(thriftMemoryUsageWeigher).build();
        } else {
            logger.error("Unable to initialize MemoryMeter (jamm not specified as javaagent).  This means Cassandra will be unable to measure object sizes accurately and may consequently OOM.");
            preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).build();
            thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).build();
        }
    }
}

