/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.pager.NamesQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.service.pager.SliceQueryPager;

class MultiPartitionPager
implements QueryPager {
    private final SinglePartitionPager[] pagers;
    private final long timestamp;
    private int remaining;
    private int current;

    MultiPartitionPager(List<ReadCommand> commands, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state, int limitForQuery) {
        int i;
        if (state != null) {
            for (i = 0; i < commands.size() && !commands.get((int)i).key.equals(state.partitionKey); ++i) {
            }
        }
        if (i >= commands.size()) {
            this.pagers = null;
            this.timestamp = -1L;
            return;
        }
        this.pagers = new SinglePartitionPager[commands.size() - i];
        this.pagers[0] = MultiPartitionPager.makePager(commands.get(i), consistencyLevel, localQuery, state);
        this.timestamp = commands.get((int)i).timestamp;
        for (int j = i + 1; j < commands.size(); ++j) {
            ReadCommand command = commands.get(j);
            if (command.timestamp != this.timestamp) {
                throw new IllegalArgumentException("All commands must have the same timestamp or weird results may happen.");
            }
            this.pagers[j - i] = MultiPartitionPager.makePager(command, consistencyLevel, localQuery, null);
        }
        this.remaining = state == null ? limitForQuery : state.remaining;
    }

    private static SinglePartitionPager makePager(ReadCommand command, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        return command instanceof SliceFromReadCommand ? new SliceQueryPager((SliceFromReadCommand)command, consistencyLevel, localQuery, state) : new NamesQueryPager((SliceByNamesReadCommand)command, consistencyLevel, localQuery);
    }

    @Override
    public PagingState state() {
        if (this.isExhausted()) {
            return null;
        }
        PagingState state = this.pagers[this.current].state();
        return new PagingState(this.pagers[this.current].key(), state == null ? null : state.cellName, this.remaining);
    }

    @Override
    public boolean isExhausted() {
        if (this.remaining <= 0 || this.pagers == null) {
            return true;
        }
        while (this.current < this.pagers.length) {
            if (!this.pagers[this.current].isExhausted()) {
                return false;
            }
            ++this.current;
        }
        return true;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        ArrayList<Row> result = new ArrayList<Row>();
        int remainingThisQuery = Math.min(this.remaining, pageSize);
        while (remainingThisQuery > 0 && !this.isExhausted()) {
            List<Row> page = this.pagers[this.current].fetchPage(remainingThisQuery);
            if (page.isEmpty()) continue;
            Row row = page.get(0);
            int fetched = this.pagers[this.current].columnCounter().countAll(row.cf).live();
            this.remaining -= fetched;
            remainingThisQuery -= fetched;
            result.add(row);
        }
        return result;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    public long timestamp() {
        return this.timestamp;
    }
}

