/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.FrameCompressor;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class Frame {
    public final Header header;
    public final ChannelBuffer body;

    private Frame(Header header, ChannelBuffer body) {
        this.header = header;
        this.body = body;
    }

    public static Frame create(Message.Type type, int streamId, int version, EnumSet<Header.Flag> flags, ChannelBuffer body) {
        Header header = new Header(version, flags, streamId, type);
        return new Frame(header, body);
    }

    public Frame with(ChannelBuffer newBody) {
        return new Frame(this.header, newBody);
    }

    private static long discard(ChannelBuffer buffer, long remainingToDiscard) {
        int availableToDiscard = (int)Math.min(remainingToDiscard, (long)buffer.readableBytes());
        buffer.skipBytes(availableToDiscard);
        return remainingToDiscard - (long)availableToDiscard;
    }

    public static class Compressor
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            Connection connection = (Connection)channel.getAttachment();
            if (frame.header.type == Message.Type.STARTUP || connection == null) {
                return frame;
            }
            FrameCompressor compressor = connection.getCompressor();
            if (compressor == null) {
                return frame;
            }
            frame.header.flags.add(Header.Flag.COMPRESSED);
            return compressor.compress(frame);
        }
    }

    public static class Decompressor
    extends OneToOneDecoder {
        public Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            Connection connection = (Connection)channel.getAttachment();
            if (!frame.header.flags.contains((Object)Header.Flag.COMPRESSED) || connection == null) {
                return frame;
            }
            FrameCompressor compressor = connection.getCompressor();
            if (compressor == null) {
                return frame;
            }
            return compressor.decompress(frame);
        }
    }

    public static class Encoder
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            ChannelBuffer header = ChannelBuffers.buffer((int)8);
            Message.Type type = frame.header.type;
            header.writeByte(type.direction.addToVersion(frame.header.version));
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            header.writeByte(frame.header.streamId);
            header.writeByte(type.opcode);
            header.writeInt(frame.body.readableBytes());
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, frame.body});
        }
    }

    public static class Decoder
    extends FrameDecoder {
        private static final int MAX_FRAME_LENGTH = DatabaseDescriptor.getNativeTransportMaxFrameSize();
        private boolean discardingTooLongFrame;
        private long tooLongFrameLength;
        private long bytesToDiscard;
        private int tooLongStreamId;
        private final Connection.Factory factory;

        public Decoder(Connection.Factory factory) {
            this.factory = factory;
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            Message.Type type;
            if (this.discardingTooLongFrame) {
                this.bytesToDiscard = Frame.discard(buffer, this.bytesToDiscard);
                if (this.bytesToDiscard <= 0L) {
                    this.fail();
                }
                return null;
            }
            if (buffer.readableBytes() < 8) {
                return null;
            }
            int idx = buffer.readerIndex();
            byte firstByte = buffer.getByte(idx);
            Message.Direction direction = Message.Direction.extractFromVersion(firstByte);
            int version = firstByte & 0x7F;
            if (version > 2) {
                throw new ProtocolException("Invalid or unsupported protocol version: " + version);
            }
            byte flags = buffer.getByte(idx + 1);
            byte streamId = buffer.getByte(idx + 2);
            try {
                type = Message.Type.fromOpcode(buffer.getByte(idx + 3), direction);
            }
            catch (ProtocolException e) {
                throw ErrorMessage.wrap(e, streamId);
            }
            long bodyLength = buffer.getUnsignedInt(idx + 4);
            if (bodyLength < 0L) {
                buffer.skipBytes(8);
                throw ErrorMessage.wrap(new ProtocolException("Invalid frame body length: " + bodyLength), streamId);
            }
            long frameLength = bodyLength + 8L;
            if (frameLength > (long)MAX_FRAME_LENGTH) {
                this.discardingTooLongFrame = true;
                this.tooLongStreamId = streamId;
                this.tooLongFrameLength = frameLength;
                this.bytesToDiscard = Frame.discard(buffer, frameLength);
                if (this.bytesToDiscard <= 0L) {
                    this.fail();
                }
                return null;
            }
            int frameLengthInt = (int)frameLength;
            if (buffer.readableBytes() < frameLengthInt) {
                return null;
            }
            ChannelBuffer body = this.extractFrame(buffer, idx + 8, (int)bodyLength);
            buffer.readerIndex(idx + frameLengthInt);
            Connection connection = (Connection)channel.getAttachment();
            if (connection == null) {
                connection = this.factory.newConnection(channel, version);
                channel.setAttachment((Object)connection);
            } else if (connection.getVersion() != version) {
                throw ErrorMessage.wrap(new ProtocolException(String.format("Invalid message version. Got %d but previous messages on this connection had version %d", version, connection.getVersion())), streamId);
            }
            return new Frame(new Header(version, flags, (int)streamId, type), body);
        }

        private void fail() {
            long tooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            String msg = String.format("Request is too big: length %d exceeds maximum allowed length %d.", tooLongFrameLength, MAX_FRAME_LENGTH);
            throw ErrorMessage.wrap(new InvalidRequestException(msg), this.tooLongStreamId);
        }
    }

    public static class Header {
        public static final int LENGTH = 8;
        public static final int BODY_LENGTH_OFFSET = 4;
        public static final int BODY_LENGTH_SIZE = 4;
        public final int version;
        public final EnumSet<Flag> flags;
        public final int streamId;
        public final Message.Type type;

        private Header(int version, int flags, int streamId, Message.Type type) {
            this(version, Flag.deserialize(flags), streamId, type);
        }

        private Header(int version, EnumSet<Flag> flags, int streamId, Message.Type type) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.type = type;
        }

        public static enum Flag {
            COMPRESSED,
            TRACING;

            private static final Flag[] ALL_VALUES;

            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                for (int n = 0; n < ALL_VALUES.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(ALL_VALUES[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }

            static {
                ALL_VALUES = Flag.values();
            }
        }
    }
}

