/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnDefinition {
    private static final String COLUMN_NAME = "column_name";
    private static final String VALIDATOR = "validator";
    private static final String INDEX_TYPE = "index_type";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_NAME = "index_name";
    private static final String COMPONENT_INDEX = "component_index";
    private static final String TYPE = "type";
    public final ByteBuffer name;
    private AbstractType<?> validator;
    private IndexType indexType;
    private Map<String, String> indexOptions;
    private String indexName;
    public final Type type;
    public final Integer componentIndex;

    public static ColumnDefinition partitionKeyDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.PARTITION_KEY);
    }

    public static ColumnDefinition clusteringKeyDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.CLUSTERING_KEY);
    }

    public static ColumnDefinition regularDef(ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(name, validator, componentIndex, Type.REGULAR);
    }

    public static ColumnDefinition compactValueDef(ByteBuffer name, AbstractType<?> validator) {
        return new ColumnDefinition(name, validator, null, Type.COMPACT_VALUE);
    }

    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, Integer componentIndex, Type type) {
        this(name, validator, null, null, null, componentIndex, type);
    }

    @VisibleForTesting
    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, IndexType indexType, Map<String, String> indexOptions, String indexName, Integer componentIndex, Type type) {
        assert (name != null && validator != null);
        this.name = name;
        this.indexName = indexName;
        this.validator = validator;
        this.componentIndex = componentIndex;
        this.setIndexType(indexType, indexOptions);
        this.type = type;
    }

    public ColumnDefinition clone() {
        return new ColumnDefinition(this.name, this.validator, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.type);
    }

    public ColumnDefinition cloneWithNewName(ByteBuffer newName) {
        return new ColumnDefinition(newName, this.validator, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition cd = (ColumnDefinition)o;
        return Objects.equal((Object)this.name, (Object)cd.name) && Objects.equal(this.validator, cd.validator) && Objects.equal((Object)this.componentIndex, (Object)cd.componentIndex) && Objects.equal((Object)this.indexName, (Object)cd.indexName) && Objects.equal((Object)this.indexType, (Object)cd.indexType) && Objects.equal(this.indexOptions, cd.indexOptions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.validator, this.componentIndex, this.indexName, this.indexType, this.indexOptions});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)ByteBufferUtil.bytesToHex(this.name)).add(VALIDATOR, this.validator).add(TYPE, (Object)this.type).add("componentIndex", (Object)this.componentIndex).add("indexName", (Object)this.indexName).add("indexType", (Object)this.indexType).toString();
    }

    public boolean isThriftCompatible() {
        return this.type == Type.REGULAR && this.componentIndex == null;
    }

    public static List<ColumnDef> toThrift(Map<ByteBuffer, ColumnDefinition> columns) {
        ArrayList<ColumnDef> thriftDefs = new ArrayList<ColumnDef>(columns.size());
        for (ColumnDefinition def : columns.values()) {
            if (def.type != Type.REGULAR) continue;
            thriftDefs.add(def.toThrift());
        }
        return thriftDefs;
    }

    public ColumnDef toThrift() {
        ColumnDef cd = new ColumnDef();
        cd.setName(ByteBufferUtil.clone(this.name));
        cd.setValidation_class(this.validator.toString());
        cd.setIndex_type(this.indexType == null ? null : IndexType.valueOf((String)this.indexType.name()));
        cd.setIndex_name(this.indexName == null ? null : this.indexName);
        cd.setIndex_options(this.indexOptions == null ? null : Maps.newHashMap(this.indexOptions));
        return cd;
    }

    public static ColumnDefinition fromThrift(ColumnDef thriftColumnDef, boolean isSuper) throws SyntaxException, ConfigurationException {
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type, thriftColumnDef.index_options, thriftColumnDef.index_name, isSuper ? Integer.valueOf(1) : null, Type.REGULAR);
    }

    public static Map<ByteBuffer, ColumnDefinition> fromThrift(List<ColumnDef> thriftDefs, boolean isSuper) throws SyntaxException, ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromThrift(thriftColumnDef, isSuper));
        }
        return cds;
    }

    public void deleteFromSchema(RowMutation rm, String cfName, long timestamp) {
        ColumnFamily cf = rm.addOrGet(CFMetaData.SchemaColumnsCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        ColumnNameBuilder builder = CFMetaData.SchemaColumnsCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(this.name);
        cf.addAtom(new RangeTombstone(builder.build(), builder.buildAsEndOfRange(), timestamp, ldt));
    }

    public void toSchema(RowMutation rm, String cfName, AbstractType<?> comparator, long timestamp) {
        ColumnFamily cf = rm.addOrGet(CFMetaData.SchemaColumnsCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(Column.create("", timestamp, cfName, comparator.getString(this.name), ""));
        cf.addColumn(Column.create(this.validator.toString(), timestamp, cfName, comparator.getString(this.name), VALIDATOR));
        cf.addColumn(this.indexType == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), INDEX_TYPE) : Column.create(this.indexType.toString(), timestamp, cfName, comparator.getString(this.name), INDEX_TYPE));
        cf.addColumn(this.indexOptions == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), INDEX_OPTIONS) : Column.create(FBUtilities.json(this.indexOptions), timestamp, cfName, comparator.getString(this.name), INDEX_OPTIONS));
        cf.addColumn(this.indexName == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), INDEX_NAME) : Column.create(this.indexName, timestamp, cfName, comparator.getString(this.name), INDEX_NAME));
        cf.addColumn(this.componentIndex == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), COMPONENT_INDEX) : Column.create(this.componentIndex, timestamp, cfName, comparator.getString(this.name), COMPONENT_INDEX));
        cf.addColumn(Column.create(this.type.toString().toLowerCase(), timestamp, cfName, comparator.getString(this.name), TYPE));
    }

    public void apply(ColumnDefinition def, AbstractType<?> comparator) throws ConfigurationException {
        assert (this.type == def.type && Objects.equal((Object)this.componentIndex, (Object)def.componentIndex));
        if (this.getIndexType() != null && def.getIndexType() != null) {
            if (!def.getValidator().isCompatibleWith(this.getValidator())) {
                throw new ConfigurationException(String.format("Cannot modify validator to a non-order-compatible one for column %s since an index is set", comparator.getString(this.name)));
            }
            assert (this.getIndexName() != null);
            if (!this.getIndexName().equals(def.getIndexName())) {
                throw new ConfigurationException("Cannot modify index name");
            }
        }
        this.setValidator(def.getValidator());
        this.setIndexType(def.getIndexType(), def.getIndexOptions());
        this.setIndexName(def.getIndexName());
    }

    public static List<ColumnDefinition> fromSchema(Row serializedColumns, CFMetaData cfm) {
        ArrayList<ColumnDefinition> cds = new ArrayList<ColumnDefinition>();
        String query = String.format("SELECT * FROM %s.%s", "system", "schema_columns");
        for (UntypedResultSet.Row row : QueryProcessor.resultify(query, serializedColumns)) {
            AbstractType<?> validator;
            Type type = row.has(TYPE) ? Enum.valueOf(Type.class, row.getString(TYPE).toUpperCase()) : Type.REGULAR;
            Integer componentIndex = null;
            if (row.has(COMPONENT_INDEX)) {
                componentIndex = row.getInt(COMPONENT_INDEX);
            } else if (type == Type.CLUSTERING_KEY && cfm.isSuper()) {
                componentIndex = 1;
            }
            ByteBuffer name = cfm.getComponentComparator(componentIndex, type).fromString(row.getString(COLUMN_NAME));
            try {
                validator = TypeParser.parse(row.getString(VALIDATOR));
            }
            catch (RequestValidationException e) {
                throw new RuntimeException(e);
            }
            IndexType indexType = null;
            if (row.has(INDEX_TYPE)) {
                indexType = IndexType.valueOf((String)row.getString(INDEX_TYPE));
            }
            Map<String, String> indexOptions = null;
            if (row.has(INDEX_OPTIONS)) {
                indexOptions = FBUtilities.fromJsonMap(row.getString(INDEX_OPTIONS));
            }
            String indexName = null;
            if (row.has(INDEX_NAME)) {
                indexName = row.getString(INDEX_NAME);
            }
            cds.add(new ColumnDefinition(name, validator, indexType, indexOptions, indexName, componentIndex, type));
        }
        return cds;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ColumnDefinition setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ColumnDefinition setIndexType(IndexType indexType, Map<String, String> indexOptions) {
        this.indexType = indexType;
        this.indexOptions = indexOptions;
        return this;
    }

    public ColumnDefinition setIndex(String indexName, IndexType indexType, Map<String, String> indexOptions) {
        return this.setIndexName(indexName).setIndexType(indexType, indexOptions);
    }

    public boolean isIndexed() {
        return this.indexType != null;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public AbstractType<?> getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType<?> validator) {
        this.validator = validator;
    }

    public static enum Type {
        PARTITION_KEY,
        CLUSTERING_KEY,
        REGULAR,
        COMPACT_VALUE;

    }
}

