/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.pager.QueryPager;

abstract class AbstractQueryPager
implements QueryPager {
    private final ConsistencyLevel consistencyLevel;
    private final boolean localQuery;
    protected final CFMetaData cfm;
    protected final IDiskAtomFilter columnFilter;
    private final long timestamp;
    private volatile int remaining;
    private volatile boolean exhausted;
    private volatile boolean lastWasRecorded;

    protected AbstractQueryPager(ConsistencyLevel consistencyLevel, int toFetch, boolean localQuery, String keyspace, String columnFamily, IDiskAtomFilter columnFilter, long timestamp) {
        this.consistencyLevel = consistencyLevel;
        this.localQuery = localQuery;
        this.cfm = Schema.instance.getCFMetaData(keyspace, columnFamily);
        this.columnFilter = columnFilter;
        this.timestamp = timestamp;
        this.remaining = toFetch;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        int currentPageSize = this.nextPageSize(pageSize);
        List<Row> rows = this.filterEmpty(this.queryNextPage(currentPageSize, this.consistencyLevel, this.localQuery));
        if (rows.isEmpty()) {
            this.exhausted = true;
            return Collections.emptyList();
        }
        int liveCount = this.getPageLiveCount(rows);
        this.remaining -= liveCount;
        if (liveCount < currentPageSize) {
            this.exhausted = true;
        }
        if (this.containsPreviousLast(rows.get(0))) {
            rows = this.discardFirst(rows);
            ++this.remaining;
        } else if (this.lastWasRecorded && !this.exhausted) {
            rows = this.discardLast(rows);
            ++this.remaining;
        }
        if (!this.isExhausted()) {
            this.lastWasRecorded = this.recordLast(rows.get(rows.size() - 1));
        }
        return rows;
    }

    private List<Row> filterEmpty(List<Row> result) {
        for (Row row : result) {
            if (row.cf != null && row.cf.getColumnCount() != 0) continue;
            ArrayList<Row> newResult = new ArrayList<Row>(result.size() - 1);
            for (Row row2 : result) {
                if (row2.cf == null || row2.cf.getColumnCount() == 0) continue;
                newResult.add(row2);
            }
            return newResult;
        }
        return result;
    }

    protected void restoreState(int remaining, boolean lastWasRecorded) {
        this.remaining = remaining;
        this.lastWasRecorded = lastWasRecorded;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    public long timestamp() {
        return this.timestamp;
    }

    private int nextPageSize(int pageSize) {
        return Math.min(this.remaining, pageSize) + (this.lastWasRecorded ? 1 : 0);
    }

    public ColumnCounter columnCounter() {
        return this.columnFilter.columnCounter(this.cfm.comparator, this.timestamp);
    }

    protected abstract List<Row> queryNextPage(int var1, ConsistencyLevel var2, boolean var3) throws RequestValidationException, RequestExecutionException;

    protected abstract boolean containsPreviousLast(Row var1);

    protected abstract boolean recordLast(Row var1);

    private List<Row> discardFirst(List<Row> rows) {
        Row first = rows.get(0);
        ColumnFamily newCf = this.discardFirst(first.cf);
        int count = newCf.getColumnCount();
        ArrayList<Row> newRows = new ArrayList<Row>(count == 0 ? rows.size() - 1 : rows.size());
        if (count != 0) {
            newRows.add(new Row(first.key, newCf));
        }
        newRows.addAll(rows.subList(1, rows.size()));
        return newRows;
    }

    private List<Row> discardLast(List<Row> rows) {
        Row last = rows.get(rows.size() - 1);
        ColumnFamily newCf = this.discardLast(last.cf);
        int count = newCf.getColumnCount();
        ArrayList<Row> newRows = new ArrayList<Row>(count == 0 ? rows.size() - 1 : rows.size());
        newRows.addAll(rows.subList(0, rows.size() - 1));
        if (count != 0) {
            newRows.add(new Row(last.key, newCf));
        }
        return newRows;
    }

    private int getPageLiveCount(List<Row> page) {
        int count = 0;
        for (Row row : page) {
            count += this.columnCounter().countAll(row.cf).live();
        }
        return count;
    }

    private ColumnFamily discardFirst(ColumnFamily cf) {
        ColumnFamily copy = cf.cloneMeShallow();
        ColumnCounter counter = this.columnCounter();
        Iterator<Column> iter = cf.iterator();
        DeletionInfo.InOrderTester tester = cf.inOrderDeletionTester();
        while (iter.hasNext()) {
            Column c = iter.next();
            counter.count(c, tester);
            if (counter.live() <= 1) continue;
            copy.addColumn(c);
            while (iter.hasNext()) {
                copy.addColumn(iter.next());
            }
        }
        return copy;
    }

    private ColumnFamily discardLast(ColumnFamily cf) {
        ColumnFamily copy = cf.cloneMeShallow();
        int liveCount = this.columnCounter().countAll(cf).live();
        ColumnCounter counter = this.columnCounter();
        DeletionInfo.InOrderTester tester = cf.inOrderDeletionTester();
        for (Column c : cf) {
            counter.count(c, tester);
            if (counter.live() >= liveCount) continue;
            copy.addColumn(c);
        }
        return copy;
    }

    protected static ByteBuffer firstName(ColumnFamily cf) {
        return cf.iterator().next().name();
    }

    protected static ByteBuffer lastName(ColumnFamily cf) {
        return cf.getReverseSortedColumns().iterator().next().name();
    }
}

