/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecoratedKey
extends RowPosition {
    public static final Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

        @Override
        public int compare(DecoratedKey o1, DecoratedKey o2) {
            return o1.compareTo(o2);
        }
    };
    public final Token token;
    public final ByteBuffer key;

    public DecoratedKey(Token token, ByteBuffer key) {
        assert (token != null && key != null);
        this.token = token;
        this.key = key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DecoratedKey other = (DecoratedKey)obj;
        return ByteBufferUtil.compareUnsigned(this.key, other.key) == 0;
    }

    @Override
    public int compareTo(RowPosition pos) {
        if (this == pos) {
            return 0;
        }
        if (!(pos instanceof DecoratedKey)) {
            return -pos.compareTo(this);
        }
        DecoratedKey otherKey = (DecoratedKey)pos;
        int cmp = this.token.compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(this.key, otherKey.key) : cmp;
    }

    public static int compareTo(IPartitioner partitioner, ByteBuffer key, RowPosition position) {
        if (!(position instanceof DecoratedKey)) {
            return -position.compareTo(partitioner.decorateKey(key));
        }
        DecoratedKey otherKey = (DecoratedKey)position;
        int cmp = ((Token)partitioner.getToken(key)).compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(key, otherKey.key) : cmp;
    }

    @Override
    public boolean isMinimum(IPartitioner partitioner) {
        return false;
    }

    @Override
    public RowPosition.Kind kind() {
        return RowPosition.Kind.ROW_KEY;
    }

    public String toString() {
        String keystring = this.key == null ? "null" : ByteBufferUtil.bytesToHex(this.key);
        return "DecoratedKey(" + this.token + ", " + keystring + ")";
    }

    @Override
    public Token getToken() {
        return this.token;
    }
}

