/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.hadoop.AbstractColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.ReporterWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class ColumnFamilyInputFormat
extends AbstractColumnFamilyInputFormat<ByteBuffer, SortedMap<ByteBuffer, Cell>> {
    public RecordReader<ByteBuffer, SortedMap<ByteBuffer, Cell>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new ColumnFamilyRecordReader();
    }

    public org.apache.hadoop.mapred.RecordReader<ByteBuffer, SortedMap<ByteBuffer, Cell>> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        MapContext tac = HadoopCompat.newMapContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id")), null, null, null, new ReporterWrapper(reporter), null);
        ColumnFamilyRecordReader recordReader = new ColumnFamilyRecordReader(jobConf.getInt("cassandra.hadoop.max_key_size", 8192));
        recordReader.initialize((InputSplit)split, (TaskAttemptContext)tac);
        return recordReader;
    }

    @Override
    protected void validateConfiguration(Configuration conf) {
        super.validateConfiguration(conf);
        if (ConfigHelper.getInputSlicePredicate(conf) == null) {
            throw new UnsupportedOperationException("you must set the predicate with setInputSlicePredicate");
        }
    }
}

