/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.addthis.metrics.reporter.config.ReporterConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SizeEstimatesRecorder;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.RMIServerSocketFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=NativeAccess";
    public static JMXConnectorServer jmxServer = null;
    private static final Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private static final CassandraDaemon instance = new CassandraDaemon();
    private static final long EARLIEST_LAUNCH_DATE = 1215820800000L;
    public Server thriftServer;
    public Server nativeServer;
    private boolean setupCompleted = false;

    private static void maybeInitJmx() {
        String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
        if (jmxPort == null) {
            logger.warn("JMX is not enabled to receive remote connections. Please see cassandra-env.sh for more info.");
            jmxPort = System.getProperty("cassandra.jmx.local.port");
            if (jmxPort == null) {
                logger.error("cassandra.jmx.local.port missing from cassandra-env.sh, unable to start local JMX service." + jmxPort);
            } else {
                System.setProperty("java.rmi.server.hostname", InetAddress.getLoopbackAddress().getHostAddress());
                try {
                    RMIServerSocketFactoryImpl serverFactory = new RMIServerSocketFactoryImpl();
                    LocateRegistry.createRegistry(Integer.valueOf(jmxPort), null, serverFactory);
                    StringBuffer url = new StringBuffer();
                    url.append("service:jmx:");
                    url.append("rmi://localhost/jndi/");
                    url.append("rmi://localhost:").append(jmxPort).append("/jmxrmi");
                    HashMap<String, RMIServerSocketFactoryImpl> env = new HashMap<String, RMIServerSocketFactoryImpl>();
                    env.put("jmx.remote.rmi.server.socket.factory", serverFactory);
                    jmxServer = new RMIConnectorServer(new JMXServiceURL(url.toString()), env, ManagementFactory.getPlatformMBeanServer());
                    jmxServer.start();
                }
                catch (IOException e) {
                    logger.error("Error starting local jmx server: ", (Throwable)e);
                }
            }
        } else {
            logger.info("JMX is enabled to receive remote connections on port: " + jmxPort);
        }
    }

    protected void setup() {
        try {
            logger.info("Hostname: {}", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e1) {
            logger.info("Could not resolve local host");
        }
        long now = System.currentTimeMillis();
        if (now < 1215820800000L) {
            logger.error("current machine time is {}, but that is seemingly incorrect. exiting now.", (Object)new Date(now));
            System.exit(3);
        }
        if (!DatabaseDescriptor.hasLargeAddressSpace()) {
            logger.info("32bit JVM detected.  It is recommended to run Cassandra on a 64bit JVM for better performance.");
        }
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        logger.info("JVM vendor/version: {}/{}", (Object)javaVmName, (Object)javaVersion);
        if (javaVmName.contains("OpenJDK")) {
            logger.warn("OpenJDK is not recommended. Please upgrade to the newest Oracle Java release");
        } else if (!javaVmName.contains("HotSpot")) {
            logger.warn("Non-Oracle JVM detected.  Some features, such as immediate unmap of compacted SSTables, may not work as intended");
        }
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            logger.info("{} {}: {}", new Object[]{memoryPoolMXBean.getName(), memoryPoolMXBean.getType(), memoryPoolMXBean.getPeakUsage()});
        }
        logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        logger.info("JVM Arguments: {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        if (!CLibrary.jnaAvailable()) {
            boolean jnaRequired;
            boolean bl = jnaRequired = !Boolean.getBoolean("cassandra.boot_without_jna");
            if (jnaRequired) {
                logger.error("JNA failing to initialize properly. Use -Dcassandra.boot_without_jna=true to bootstrap even so.");
                System.exit(3);
            }
        }
        CLibrary.tryMlockall();
        CassandraDaemon.maybeInitJmx();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StorageMetrics.exceptions.inc();
                logger.error("Exception in thread {}", (Object)t, (Object)e);
                Tracing.trace("Exception in thread {}", t, e);
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    JVMStabilityInspector.inspectThrowable(e2);
                    if (e2 instanceof FSError) {
                        if (e2 != e) {
                            logger.error("Exception in thread {}", (Object)t, (Object)e2);
                        }
                        FileUtils.handleFSError((FSError)e2);
                    }
                    if (!(e2 instanceof CorruptSSTableException)) continue;
                    if (e2 != e) {
                        logger.error("Exception in thread " + t, e2);
                    }
                    FileUtils.handleCorruptSSTable((CorruptSSTableException)e2);
                }
            }
        });
        Iterable dirs = Iterables.concat(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()), Arrays.asList(DatabaseDescriptor.getCommitLogLocation(), DatabaseDescriptor.getSavedCachesLocation()));
        for (String string : dirs) {
            logger.debug("Checking directory {}", (Object)string);
            File file = new File(string);
            if (!file.exists()) {
                logger.error("Directory {} doesn't exist", (Object)string);
                if (!file.mkdirs()) {
                    logger.error("Has no permission to create {} directory", (Object)string);
                    System.exit(3);
                }
            }
            if (Directories.verifyFullPermissions(file, string)) continue;
            System.exit(3);
        }
        if (CacheService.instance == null) {
            throw new RuntimeException("Failed to initialize Cache Service.");
        }
        for (CFMetaData cFMetaData : Schema.instance.getKeyspaceMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories(cFMetaData);
        }
        try {
            SystemKeyspace.checkHealth();
        }
        catch (ConfigurationException configurationException) {
            logger.error("Fatal exception during initialization", (Throwable)configurationException);
            System.exit(100);
        }
        DatabaseDescriptor.loadSchemas();
        Map<Pair<String, String>, Map<Integer, UUID>> map = SystemKeyspace.getUnfinishedCompactions();
        for (Pair<String, String> pair : map.keySet()) {
            CFMetaData cfm = Schema.instance.getCFMetaData((String)pair.left, (String)pair.right);
            if (cfm == null) continue;
            ColumnFamilyStore.removeUnfinishedCompactionLeftovers(cfm, map.get(pair));
        }
        SystemKeyspace.discardCompactionsInProgress();
        for (String string : Schema.instance.getKeyspaces()) {
            if (string.equals("system")) continue;
            for (CFMetaData cfm : Schema.instance.getKeyspaceMetaData(string).values()) {
                ColumnFamilyStore.scrubDataDirectories(cfm);
            }
        }
        Keyspace.setInitialized();
        for (String string : Schema.instance.getKeyspaces()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace {}", (Object)string);
            }
            for (ColumnFamilyStore cfs : Keyspace.open(string).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        try {
            this.loadRowAndKeyCacheAsync().get();
        }
        catch (Throwable throwable) {
            JVMStabilityInspector.inspectThrowable(throwable);
            logger.warn("Error loading key or row cache", throwable);
        }
        try {
            GCInspector.register();
        }
        catch (Throwable throwable) {
            JVMStabilityInspector.inspectThrowable(throwable);
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        try {
            CommitLog.instance.recover();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    if (!store.getCompactionStrategy().shouldBeEnabled()) continue;
                    store.enableAutoCompaction();
                }
            }
        }
        SystemKeyspace.finishStartup();
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException configurationException) {
            logger.error("Fatal configuration error", (Throwable)configurationException);
            System.err.println(configurationException.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        Mx4jTool.maybeLoad();
        String string = System.getProperty("cassandra.metricsReporterConfigFile");
        if (string != null) {
            logger.info("Trying to load metrics-reporter-config from file: {}", (Object)string);
            try {
                String string2 = CassandraDaemon.class.getClassLoader().getResource(string).getFile();
                ReporterConfig.loadFromFile((String)string2).enableAll();
            }
            catch (Exception exception) {
                logger.warn("Failed to load metrics-reporter-config, metric sinks will not be activated", (Throwable)exception);
            }
        }
        if (!FBUtilities.getBroadcastAddress().equals(InetAddress.getLoopbackAddress())) {
            this.waitForGossipToSettle();
        }
        ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(ColumnFamilyStore.getBackgroundCompactionTaskSubmitter(), 5L, 1L, TimeUnit.MINUTES);
        int n = Integer.getInteger("cassandra.size_recorder_interval", 300);
        if (n > 0) {
            ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(SizeEstimatesRecorder.instance, 30L, n, TimeUnit.SECONDS);
        }
        InetAddress rpcAddr = DatabaseDescriptor.getRpcAddress();
        int rpcPort = DatabaseDescriptor.getRpcPort();
        int listenBacklog = DatabaseDescriptor.getRpcListenBacklog();
        this.thriftServer = new ThriftServer(rpcAddr, rpcPort, listenBacklog);
        InetAddress nativeAddr = DatabaseDescriptor.getRpcAddress();
        int nativePort = DatabaseDescriptor.getNativeTransportPort();
        this.nativeServer = new org.apache.cassandra.transport.Server(nativeAddr, nativePort);
        this.completeSetup();
    }

    private ListenableFuture<?> loadRowAndKeyCacheAsync() {
        ListenableFuture<Integer> keyCacheLoad = CacheService.instance.keyCache.loadSavedAsync();
        ListenableFuture<Integer> rowCacheLoad = CacheService.instance.rowCache.loadSavedAsync();
        ListenableFuture retval = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{keyCacheLoad, rowCacheLoad});
        return retval;
    }

    @VisibleForTesting
    public void completeSetup() {
        this.setupCompleted = true;
    }

    public boolean setupCompleted() {
        return this.setupCompleted;
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        String nativeFlag = System.getProperty("cassandra.start_native_transport");
        if (nativeFlag != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.nativeServer.start();
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) or nodetool (enablebinary) to start it");
        }
        String rpcFlag = System.getProperty("cassandra.start_rpc");
        if (rpcFlag != null && Boolean.parseBoolean(rpcFlag) || rpcFlag == null && DatabaseDescriptor.startRpc()) {
            this.thriftServer.start();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) or nodetool (enablethrift) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        this.thriftServer.stop();
        this.nativeServer.stop();
        if (FBUtilities.isWindows()) {
            System.exit(0);
        }
        if (jmxServer != null) {
            try {
                jmxServer.stop();
            }
            catch (IOException e) {
                logger.error("Error shutting down local JMX server: ", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(new StandardMBean(new NativeAccess(), NativeAccessMBean.class), new ObjectName(MBEAN_NAME));
            }
            catch (Exception e) {
                logger.error("error registering MBean {}", (Object)MBEAN_NAME, (Object)e);
            }
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            logger.error("Exception encountered during startup", e);
            e.printStackTrace();
            System.out.println("Exception encountered during startup: " + e.getMessage());
            System.exit(3);
        }
    }

    public void deactivate() {
        this.stop();
        this.destroy();
    }

    private void waitForGossipToSettle() {
        int forceAfter = Integer.getInteger("cassandra.skip_wait_for_gossip_to_settle", -1);
        if (forceAfter == 0) {
            return;
        }
        int GOSSIP_SETTLE_MIN_WAIT_MS = 5000;
        int GOSSIP_SETTLE_POLL_INTERVAL_MS = 1000;
        int GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED = 3;
        logger.info("Waiting for gossip to settle before accepting client requests...");
        Uninterruptibles.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        int totalPolls = 0;
        int numOkay = 0;
        JMXEnabledThreadPoolExecutor gossipStage = (JMXEnabledThreadPoolExecutor)StageManager.getStage(Stage.GOSSIP);
        while (numOkay < 3) {
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            long completed = gossipStage.getCompletedTasks();
            long active = gossipStage.getActiveCount();
            long pending = gossipStage.getPendingTasks();
            ++totalPolls;
            if (active == 0L && pending == 0L) {
                logger.debug("Gossip looks settled. CompletedTasks: {}", (Object)completed);
                ++numOkay;
            } else {
                logger.info("Gossip not settled after {} polls. Gossip Stage active/pending/completed: {}/{}/{}", new Object[]{totalPolls, active, pending, completed});
                numOkay = 0;
            }
            if (forceAfter <= 0 || totalPolls <= forceAfter) continue;
            logger.warn("Gossip not settled but startup forced by cassandra.skip_wait_for_gossip_to_settle. Gossip Stage total/active/pending/completed: {}/{}/{}/{}", new Object[]{totalPolls, active, pending, completed});
            break;
        }
        if (totalPolls > 3) {
            logger.info("Gossip settled after {} extra polls; proceeding", (Object)(totalPolls - 3));
        } else {
            logger.info("No gossip backlog; proceeding");
        }
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        @Override
        public boolean isAvailable() {
            return CLibrary.jnaAvailable();
        }

        @Override
        public boolean isMemoryLockable() {
            return CLibrary.jnaMemoryLockable();
        }
    }
}

