/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BatchlogManager;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.CASClientRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractReadExecutor;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.PrepareCallback;
import org.apache.cassandra.service.paxos.ProposeCallback;
import org.apache.cassandra.sink.SinkManager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=StorageProxy";
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile int maxHintsInProgress;
    private static final CacheLoader<InetAddress, AtomicInteger> hintsInProgress;
    private static final ClientRequestMetrics readMetrics;
    private static final ClientRequestMetrics rangeMetrics;
    private static final ClientRequestMetrics writeMetrics;
    private static final CASClientRequestMetrics casWriteMetrics;
    private static final CASClientRequestMetrics casReadMetrics;
    private static final double CONCURRENT_SUBREQUESTS_MARGIN = 0.1;

    private StorageProxy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColumnFamily cas(String keyspaceName, String cfName, ByteBuffer key, CASRequest request, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, ClientState state) throws UnavailableException, IsBootstrappingException, ReadTimeoutException, WriteTimeoutException, InvalidRequestException {
        long start = System.nanoTime();
        int contentions = 0;
        try {
            consistencyForPaxos.validateForCas();
            consistencyForCommit.validateForCasCommit(keyspaceName);
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
            long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
            while (System.nanoTime() - start < timeout) {
                Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(keyspaceName, key, consistencyForPaxos);
                List liveEndpoints = (List)p.left;
                int requiredParticipants = (Integer)p.right;
                Pair<UUID, Integer> pair = StorageProxy.beginAndRepairPaxos(start, key, metadata, liveEndpoints, requiredParticipants, consistencyForPaxos, consistencyForCommit, true, state);
                UUID ballot = (UUID)pair.left;
                contentions += ((Integer)pair.right).intValue();
                Tracing.trace("Reading existing values for CAS precondition");
                long timestamp = System.currentTimeMillis();
                ReadCommand readCommand = ReadCommand.create(keyspaceName, key, cfName, timestamp, request.readFilter());
                List<Row> rows = StorageProxy.read(Arrays.asList(readCommand), consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM);
                ColumnFamily current = rows.get((int)0).cf;
                if (!request.appliesTo(current)) {
                    Tracing.trace("CAS precondition does not match current values {}", current);
                    StorageProxy.casWriteMetrics.conditionNotMet.inc();
                    ColumnFamily columnFamily = current == null ? ArrayBackedSortedColumns.factory.create(metadata) : current;
                    return columnFamily;
                }
                ColumnFamily updates = request.makeUpdates(current);
                updates = TriggerExecutor.instance.execute(key, updates);
                Commit proposal = Commit.newProposal(key, ballot, updates);
                Tracing.trace("CAS precondition is met; proposing client-requested updates for {}", ballot);
                if (StorageProxy.proposePaxos(proposal, liveEndpoints, requiredParticipants, true, consistencyForPaxos)) {
                    StorageProxy.commitPaxos(proposal, consistencyForCommit, true);
                    Tracing.trace("CAS successful");
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                Tracing.trace("Paxos proposal not accepted (pre-empted by a higher ballot)");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(keyspaceName)));
        }
        catch (ReadTimeoutException | WriteTimeoutException e) {
            StorageProxy.casWriteMetrics.timeouts.mark();
            throw e;
        }
        catch (UnavailableException e) {
            StorageProxy.casWriteMetrics.unavailables.mark();
            throw e;
        }
        finally {
            if (contentions > 0) {
                StorageProxy.casWriteMetrics.contention.update(contentions);
            }
            casWriteMetrics.addNano(System.nanoTime() - start);
        }
    }

    private static Predicate<InetAddress> sameDCPredicateFor(final String dc) {
        final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        return new Predicate<InetAddress>(){

            public boolean apply(InetAddress host) {
                return dc.equals(snitch.getDatacenter(host));
            }
        };
    }

    private static Pair<List<InetAddress>, Integer> getPaxosParticipants(String keyspaceName, ByteBuffer key, ConsistencyLevel consistencyForPaxos) throws UnavailableException {
        Token tk = StorageService.getPartitioner().getToken(key);
        ImmutableList naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        ImmutableList pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        if (consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL) {
            String localDc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            Predicate<InetAddress> isLocalDc = StorageProxy.sameDCPredicateFor(localDc);
            naturalEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(naturalEndpoints, isLocalDc));
            pendingEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(pendingEndpoints, isLocalDc));
        }
        int participants = pendingEndpoints.size() + naturalEndpoints.size();
        int requiredParticipants = participants / 2 + 1;
        ImmutableList liveEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)naturalEndpoints, pendingEndpoints), IAsyncCallback.isAlive));
        if (liveEndpoints.size() < requiredParticipants) {
            throw new UnavailableException(consistencyForPaxos, requiredParticipants, liveEndpoints.size());
        }
        if (pendingEndpoints.size() > 1) {
            throw new UnavailableException(String.format("Cannot perform LWT operation as there is more than one (%d) pending range movement", pendingEndpoints.size()), consistencyForPaxos, participants + 1, liveEndpoints.size());
        }
        return Pair.create(liveEndpoints, requiredParticipants);
    }

    private static Pair<UUID, Integer> beginAndRepairPaxos(long start, ByteBuffer key, CFMetaData metadata, List<InetAddress> liveEndpoints, int requiredParticipants, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, boolean isWrite, ClientState state) throws WriteTimeoutException {
        long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
        PrepareCallback summary = null;
        int contentions = 0;
        while (System.nanoTime() - start < timeout) {
            long minTimestampMicrosToUse = summary == null ? Long.MIN_VALUE : 1L + UUIDGen.microsTimestamp(summary.mostRecentInProgressCommit.ballot);
            long ballotMicros = state.getTimestamp(minTimestampMicrosToUse);
            UUID ballot = UUIDGen.getTimeUUIDFromMicros(ballotMicros);
            Tracing.trace("Preparing {}", ballot);
            Commit toPrepare = Commit.newPrepare(key, metadata, ballot);
            summary = StorageProxy.preparePaxos(toPrepare, liveEndpoints, requiredParticipants, consistencyForPaxos);
            if (!summary.promised) {
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Commit inProgress = summary.mostRecentInProgressCommitWithUpdate;
            Commit mostRecent = summary.mostRecentCommit;
            if (!inProgress.update.isEmpty() && inProgress.isAfter(mostRecent)) {
                Tracing.trace("Finishing incomplete paxos round {}", inProgress);
                if (isWrite) {
                    StorageProxy.casWriteMetrics.unfinishedCommit.inc();
                } else {
                    StorageProxy.casReadMetrics.unfinishedCommit.inc();
                }
                Commit refreshedInProgress = Commit.newProposal(inProgress.key, ballot, inProgress.update);
                if (StorageProxy.proposePaxos(refreshedInProgress, liveEndpoints, requiredParticipants, false, consistencyForPaxos)) {
                    try {
                        StorageProxy.commitPaxos(refreshedInProgress, consistencyForCommit, false);
                        continue;
                    }
                    catch (WriteTimeoutException e) {
                        throw new WriteTimeoutException(WriteType.CAS, e.consistency, e.received, e.blockFor);
                    }
                }
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Iterable<InetAddress> missingMRC = summary.replicasMissingMostRecentCommit();
            if (Iterables.size(missingMRC) > 0) {
                Tracing.trace("Repairing replicas that missed the most recent commit");
                StorageProxy.sendCommit(mostRecent, missingMRC);
                continue;
            }
            return Pair.create(ballot, contentions);
        }
        throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(metadata.ksName)));
    }

    private static void sendCommit(Commit commit, Iterable<InetAddress> replicas) {
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, commit, Commit.serializer);
        for (InetAddress target : replicas) {
            MessagingService.instance().sendOneWay(message, target);
        }
    }

    private static PrepareCallback preparePaxos(Commit toPrepare, List<InetAddress> endpoints, int requiredParticipants, ConsistencyLevel consistencyForPaxos) throws WriteTimeoutException {
        PrepareCallback callback = new PrepareCallback(toPrepare.key, toPrepare.update.metadata(), requiredParticipants, consistencyForPaxos);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PREPARE, toPrepare, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        return callback;
    }

    private static boolean proposePaxos(Commit proposal, List<InetAddress> endpoints, int requiredParticipants, boolean timeoutIfPartial, ConsistencyLevel consistencyLevel) throws WriteTimeoutException {
        ProposeCallback callback = new ProposeCallback(endpoints.size(), requiredParticipants, !timeoutIfPartial, consistencyLevel);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PROPOSE, proposal, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        if (callback.isSuccessful()) {
            return true;
        }
        if (timeoutIfPartial && !callback.isFullyRefused()) {
            throw new WriteTimeoutException(WriteType.CAS, consistencyLevel, callback.getAcceptCount(), requiredParticipants);
        }
        return false;
    }

    private static void commitPaxos(Commit proposal, ConsistencyLevel consistencyLevel, boolean shouldHint) throws WriteTimeoutException {
        boolean shouldBlock = consistencyLevel != ConsistencyLevel.ANY;
        Keyspace keyspace = Keyspace.open(proposal.update.metadata().ksName);
        Token tk = StorageService.getPartitioner().getToken(proposal.key);
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspace.getName(), tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspace.getName());
        AbstractWriteResponseHandler responseHandler = null;
        if (shouldBlock) {
            AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
            responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistencyLevel, null, WriteType.SIMPLE);
        }
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, proposal, Commit.serializer);
        for (InetAddress destination : Iterables.concat(naturalEndpoints, pendingEndpoints)) {
            if (FailureDetector.instance.isAlive(destination)) {
                if (shouldBlock) {
                    if (destination.equals(FBUtilities.getBroadcastAddress())) {
                        StorageProxy.commitPaxosLocal(message, responseHandler);
                        continue;
                    }
                    MessagingService.instance().sendRR(message, destination, responseHandler, shouldHint);
                    continue;
                }
                MessagingService.instance().sendOneWay(message, destination);
                continue;
            }
            if (!shouldHint) continue;
            StorageProxy.submitHint(proposal.makeMutation(), destination, null);
        }
        if (shouldBlock) {
            responseHandler.get();
        }
    }

    private static void commitPaxosLocal(final MessageOut<Commit> message, final AbstractWriteResponseHandler responseHandler) {
        StageManager.getStage(MessagingService.verbStages.get((Object)MessagingService.Verb.PAXOS_COMMIT)).maybeExecuteImmediately(new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                PaxosState.commit((Commit)message.payload);
                if (responseHandler != null) {
                    responseHandler.response((MessageIn)null);
                }
            }

            @Override
            protected MessagingService.Verb verb() {
                return MessagingService.Verb.PAXOS_COMMIT;
            }
        });
    }

    public static void mutate(Collection<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException {
        block14: {
            Tracing.trace("Determining replicas for mutation");
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            long startTime = System.nanoTime();
            ArrayList<AbstractWriteResponseHandler> responseHandlers = new ArrayList<AbstractWriteResponseHandler>(mutations.size());
            try {
                for (IMutation iMutation : mutations) {
                    if (iMutation instanceof CounterMutation) {
                        responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)iMutation, localDataCenter));
                        continue;
                    }
                    WriteType writeType = mutations.size() <= 1 ? WriteType.SIMPLE : WriteType.UNLOGGED_BATCH;
                    responseHandlers.add(StorageProxy.performWrite(iMutation, consistency_level, localDataCenter, standardWritePerformer, null, writeType));
                }
                for (AbstractWriteResponseHandler abstractWriteResponseHandler : responseHandlers) {
                    abstractWriteResponseHandler.get();
                }
            }
            catch (WriteTimeoutException ex) {
                if (consistency_level == ConsistencyLevel.ANY) {
                    for (IMutation iMutation : mutations) {
                        if (iMutation instanceof CounterMutation) continue;
                        Token tk = StorageService.getPartitioner().getToken(iMutation.key());
                        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(iMutation.getKeyspaceName(), tk);
                        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, iMutation.getKeyspaceName());
                        for (InetAddress target : Iterables.concat(naturalEndpoints, pendingEndpoints)) {
                            if (target.equals(FBUtilities.getBroadcastAddress()) || !StorageProxy.shouldHint(target)) continue;
                            StorageProxy.submitHint((Mutation)iMutation, target, null);
                        }
                    }
                    Tracing.trace("Wrote hint to satisfy CL.ANY after no replicas acknowledged the write");
                    break block14;
                }
                StorageProxy.writeMetrics.timeouts.mark();
                ClientRequestMetrics.writeTimeouts.inc();
                Tracing.trace("Write timeout; received {} of {} required replies", ex.received, ex.blockFor);
                throw ex;
            }
            catch (UnavailableException e) {
                StorageProxy.writeMetrics.unavailables.mark();
                ClientRequestMetrics.writeUnavailables.inc();
                Tracing.trace("Unavailable");
                throw e;
            }
            catch (OverloadedException e) {
                ClientRequestMetrics.writeUnavailables.inc();
                Tracing.trace("Overloaded");
                throw e;
            }
            finally {
                writeMetrics.addNano(System.nanoTime() - startTime);
            }
        }
    }

    public static void mutateWithTriggers(Collection<? extends IMutation> mutations, ConsistencyLevel consistencyLevel, boolean mutateAtomically) throws WriteTimeoutException, UnavailableException, OverloadedException, InvalidRequestException {
        Collection<Mutation> augmented = TriggerExecutor.instance.execute(mutations);
        if (augmented != null) {
            StorageProxy.mutateAtomically(augmented, consistencyLevel);
        } else if (mutateAtomically) {
            StorageProxy.mutateAtomically(mutations, consistencyLevel);
        } else {
            StorageProxy.mutate(mutations, consistencyLevel);
        }
    }

    public static void mutateAtomically(Collection<Mutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for atomic batch");
        long startTime = System.nanoTime();
        ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        try {
            for (Mutation mutation : mutations) {
                WriteResponseHandlerWrapper wrapper = StorageProxy.wrapResponseHandler(mutation, consistency_level, WriteType.BATCH);
                wrapper.handler.assureSufficientLiveNodes();
                wrappers.add(wrapper);
            }
            Collection<InetAddress> batchlogEndpoints = StorageProxy.getBatchlogEndpoints(localDataCenter, consistency_level);
            UUID batchUUID = UUIDGen.getTimeUUID();
            StorageProxy.syncWriteToBatchlog(mutations, batchlogEndpoints, batchUUID);
            StorageProxy.syncWriteBatchedMutations(wrappers, localDataCenter);
            StorageProxy.asyncRemoveFromBatchlog(batchlogEndpoints, batchUUID);
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            ClientRequestMetrics.writeUnavailables.inc();
            Tracing.trace("Unavailable");
            throw e;
        }
        catch (WriteTimeoutException e) {
            StorageProxy.writeMetrics.timeouts.mark();
            ClientRequestMetrics.writeTimeouts.inc();
            Tracing.trace("Write timeout; received {} of {} required replies", e.received, e.blockFor);
            throw e;
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    private static void syncWriteToBatchlog(Collection<Mutation> mutations, Collection<InetAddress> endpoints, UUID uuid) throws WriteTimeoutException {
        WriteResponseHandler handler = new WriteResponseHandler(endpoints, Collections.emptyList(), ConsistencyLevel.ONE, Keyspace.open("system"), null, WriteType.BATCH_LOG);
        MessageOut<Mutation> message = BatchlogManager.getBatchlogMutationFor(mutations, uuid, 8).createMessage();
        for (InetAddress target : endpoints) {
            int targetVersion = MessagingService.instance().getVersion(target);
            if (target.equals(FBUtilities.getBroadcastAddress())) {
                StorageProxy.insertLocal((Mutation)message.payload, handler);
                continue;
            }
            if (targetVersion == 8) {
                MessagingService.instance().sendRR(message, target, handler, false);
                continue;
            }
            MessagingService.instance().sendRR(BatchlogManager.getBatchlogMutationFor(mutations, uuid, targetVersion).createMessage(), target, handler, false);
        }
        handler.get();
    }

    private static void asyncRemoveFromBatchlog(Collection<InetAddress> endpoints, UUID uuid) {
        WriteResponseHandler handler = new WriteResponseHandler(endpoints, Collections.emptyList(), ConsistencyLevel.ANY, Keyspace.open("system"), null, WriteType.SIMPLE);
        Mutation mutation = new Mutation("system", UUIDType.instance.decompose(uuid));
        mutation.delete("batchlog", FBUtilities.timestampMicros());
        MessageOut<Mutation> message = mutation.createMessage();
        for (InetAddress target : endpoints) {
            if (target.equals(FBUtilities.getBroadcastAddress())) {
                StorageProxy.insertLocal((Mutation)message.payload, handler);
                continue;
            }
            MessagingService.instance().sendRR(message, target, handler, false);
        }
    }

    private static void syncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter) throws WriteTimeoutException, OverloadedException {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            Iterable endpoints = Iterables.concat(wrapper.handler.naturalEndpoints, wrapper.handler.pendingEndpoints);
            StorageProxy.sendToHintedEndpoints(wrapper.mutation, endpoints, wrapper.handler, localDataCenter);
        }
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            wrapper.handler.get();
        }
    }

    public static AbstractWriteResponseHandler performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer, Runnable callback, WriteType writeType) throws UnavailableException, OverloadedException {
        String keyspaceName = mutation.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Token tk = StorageService.getPartitioner().getToken(mutation.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        AbstractWriteResponseHandler responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, callback, writeType);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, Iterables.concat(naturalEndpoints, pendingEndpoints), responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static WriteResponseHandlerWrapper wrapResponseHandler(Mutation mutation, ConsistencyLevel consistency_level, WriteType writeType) {
        AbstractReplicationStrategy rs = Keyspace.open(mutation.getKeyspaceName()).getReplicationStrategy();
        String keyspaceName = mutation.getKeyspaceName();
        Token tk = StorageService.getPartitioner().getToken(mutation.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        AbstractWriteResponseHandler responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, null, writeType);
        return new WriteResponseHandlerWrapper(responseHandler, mutation);
    }

    private static Collection<InetAddress> getBatchlogEndpoints(String localDataCenter, ConsistencyLevel consistencyLevel) throws UnavailableException {
        TokenMetadata.Topology topology = StorageService.instance.getTokenMetadata().cachedOnlyTokenMap().getTopology();
        HashMultimap localEndpoints = HashMultimap.create(topology.getDatacenterRacks().get(localDataCenter));
        String localRack = DatabaseDescriptor.getEndpointSnitch().getRack(FBUtilities.getBroadcastAddress());
        Collection<InetAddress> chosenEndpoints = new BatchlogManager.EndpointFilter(localRack, (Multimap<String, InetAddress>)localEndpoints).filter();
        if (chosenEndpoints.isEmpty()) {
            if (consistencyLevel == ConsistencyLevel.ANY) {
                return Collections.singleton(FBUtilities.getBroadcastAddress());
            }
            throw new UnavailableException(ConsistencyLevel.ONE, 1, 0);
        }
        return chosenEndpoints;
    }

    public static void sendToHintedEndpoints(Mutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter) throws OverloadedException {
        HashMap dcGroups = null;
        MessageOut<Mutation> message = null;
        boolean insertLocal = false;
        for (InetAddress destination : targets) {
            StorageProxy.checkHintOverload(destination);
            if (FailureDetector.instance.isAlive(destination)) {
                ArrayList<InetAddress> messages;
                String dc;
                if (destination.equals(FBUtilities.getBroadcastAddress())) {
                    insertLocal = true;
                    continue;
                }
                if (message == null) {
                    message = mutation.createMessage();
                }
                if (localDataCenter.equals(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination))) {
                    MessagingService.instance().sendRR(message, destination, responseHandler, true);
                    continue;
                }
                ArrayList<InetAddress> arrayList = messages = dcGroups != null ? (ArrayList<InetAddress>)dcGroups.get(dc) : null;
                if (messages == null) {
                    messages = new ArrayList<InetAddress>(3);
                    if (dcGroups == null) {
                        dcGroups = new HashMap();
                    }
                    dcGroups.put(dc, messages);
                }
                messages.add(destination);
                continue;
            }
            if (!StorageProxy.shouldHint(destination)) continue;
            StorageProxy.submitHint(mutation, destination, responseHandler);
        }
        if (insertLocal) {
            StorageProxy.insertLocal(mutation, responseHandler);
        }
        if (dcGroups != null) {
            if (message == null) {
                message = mutation.createMessage();
            }
            for (Collection dcTargets : dcGroups.values()) {
                StorageProxy.sendMessagesToNonlocalDC(message, dcTargets, responseHandler);
            }
        }
    }

    private static void checkHintOverload(InetAddress destination) throws OverloadedException {
        if (StorageMetrics.totalHintsInProgress.count() > (long)maxHintsInProgress && StorageProxy.getHintsInProgressFor(destination).get() > 0 && StorageProxy.shouldHint(destination)) {
            throw new OverloadedException("Too many in flight hints: " + StorageMetrics.totalHintsInProgress.count() + " destination: " + destination + " destination hints: " + StorageProxy.getHintsInProgressFor(destination).get());
        }
    }

    private static AtomicInteger getHintsInProgressFor(InetAddress destination) {
        try {
            return (AtomicInteger)hintsInProgress.load((Object)destination);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Future<Void> submitHint(final Mutation mutation, InetAddress target, final AbstractWriteResponseHandler responseHandler) {
        assert (!target.equals(FBUtilities.getBroadcastAddress())) : target;
        HintRunnable runnable = new HintRunnable(target){

            @Override
            public void runMayThrow() {
                int ttl = HintedHandOffManager.calculateHintTTL(mutation);
                if (ttl > 0) {
                    logger.debug("Adding hint for {}", (Object)this.target);
                    StorageProxy.writeHintForMutation(mutation, System.currentTimeMillis(), ttl, this.target);
                    if (responseHandler != null && responseHandler.consistencyLevel == ConsistencyLevel.ANY) {
                        responseHandler.response((MessageIn)null);
                    }
                } else {
                    logger.debug("Skipped writing hint for {} (ttl {})", (Object)this.target, (Object)ttl);
                }
            }
        };
        return StorageProxy.submitHint(runnable);
    }

    private static Future<Void> submitHint(HintRunnable runnable) {
        StorageMetrics.totalHintsInProgress.inc();
        StorageProxy.getHintsInProgressFor(runnable.target).incrementAndGet();
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    public static void writeHintForMutation(Mutation mutation, long now, int ttl, InetAddress target) {
        assert (ttl > 0);
        UUID hostId = StorageService.instance.getTokenMetadata().getHostId(target);
        if (hostId != null) {
            HintedHandOffManager.instance.hintFor(mutation, now, ttl, Pair.create(target, hostId)).apply();
            StorageMetrics.totalHints.inc();
        } else {
            logger.debug("Discarding hint for endpoint not part of ring: {}", (Object)target);
        }
    }

    private static void sendMessagesToNonlocalDC(MessageOut<? extends IMutation> message, Collection<InetAddress> targets, AbstractWriteResponseHandler handler) {
        Iterator<InetAddress> iter = targets.iterator();
        InetAddress target = iter.next();
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            out.writeInt(targets.size() - 1);
            while (iter.hasNext()) {
                InetAddress destination = iter.next();
                CompactEndpointSerializationHelper.serialize(destination, out);
                int id = MessagingService.instance().addCallback(handler, message, destination, message.getTimeout(), handler.consistencyLevel, true);
                out.writeInt(id);
                logger.trace("Adding FWD message to {}@{}", (Object)id, (Object)destination);
            }
            message = message.withParameter("FWD_TO", out.getData());
            int id = MessagingService.instance().sendRR(message, target, handler, true);
            logger.trace("Sending message to {}@{}", (Object)id, (Object)target);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void insertLocal(final Mutation mutation, final AbstractWriteResponseHandler responseHandler) {
        StageManager.getStage(Stage.MUTATION).maybeExecuteImmediately(new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                IMutation processed = SinkManager.processWriteRequest(mutation);
                if (processed != null) {
                    ((Mutation)processed).apply();
                    responseHandler.response((MessageIn)null);
                }
            }

            @Override
            protected MessagingService.Verb verb() {
                return MessagingService.Verb.MUTATION;
            }
        });
    }

    public static AbstractWriteResponseHandler mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getKeyspaceName(), cm.key(), localDataCenter, cm.consistency());
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String keyspaceName = cm.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Token tk = StorageService.getPartitioner().getToken(cm.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, cm.consistency(), null, WriteType.COUNTER).assureSufficientLiveNodes();
        WriteResponseHandler responseHandler = new WriteResponseHandler(endpoint, WriteType.COUNTER);
        Tracing.trace("Enqueuing counter update to {}", endpoint);
        MessagingService.instance().sendRR(cm.makeMutationMessage(), endpoint, responseHandler, false);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String keyspaceName, ByteBuffer key, String localDataCenter, ConsistencyLevel cl) throws UnavailableException {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException(cl, cl.blockFor(keyspace), 0);
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(ThreadLocalRandom.current().nextInt(localEndpoints.size()));
    }

    public static AbstractWriteResponseHandler applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter, Runnable callback) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer, callback, WriteType.COUNTER);
    }

    public static AbstractWriteResponseHandler applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer, null, WriteType.COUNTER);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Iterable<InetAddress> targets, final AbstractWriteResponseHandler responseHandler, final String localDataCenter) {
        return new DroppableRunnable(MessagingService.Verb.COUNTER_MUTATION){

            @Override
            public void runMayThrow() throws OverloadedException, WriteTimeoutException {
                IMutation processed = SinkManager.processWriteRequest(mutation);
                if (processed == null) {
                    return;
                }
                assert (processed instanceof CounterMutation);
                CounterMutation cm = (CounterMutation)processed;
                Mutation result = cm.apply();
                responseHandler.response((MessageIn)null);
                Sets.SetView remotes = Sets.difference((Set)ImmutableSet.copyOf((Iterable)targets), (Set)ImmutableSet.of((Object)FBUtilities.getBroadcastAddress()));
                if (!remotes.isEmpty()) {
                    StorageProxy.sendToHintedEndpoints(result, (Iterable<InetAddress>)remotes, responseHandler, localDataCenter);
                }
            }
        };
    }

    private static boolean systemKeyspaceQuery(List<ReadCommand> cmds) {
        for (ReadCommand cmd : cmds) {
            if (cmd.ksName.equals("system")) continue;
            return false;
        }
        return true;
    }

    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistencyLevel) throws UnavailableException, IsBootstrappingException, ReadTimeoutException, InvalidRequestException {
        assert (!consistencyLevel.isSerialConsistency());
        return StorageProxy.read(commands, consistencyLevel, null);
    }

    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistencyLevel, ClientState state) throws UnavailableException, IsBootstrappingException, ReadTimeoutException, InvalidRequestException {
        if (StorageService.instance.isBootstrapMode() && !StorageProxy.systemKeyspaceQuery(commands)) {
            StorageProxy.readMetrics.unavailables.mark();
            ClientRequestMetrics.readUnavailables.inc();
            throw new IsBootstrappingException();
        }
        return consistencyLevel.isSerialConsistency() ? StorageProxy.readWithPaxos(commands, consistencyLevel, state) : StorageProxy.readRegular(commands, consistencyLevel);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Row> readWithPaxos(List<ReadCommand> commands, ConsistencyLevel consistencyLevel, ClientState state) throws InvalidRequestException, UnavailableException, ReadTimeoutException {
        assert (state != null);
        long start = System.nanoTime();
        List<Row> rows = null;
        try {
            if (commands.size() > 1) {
                throw new InvalidRequestException("SERIAL/LOCAL_SERIAL consistency may only be requested for one row at a time");
            }
            ReadCommand command = commands.get(0);
            CFMetaData metadata = Schema.instance.getCFMetaData(command.ksName, command.cfName);
            Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(command.ksName, command.key, consistencyLevel);
            List liveEndpoints = (List)p.left;
            int requiredParticipants = (Integer)p.right;
            ConsistencyLevel consistencyForCommitOrFetch = consistencyLevel == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
            try {
                Pair<UUID, Integer> pair = StorageProxy.beginAndRepairPaxos(start, command.key, metadata, liveEndpoints, requiredParticipants, consistencyLevel, consistencyForCommitOrFetch, false, state);
                if ((Integer)pair.right > 0) {
                    StorageProxy.casReadMetrics.contention.update(((Integer)pair.right).intValue());
                }
            }
            catch (WriteTimeoutException e) {
                throw new ReadTimeoutException(consistencyLevel, 0, consistencyLevel.blockFor(Keyspace.open(command.ksName)), false);
            }
            rows = StorageProxy.fetchRows(commands, consistencyForCommitOrFetch);
        }
        catch (UnavailableException e) {
            try {
                StorageProxy.readMetrics.unavailables.mark();
                ClientRequestMetrics.readUnavailables.inc();
                StorageProxy.casReadMetrics.unavailables.mark();
                throw e;
                catch (ReadTimeoutException e2) {
                    StorageProxy.readMetrics.timeouts.mark();
                    ClientRequestMetrics.readTimeouts.inc();
                    StorageProxy.casReadMetrics.timeouts.mark();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                long latency = System.nanoTime() - start;
                readMetrics.addNano(latency);
                casReadMetrics.addNano(latency);
                Iterator<ReadCommand> iterator = commands.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    ReadCommand command = iterator.next();
                    Keyspace.open((String)command.ksName).getColumnFamilyStore((String)command.cfName).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
                }
            }
        }
        long latency = System.nanoTime() - start;
        readMetrics.addNano(latency);
        casReadMetrics.addNano(latency);
        Iterator<ReadCommand> iterator = commands.iterator();
        while (iterator.hasNext()) {
            ReadCommand command = iterator.next();
            Keyspace.open((String)command.ksName).getColumnFamilyStore((String)command.cfName).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return rows;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Row> readRegular(List<ReadCommand> commands, ConsistencyLevel consistencyLevel) throws UnavailableException, ReadTimeoutException {
        long start = System.nanoTime();
        List<Row> rows = null;
        try {
            rows = StorageProxy.fetchRows(commands, consistencyLevel);
        }
        catch (UnavailableException e) {
            try {
                StorageProxy.readMetrics.unavailables.mark();
                ClientRequestMetrics.readUnavailables.inc();
                throw e;
                catch (ReadTimeoutException e2) {
                    StorageProxy.readMetrics.timeouts.mark();
                    ClientRequestMetrics.readTimeouts.inc();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                long latency = System.nanoTime() - start;
                readMetrics.addNano(latency);
                Iterator<ReadCommand> iterator = commands.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    ReadCommand command = iterator.next();
                    Keyspace.open((String)command.ksName).getColumnFamilyStore((String)command.cfName).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
                }
            }
        }
        long latency = System.nanoTime() - start;
        readMetrics.addNano(latency);
        Iterator<ReadCommand> iterator = commands.iterator();
        while (iterator.hasNext()) {
            ReadCommand command = iterator.next();
            Keyspace.open((String)command.ksName).getColumnFamilyStore((String)command.cfName).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return rows;
    }

    private static List<Row> fetchRows(List<ReadCommand> initialCommands, ConsistencyLevel consistencyLevel) throws UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows = new ArrayList<Row>(initialCommands.size());
        List commandsToRetry = Collections.emptyList();
        do {
            List<ReadCommand> commands = commandsToRetry.isEmpty() ? initialCommands : commandsToRetry;
            AbstractReadExecutor[] readExecutors = new AbstractReadExecutor[commands.size()];
            if (!commandsToRetry.isEmpty()) {
                Tracing.trace("Retrying {} commands", commandsToRetry.size());
            }
            for (int i = 0; i < commands.size(); ++i) {
                ReadCommand command = commands.get(i);
                assert (!command.isDigestQuery());
                AbstractReadExecutor exec = AbstractReadExecutor.getReadExecutor(command, consistencyLevel);
                exec.executeAsync();
                readExecutors[i] = exec;
            }
            for (AbstractReadExecutor exec : readExecutors) {
                exec.maybeTryAdditionalReplicas();
            }
            ArrayList<ReadCommand> repairCommands = null;
            ArrayList<ReadCallback<ReadResponse, Row>> repairResponseHandlers = null;
            for (AbstractReadExecutor exec : readExecutors) {
                try {
                    Row row = exec.get();
                    if (row != null) {
                        row = exec.command.maybeTrim(row);
                        rows.add(row);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Read: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - exec.handler.start));
                }
                catch (ReadTimeoutException ex) {
                    String gotData;
                    int blockFor = consistencyLevel.blockFor(Keyspace.open(exec.command.getKeyspace()));
                    int responseCount = exec.handler.getReceivedCount();
                    String string = responseCount > 0 ? (exec.resolver.isDataPresent() ? " (including data)" : " (only digests)") : (gotData = "");
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out; received {} of {} responses{}", new Object[]{responseCount, blockFor, gotData});
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Read timeout; received {} of {} responses{}", new Object[]{responseCount, blockFor, gotData});
                    }
                    throw ex;
                }
                catch (DigestMismatchException ex) {
                    Tracing.trace("Digest mismatch: {}", ex);
                    ReadRepairMetrics.repairedBlocking.mark();
                    RowDataResolver resolver = new RowDataResolver(exec.command.ksName, exec.command.key, exec.command.filter(), exec.command.timestamp);
                    ReadCallback<ReadResponse, Row> repairHandler = new ReadCallback<ReadResponse, Row>(resolver, ConsistencyLevel.ALL, exec.getContactedReplicas().size(), exec.command, Keyspace.open(exec.command.getKeyspace()), exec.handler.endpoints);
                    if (repairCommands == null) {
                        repairCommands = new ArrayList<ReadCommand>();
                        repairResponseHandlers = new ArrayList<ReadCallback<ReadResponse, Row>>();
                    }
                    repairCommands.add(exec.command);
                    repairResponseHandlers.add(repairHandler);
                    MessageOut<ReadCommand> message = exec.command.createMessage();
                    for (InetAddress endpoint : exec.getContactedReplicas()) {
                        Tracing.trace("Enqueuing full data read to {}", endpoint);
                        MessagingService.instance().sendRR(message, endpoint, repairHandler);
                    }
                }
            }
            commandsToRetry.clear();
            if (repairResponseHandlers == null) continue;
            for (int i = 0; i < repairCommands.size(); ++i) {
                Row row;
                ReadCommand command = (ReadCommand)repairCommands.get(i);
                ReadCallback handler = (ReadCallback)repairResponseHandlers.get(i);
                try {
                    row = (Row)handler.get();
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ReadTimeoutException e) {
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out waiting on digest mismatch repair requests");
                    } else {
                        logger.debug("Timed out waiting on digest mismatch repair requests");
                    }
                    int blockFor = consistencyLevel.blockFor(Keyspace.open(command.getKeyspace()));
                    throw new ReadTimeoutException(consistencyLevel, blockFor - 1, blockFor, true);
                }
                RowDataResolver resolver = (RowDataResolver)handler.resolver;
                try {
                    FBUtilities.waitOnFutures(resolver.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (TimeoutException e) {
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out waiting on digest mismatch repair acknowledgements");
                    } else {
                        logger.debug("Timed out waiting on digest mismatch repair acknowledgements");
                    }
                    int blockFor = consistencyLevel.blockFor(Keyspace.open(command.getKeyspace()));
                    throw new ReadTimeoutException(consistencyLevel, blockFor - 1, blockFor, true);
                }
                ReadCommand retryCommand = command.maybeGenerateRetryCommand(resolver, row);
                if (retryCommand != null) {
                    Tracing.trace("Issuing retry for read command");
                    if (commandsToRetry == Collections.EMPTY_LIST) {
                        commandsToRetry = new ArrayList();
                    }
                    commandsToRetry.add(retryCommand);
                    continue;
                }
                if (row == null) continue;
                row = command.maybeTrim(row);
                rows.add(row);
            }
        } while (!commandsToRetry.isEmpty());
        return rows;
    }

    public static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, ByteBuffer key) {
        return StorageProxy.getLiveSortedEndpoints(keyspace, StorageService.getPartitioner().decorateKey(key));
    }

    private static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, RingPosition pos) {
        List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, pos);
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), liveEndpoints);
        return liveEndpoints;
    }

    private static List<InetAddress> intersection(List<InetAddress> l1, List<InetAddress> l2) {
        ArrayList<InetAddress> inter = new ArrayList<InetAddress>(l1);
        inter.retainAll(l2);
        return inter;
    }

    private static float estimateResultRowsPerRange(AbstractRangeCommand command, Keyspace keyspace) {
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(command.columnFamily);
        float resultRowsPerRange = Float.POSITIVE_INFINITY;
        if (command.rowFilter != null && !command.rowFilter.isEmpty()) {
            List<SecondaryIndexSearcher> searchers = cfs.indexManager.getIndexSearchersForQuery(command.rowFilter);
            if (searchers.isEmpty()) {
                resultRowsPerRange = StorageProxy.calculateResultRowsUsingEstimatedKeys(cfs);
            } else {
                for (SecondaryIndexSearcher searcher : searchers) {
                    SecondaryIndex highestSelectivityIndex = searcher.highestSelectivityIndex(command.rowFilter);
                    resultRowsPerRange = highestSelectivityIndex == null ? resultRowsPerRange : Math.min(resultRowsPerRange, (float)highestSelectivityIndex.estimateResultRows());
                }
            }
        } else {
            resultRowsPerRange = !command.countCQL3Rows() ? (float)cfs.estimateKeys() : StorageProxy.calculateResultRowsUsingEstimatedKeys(cfs);
        }
        return resultRowsPerRange / (float)DatabaseDescriptor.getNumTokens().intValue() / (float)keyspace.getReplicationStrategy().getReplicationFactor();
    }

    private static float calculateResultRowsUsingEstimatedKeys(ColumnFamilyStore cfs) {
        if (cfs.metadata.comparator.isDense()) {
            return cfs.estimateKeys();
        }
        float resultRowsPerStorageRow = (float)cfs.getMeanColumns() / (float)cfs.metadata.regularColumns().size();
        return resultRowsPerStorageRow * (float)cfs.estimateKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public static List<Row> getRangeSlice(AbstractRangeCommand command, ConsistencyLevel consistency_level) throws UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows;
        Tracing.trace("Computing ranges to query");
        long startTime = System.nanoTime();
        Keyspace keyspace = Keyspace.open(command.keyspace);
        try {
            int concurrencyFactor;
            int liveRowCount = 0;
            boolean countLiveRows = command.countCQL3Rows() || command.ignoredTombstonedPartitions();
            rows = new ArrayList<Row>();
            List<AbstractBounds<RowPosition>> ranges = keyspace.getReplicationStrategy() instanceof LocalStrategy ? command.keyRange.unwrap() : StorageProxy.getRestrictedRanges(command.keyRange);
            int rowsToBeFetched = command.limit();
            if (command.requiresScanningAllRanges()) {
                rowsToBeFetched *= ranges.size();
                concurrencyFactor = ranges.size();
                logger.debug("Requested rows: {}, ranges.size(): {}; concurrent range requests: {}", new Object[]{command.limit(), ranges.size(), concurrencyFactor});
                Tracing.trace("Submitting range requests on {} ranges with a concurrency of {}", new Object[]{ranges.size(), concurrencyFactor});
            } else {
                float resultRowsPerRange = StorageProxy.estimateResultRowsPerRange(command, keyspace);
                concurrencyFactor = (double)(resultRowsPerRange = (float)((double)resultRowsPerRange - (double)resultRowsPerRange * 0.1)) == 0.0 ? 1 : Math.max(1, Math.min(ranges.size(), (int)Math.ceil((float)command.limit() / resultRowsPerRange)));
                logger.debug("Estimated result rows per range: {}; requested rows: {}, ranges.size(): {}; concurrent range requests: {}", new Object[]{Float.valueOf(resultRowsPerRange), command.limit(), ranges.size(), concurrencyFactor});
                Tracing.trace("Submitting range requests on {} ranges with a concurrency of {} ({} rows per range expected)", new Object[]{ranges.size(), concurrencyFactor, Float.valueOf(resultRowsPerRange)});
            }
            boolean haveSufficientRows = false;
            int i = 0;
            AbstractBounds<RowPosition> nextRange = null;
            List<InetAddress> nextEndpoints = null;
            List<InetAddress> nextFilteredEndpoints = null;
            while (i < ranges.size()) {
                float actualRowsPerRange;
                RangeSliceResponseResolver resolver;
                ArrayList<Pair<AbstractRangeCommand, ReadCallback<RangeSliceReply, Iterable<Row>>>> scanHandlers = new ArrayList<Pair<AbstractRangeCommand, ReadCallback<RangeSliceReply, Iterable<Row>>>>(concurrencyFactor);
                int concurrentFetchStartingIndex = i;
                int concurrentRequests = 0;
                while (i - concurrentFetchStartingIndex < concurrencyFactor) {
                    AbstractBounds<RowPosition> range = nextRange == null ? ranges.get(i) : nextRange;
                    List<InetAddress> liveEndpoints = nextEndpoints == null ? StorageProxy.getLiveSortedEndpoints(keyspace, range.right) : nextEndpoints;
                    List<InetAddress> filteredEndpoints = nextFilteredEndpoints == null ? consistency_level.filterForQuery(keyspace, liveEndpoints) : nextFilteredEndpoints;
                    ++i;
                    ++concurrentRequests;
                    while (i < ranges.size()) {
                        List<InetAddress> merged;
                        nextRange = ranges.get(i);
                        nextEndpoints = StorageProxy.getLiveSortedEndpoints(keyspace, nextRange.right);
                        nextFilteredEndpoints = consistency_level.filterForQuery(keyspace, nextEndpoints);
                        if (((RowPosition)range.right).isMinimum() || !consistency_level.isSufficientLiveNodes(keyspace, merged = StorageProxy.intersection(liveEndpoints, nextEndpoints))) break;
                        List<InetAddress> filteredMerged = consistency_level.filterForQuery(keyspace, merged);
                        if (!DatabaseDescriptor.getEndpointSnitch().isWorthMergingForRangeQuery(filteredMerged, filteredEndpoints, nextFilteredEndpoints)) break;
                        range = range.withNewRight((RowPosition)nextRange.right);
                        liveEndpoints = merged;
                        filteredEndpoints = filteredMerged;
                        ++i;
                    }
                    AbstractRangeCommand nodeCmd = command.forSubRange(range);
                    resolver = new RangeSliceResponseResolver(nodeCmd.keyspace, command.timestamp);
                    List<InetAddress> minimalEndpoints = filteredEndpoints.subList(0, Math.min(filteredEndpoints.size(), consistency_level.blockFor(keyspace)));
                    ReadCallback<RangeSliceReply, Iterable<Row>> handler = new ReadCallback<RangeSliceReply, Iterable<Row>>(resolver, consistency_level, nodeCmd, minimalEndpoints);
                    handler.assureSufficientLiveNodes();
                    resolver.setSources(filteredEndpoints);
                    if (filteredEndpoints.size() == 1 && filteredEndpoints.get(0).equals(FBUtilities.getBroadcastAddress())) {
                        StageManager.getStage(Stage.READ).execute(new LocalRangeSliceRunnable(nodeCmd, handler), Tracing.instance.get());
                    } else {
                        MessageOut<? extends AbstractRangeCommand> message = nodeCmd.createMessage();
                        for (InetAddress endpoint : filteredEndpoints) {
                            Tracing.trace("Enqueuing request to {}", endpoint);
                            MessagingService.instance().sendRR(message, endpoint, handler);
                        }
                    }
                    scanHandlers.add(Pair.create(nodeCmd, handler));
                }
                Tracing.trace("Submitted {} concurrent range requests covering {} ranges", concurrentRequests, i - concurrentFetchStartingIndex);
                ArrayList<AsyncOneResponse> repairResponses = new ArrayList<AsyncOneResponse>();
                for (Pair cmdPairHandler : scanHandlers) {
                    ReadCallback handler = (ReadCallback)cmdPairHandler.right;
                    resolver = (RangeSliceResponseResolver)handler.resolver;
                    try {
                        for (Row row : (Iterable)handler.get()) {
                            rows.add(row);
                            if (!countLiveRows) continue;
                            liveRowCount += row.getLiveCount(command.predicate, command.timestamp);
                        }
                        repairResponses.addAll(resolver.repairResults);
                    }
                    catch (ReadTimeoutException ex) {
                        String gotData;
                        int blockFor = consistency_level.blockFor(keyspace);
                        int responseCount = resolver.responses.size();
                        String string = responseCount > 0 ? (resolver.isDataPresent() ? " (including data)" : " (only digests)") : (gotData = "");
                        if (Tracing.isTracing()) {
                            Tracing.trace("Timed out; received {} of {} responses{} for range {} of {}", new Object[]{responseCount, blockFor, gotData, i, ranges.size()});
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Range slice timeout; received {} of {} responses{} for range {} of {}", new Object[]{responseCount, blockFor, gotData, i, ranges.size()});
                        }
                        throw ex;
                    }
                    catch (DigestMismatchException e) {
                        throw new AssertionError((Object)e);
                    }
                    int count = countLiveRows ? liveRowCount : rows.size();
                    if (count < rowsToBeFetched) continue;
                    haveSufficientRows = true;
                    break;
                }
                try {
                    FBUtilities.waitOnFutures(repairResponses, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (TimeoutException ex) {
                    int blockFor = consistency_level.blockFor(keyspace);
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", blockFor);
                    } else {
                        logger.debug("Range slice timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                    }
                    throw new ReadTimeoutException(consistency_level, blockFor - 1, blockFor, true);
                }
                if (haveSufficientRows) {
                    List<Row> ex = command.postReconciliationProcessing(rows);
                    return ex;
                }
                if (i >= ranges.size()) continue;
                float fetchedRows = countLiveRows ? (float)liveRowCount : (float)rows.size();
                float remainingRows = (float)rowsToBeFetched - fetchedRows;
                if ((double)fetchedRows == 0.0) {
                    actualRowsPerRange = 0.0f;
                    concurrencyFactor = ranges.size() - i;
                } else {
                    actualRowsPerRange = fetchedRows / (float)i;
                    concurrencyFactor = Math.max(1, Math.min(ranges.size() - i, Math.round(remainingRows / actualRowsPerRange)));
                }
                logger.debug("Didn't get enough response rows; actual rows per range: {}; remaining rows: {}, new concurrent requests: {}", new Object[]{Float.valueOf(actualRowsPerRange), (int)remainingRows, concurrencyFactor});
            }
        }
        finally {
            long latency = System.nanoTime() - startTime;
            rangeMetrics.addNano(latency);
            Keyspace.open((String)command.keyspace).getColumnFamilyStore((String)command.columnFamily).metric.coordinatorScanLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return command.postReconciliationProcessing(rows);
    }

    @Override
    public Map<String, List<String>> getSchemaVersions() {
        return StorageProxy.describeSchemaVersions();
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = Schema.instance.getVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback<UUID> cb = new IAsyncCallback<UUID>(){

            @Override
            public void response(MessageIn<UUID> message) {
                versions.put(message.from, message.payload);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessageOut message = new MessageOut(MessagingService.Verb.SCHEMA_CHECK);
        for (InetAddress endpoint : liveHosts) {
            MessagingService.instance().sendRR(message, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Iterable)((Iterable)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition<T>> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum(StorageService.getPartitioner())) {
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return StorageProxy.readMetrics.latency.count();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return StorageProxy.readMetrics.totalLatency.count();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getRangeOperations() {
        return StorageProxy.rangeMetrics.latency.count();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return StorageProxy.rangeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getWriteOperations() {
        return StorageProxy.writeMetrics.latency.count();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return StorageProxy.writeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return DatabaseDescriptor.hintedHandoffEnabled();
    }

    @Override
    public Set<String> getHintedHandoffEnabledByDC() {
        return DatabaseDescriptor.hintedHandoffEnabledByDC();
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        DatabaseDescriptor.setHintedHandoffEnabled(b);
    }

    @Override
    public void setHintedHandoffEnabledByDCList(String dcNames) {
        DatabaseDescriptor.setHintedHandoffEnabled(dcNames);
    }

    @Override
    public int getMaxHintWindow() {
        return DatabaseDescriptor.getMaxHintWindow();
    }

    @Override
    public void setMaxHintWindow(int ms) {
        DatabaseDescriptor.setMaxHintWindow(ms);
    }

    public static boolean shouldHint(InetAddress ep) {
        boolean hintWindowExpired;
        if (DatabaseDescriptor.shouldHintByDC()) {
            String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(ep);
            if (!DatabaseDescriptor.hintedHandoffEnabled(dc)) {
                HintedHandOffManager.instance.metrics.incrPastWindow(ep);
                return false;
            }
        } else if (!DatabaseDescriptor.hintedHandoffEnabled()) {
            HintedHandOffManager.instance.metrics.incrPastWindow(ep);
            return false;
        }
        boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(ep) > (long)DatabaseDescriptor.getMaxHintWindow();
        if (hintWindowExpired) {
            HintedHandOffManager.instance.metrics.incrPastWindow(ep);
            Tracing.trace("Not hinting {} which has been down {}ms", ep, Gossiper.instance.getEndpointDowntime(ep));
        }
        return !hintWindowExpired;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF {}", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyStorageHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            int liveMembers = Gossiper.instance.getLiveMembers().size();
            throw new UnavailableException(ConsistencyLevel.ALL, liveMembers + Gossiper.instance.getUnreachableMembers().size(), liveMembers);
        }
        Set<InetAddress> allEndpoints = StorageService.instance.getLiveRingMembers(true);
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        Tracing.trace("Enqueuing truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        MessageOut<Truncation> message = truncation.createMessage();
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(message, endpoint, responseHandler);
        }
        try {
            responseHandler.get();
        }
        catch (TimeoutException e) {
            Tracing.trace("Timed out");
            throw e;
        }
    }

    private static boolean isAnyStorageHostDown() {
        return !Gossiper.instance.getUnreachableTokenOwners().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return StorageMetrics.totalHints.count();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return (int)StorageMetrics.totalHintsInProgress.count();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout();
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public void setReadRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setReadRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout();
    }

    @Override
    public void setWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.getCounterWriteRpcTimeout();
    }

    @Override
    public void setCounterWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCounterWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCasContentionTimeout() {
        return DatabaseDescriptor.getCasContentionTimeout();
    }

    @Override
    public void setCasContentionTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCasContentionTimeout(timeoutInMillis);
    }

    @Override
    public Long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }

    @Override
    public void setRangeRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRangeRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout();
    }

    @Override
    public void setTruncateRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setTruncateRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
    }

    @Override
    public void setNativeTransportMaxConcurrentConnections(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnections(nativeTransportMaxConcurrentConnections);
    }

    public Long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
    }

    public void setNativeTransportMaxConcurrentConnectionsPerIp(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnectionsPerIp(nativeTransportMaxConcurrentConnections);
    }

    @Override
    public void reloadTriggerClasses() {
        TriggerExecutor.instance.reloadClasses();
    }

    @Override
    public long getReadRepairAttempted() {
        return ReadRepairMetrics.attempted.count();
    }

    @Override
    public long getReadRepairRepairedBlocking() {
        return ReadRepairMetrics.repairedBlocking.count();
    }

    @Override
    public long getReadRepairRepairedBackground() {
        return ReadRepairMetrics.repairedBackground.count();
    }

    static {
        instance = new StorageProxy();
        maxHintsInProgress = 128 * FBUtilities.getAvailableProcessors();
        hintsInProgress = new CacheLoader<InetAddress, AtomicInteger>(){

            public AtomicInteger load(InetAddress inetAddress) {
                return new AtomicInteger(0);
            }
        };
        readMetrics = new ClientRequestMetrics("Read");
        rangeMetrics = new ClientRequestMetrics("RangeSlice");
        writeMetrics = new ClientRequestMetrics("Write");
        casWriteMetrics = new CASClientRequestMetrics("CASWrite");
        casReadMetrics = new CASClientRequestMetrics("CASRead");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws OverloadedException {
                assert (mutation instanceof Mutation);
                StorageProxy.sendToHintedEndpoints((Mutation)mutation, targets, responseHandler, localDataCenter);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistencyLevel) {
                StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter).run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistencyLevel) {
                StageManager.getStage(Stage.COUNTER_MUTATION).execute(StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter));
            }
        };
    }

    private static abstract class HintRunnable
    implements Runnable {
        public final InetAddress target;

        protected HintRunnable(InetAddress target) {
            this.target = target;
        }

        @Override
        public void run() {
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                StorageMetrics.totalHintsInProgress.dec();
                StorageProxy.getHintsInProgressFor(this.target).decrementAndGet();
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class LocalMutationRunnable
    implements Runnable {
        private final long constructionTime = System.currentTimeMillis();

        private LocalMutationRunnable() {
        }

        @Override
        public final void run() {
            MessagingService.Verb verb = this.verb();
            if (System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getTimeout(verb)) {
                if (MessagingService.DROPPABLE_VERBS.contains((Object)this.verb())) {
                    MessagingService.instance().incrementDroppedMessages(verb);
                }
                HintRunnable runnable = new HintRunnable(FBUtilities.getBroadcastAddress()){

                    @Override
                    protected void runMayThrow() throws Exception {
                        LocalMutationRunnable.this.runMayThrow();
                    }
                };
                StorageProxy.submitHint(runnable);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract MessagingService.Verb verb();

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.nanoTime();
        private final MessagingService.Verb verb;

        public DroppableRunnable(MessagingService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTime) > DatabaseDescriptor.getTimeout(this.verb)) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Iterable<InetAddress> var2, AbstractWriteResponseHandler var3, String var4, ConsistencyLevel var5) throws OverloadedException;
    }

    static class LocalRangeSliceRunnable
    extends DroppableRunnable {
        private final AbstractRangeCommand command;
        private final ReadCallback<RangeSliceReply, Iterable<Row>> handler;
        private final long start = System.nanoTime();

        LocalRangeSliceRunnable(AbstractRangeCommand command, ReadCallback<RangeSliceReply, Iterable<Row>> handler) {
            super(MessagingService.Verb.RANGE_SLICE);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            RangeSliceReply result = new RangeSliceReply(this.command.executeLocally());
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
            this.handler.response(result);
        }
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback<ReadResponse, Row> handler;
        private final long start = System.nanoTime();

        LocalReadRunnable(ReadCommand command, ReadCallback<ReadResponse, Row> handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            Keyspace keyspace = Keyspace.open(this.command.ksName);
            Row r = this.command.getRow(keyspace);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, r);
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
            this.handler.response(result);
        }
    }

    private static class WriteResponseHandlerWrapper {
        final AbstractWriteResponseHandler handler;
        final Mutation mutation;

        WriteResponseHandlerWrapper(AbstractWriteResponseHandler handler, Mutation mutation) {
            this.handler = handler;
            this.mutation = mutation;
        }
    }
}

