/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.config.ReadRepairDecision;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.TriggerDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.AtomDeserializer;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.compaction.WrappingCompactionStrategy;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.composites.SimpleCType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.LZ4Compressor;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.schema.LegacySchemaTables;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unmetered
public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.0;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.1;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final Class<? extends AbstractCompactionStrategy> DEFAULT_COMPACTION_STRATEGY_CLASS = SizeTieredCompactionStrategy.class;
    public static final CachingOptions DEFAULT_CACHING_STRATEGY = CachingOptions.KEYS_ONLY;
    public static final int DEFAULT_DEFAULT_TIME_TO_LIVE = 0;
    public static final SpeculativeRetry DEFAULT_SPECULATIVE_RETRY = new SpeculativeRetry(SpeculativeRetry.RetryType.PERCENTILE, 0.99);
    public static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
    public static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
    public static final String DEFAULT_COMPRESSOR = LZ4Compressor.class.getCanonicalName();
    private static final Comparator<ColumnDefinition> regularColumnComparator = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition def1, ColumnDefinition def2) {
            return ByteBufferUtil.compareUnsigned(def1.name.bytes, def2.name.bytes);
        }
    };
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public volatile CellNameType comparator;
    private volatile String comment = "";
    private volatile double readRepairChance = 0.0;
    private volatile double dcLocalReadRepairChance = 0.1;
    private volatile int gcGraceSeconds = 864000;
    private volatile AbstractType<?> defaultValidator = BytesType.instance;
    private volatile AbstractType<?> keyValidator = BytesType.instance;
    private volatile int minCompactionThreshold = 4;
    private volatile int maxCompactionThreshold = 32;
    private volatile Double bloomFilterFpChance = null;
    private volatile CachingOptions caching = DEFAULT_CACHING_STRATEGY;
    private volatile int minIndexInterval = 128;
    private volatile int maxIndexInterval = 2048;
    private volatile int memtableFlushPeriod = 0;
    private volatile int defaultTimeToLive = 0;
    private volatile SpeculativeRetry speculativeRetry = DEFAULT_SPECULATIVE_RETRY;
    private volatile Map<ColumnIdentifier, Long> droppedColumns = new HashMap<ColumnIdentifier, Long>();
    private volatile Map<String, TriggerDefinition> triggers = new HashMap<String, TriggerDefinition>();
    private volatile boolean isPurged = false;
    public static final String DEFAULT_KEY_ALIAS = "key";
    public static final String DEFAULT_COLUMN_ALIAS = "column";
    public static final String DEFAULT_VALUE_ALIAS = "value";
    private volatile Boolean isDense;
    private volatile Map<ByteBuffer, ColumnDefinition> columnMetadata = new HashMap<ByteBuffer, ColumnDefinition>();
    private volatile List<ColumnDefinition> partitionKeyColumns;
    private volatile List<ColumnDefinition> clusteringColumns;
    private volatile SortedSet<ColumnDefinition> regularColumns;
    private volatile SortedSet<ColumnDefinition> staticColumns;
    private volatile ColumnDefinition compactValueColumn;
    public volatile Class<? extends AbstractCompactionStrategy> compactionStrategyClass = DEFAULT_COMPACTION_STRATEGY_CLASS;
    public volatile Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public volatile CompressionParameters compressionParameters = new CompressionParameters(null);

    public CFMetaData comment(String prop) {
        this.comment = Strings.nullToEmpty((String)prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(CachingOptions prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData minIndexInterval(int prop) {
        this.minIndexInterval = prop;
        return this;
    }

    public CFMetaData maxIndexInterval(int prop) {
        this.maxIndexInterval = prop;
        return this;
    }

    public CFMetaData memtableFlushPeriod(int prop) {
        this.memtableFlushPeriod = prop;
        return this;
    }

    public CFMetaData defaultTimeToLive(int prop) {
        this.defaultTimeToLive = prop;
        return this;
    }

    public CFMetaData speculativeRetry(SpeculativeRetry prop) {
        this.speculativeRetry = prop;
        return this;
    }

    public CFMetaData droppedColumns(Map<ColumnIdentifier, Long> cols) {
        this.droppedColumns = cols;
        return this;
    }

    public CFMetaData triggers(Map<String, TriggerDefinition> prop) {
        this.triggers = prop;
        return this;
    }

    public CFMetaData isDense(Boolean prop) {
        this.isDense = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, CellNameType comp) {
        this(keyspace, name, type, comp, UUIDGen.getTimeUUID());
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, CellNameType comp, UUID id) {
        this.cfId = id;
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
    }

    public static CFMetaData denseCFMetaData(String keyspace, String name, AbstractType<?> comp, AbstractType<?> subcc) {
        CellNameType cellNameType = CellNames.fromAbstractType(CFMetaData.makeRawAbstractType(comp, subcc), true);
        return new CFMetaData(keyspace, name, subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, cellNameType);
    }

    public static CFMetaData sparseCFMetaData(String keyspace, String name, AbstractType<?> comp) {
        CellNameType cellNameType = CellNames.fromAbstractType(comp, false);
        return new CFMetaData(keyspace, name, ColumnFamilyType.Standard, cellNameType);
    }

    public static CFMetaData denseCFMetaData(String keyspace, String name, AbstractType<?> comp) {
        return CFMetaData.denseCFMetaData(keyspace, name, comp, null);
    }

    public static AbstractType<?> makeRawAbstractType(AbstractType<?> comparator, AbstractType<?> subComparator) {
        return subComparator == null ? comparator : CompositeType.getInstance(Arrays.asList(comparator, subComparator));
    }

    public Map<String, TriggerDefinition> getTriggers() {
        return this.triggers;
    }

    public static CFMetaData compile(String cql, String keyspace) {
        CFStatement parsed = (CFStatement)QueryProcessor.parseStatement(cql);
        parsed.prepareKeyspace(keyspace);
        CreateTableStatement statement = (CreateTableStatement)parsed.prepare().statement;
        CFMetaData cfm = CFMetaData.newSystemMetadata(keyspace, statement.columnFamily(), "", statement.comparator);
        statement.applyPropertiesTo(cfm);
        return cfm.rebuild();
    }

    public static UUID generateLegacyCfId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    private static CFMetaData newSystemMetadata(String keyspace, String cfName, String comment, CellNameType comparator) {
        return new CFMetaData(keyspace, cfName, ColumnFamilyType.Standard, comparator, CFMetaData.generateLegacyCfId(keyspace, cfName)).comment(comment).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).memtableFlushPeriod(3600000);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, CellNameType indexComparator) {
        CachingOptions indexCaching = parent.getCaching().keyCache.isEnabled() ? CachingOptions.KEYS_ONLY : CachingOptions.NONE;
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, indexComparator, parent.cfId).keyValidator(info.type).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).caching(indexCaching).speculativeRetry(parent.speculativeRetry).compactionStrategyClass(parent.compactionStrategyClass).compactionStrategyOptions(parent.compactionStrategyOptions).reloadSecondaryIndexMetadata(parent).rebuild();
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public CFMetaData copy() {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, this.cfId), this);
    }

    public CFMetaData copy(UUID newCfId) {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, newCfId), this);
    }

    @VisibleForTesting
    public static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        ArrayList<ColumnDefinition> clonedColumns = new ArrayList<ColumnDefinition>(oldCFMD.allColumns().size());
        for (ColumnDefinition cd : oldCFMD.allColumns()) {
            clonedColumns.add(cd.copy());
        }
        return newCFMD.addAllColumnDefinitions(clonedColumns).comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).keyValidator(oldCFMD.keyValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(new HashMap<String, String>(oldCFMD.compactionStrategyOptions)).compressionParameters(oldCFMD.compressionParameters.copy()).bloomFilterFpChance(oldCFMD.getBloomFilterFpChance()).caching(oldCFMD.caching).defaultTimeToLive(oldCFMD.defaultTimeToLive).minIndexInterval(oldCFMD.minIndexInterval).maxIndexInterval(oldCFMD.maxIndexInterval).speculativeRetry(oldCFMD.speculativeRetry).memtableFlushPeriod(oldCFMD.memtableFlushPeriod).droppedColumns(new HashMap<ColumnIdentifier, Long>(oldCFMD.droppedColumns)).triggers(new HashMap<String, TriggerDefinition>(oldCFMD.triggers)).isDense(oldCFMD.isDense).rebuild();
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name.bytes) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isSuper() {
        return this.cfType == ColumnFamilyType.Super;
    }

    public boolean isSecondaryIndex() {
        return this.cfName.contains(".");
    }

    public Map<ByteBuffer, ColumnDefinition> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getParentColumnFamilyName() {
        return this.isSecondaryIndex() ? this.cfName.substring(0, this.cfName.indexOf(46)) : null;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepairChance() {
        return this.dcLocalReadRepairChance;
    }

    public ReadRepairDecision newReadRepairDecision() {
        double chance = ThreadLocalRandom.current().nextDouble();
        if (this.getReadRepairChance() > chance) {
            return ReadRepairDecision.GLOBAL;
        }
        if (this.getDcLocalReadRepairChance() > chance) {
            return ReadRepairDecision.DC_LOCAL;
        }
        return ReadRepairDecision.NONE;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Collection<ColumnDefinition> allColumns() {
        return this.columnMetadata.values();
    }

    public Iterator<ColumnDefinition> allColumnsInSelectOrder() {
        return new AbstractIterator<ColumnDefinition>(){
            private final Iterator<ColumnDefinition> partitionKeyIter;
            private final Iterator<ColumnDefinition> clusteringIter;
            private boolean valueDone;
            private final Iterator<ColumnDefinition> staticIter;
            private final Iterator<ColumnDefinition> regularIter;
            {
                this.partitionKeyIter = CFMetaData.this.partitionKeyColumns.iterator();
                this.clusteringIter = CFMetaData.this.clusteringColumns.iterator();
                this.staticIter = CFMetaData.this.staticColumns.iterator();
                this.regularIter = CFMetaData.this.regularColumns.iterator();
            }

            protected ColumnDefinition computeNext() {
                if (this.partitionKeyIter.hasNext()) {
                    return this.partitionKeyIter.next();
                }
                if (this.clusteringIter.hasNext()) {
                    return this.clusteringIter.next();
                }
                if (this.staticIter.hasNext()) {
                    return this.staticIter.next();
                }
                if (CFMetaData.this.compactValueColumn != null && !this.valueDone) {
                    this.valueDone = true;
                    if (((CFMetaData)CFMetaData.this).compactValueColumn.name.bytes.hasRemaining()) {
                        return CFMetaData.this.compactValueColumn;
                    }
                }
                if (this.regularIter.hasNext()) {
                    return this.regularIter.next();
                }
                return (ColumnDefinition)this.endOfData();
            }
        };
    }

    public List<ColumnDefinition> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnDefinition> clusteringColumns() {
        return this.clusteringColumns;
    }

    public Set<ColumnDefinition> regularColumns() {
        return this.regularColumns;
    }

    public Set<ColumnDefinition> staticColumns() {
        return this.staticColumns;
    }

    public Iterable<ColumnDefinition> regularAndStaticColumns() {
        return Iterables.concat(this.staticColumns, this.regularColumns);
    }

    public ColumnDefinition compactValueColumn() {
        return this.compactValueColumn;
    }

    public CType getKeyValidatorAsCType() {
        return this.keyValidator instanceof CompositeType ? new CompoundCType(((CompositeType)this.keyValidator).types) : new SimpleCType(this.keyValidator);
    }

    public double getBloomFilterFpChance() {
        return this.bloomFilterFpChance == null || this.bloomFilterFpChance == 0.0 ? (this.compactionStrategyClass == LeveledCompactionStrategy.class ? 0.1 : 0.01) : this.bloomFilterFpChance;
    }

    public CachingOptions getCaching() {
        return this.caching;
    }

    public int getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public int getMaxIndexInterval() {
        return this.maxIndexInterval;
    }

    public SpeculativeRetry getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public int getMemtableFlushPeriod() {
        return this.memtableFlushPeriod;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public Map<ColumnIdentifier, Long> getDroppedColumns() {
        return this.droppedColumns;
    }

    public Boolean getIsDense() {
        return this.isDense;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CFMetaData)) {
            return false;
        }
        CFMetaData other = (CFMetaData)o;
        return Objects.equal((Object)this.cfId, (Object)other.cfId) && Objects.equal((Object)this.ksName, (Object)other.ksName) && Objects.equal((Object)this.cfName, (Object)other.cfName) && Objects.equal((Object)((Object)this.cfType), (Object)((Object)other.cfType)) && Objects.equal((Object)this.comparator, (Object)other.comparator) && Objects.equal((Object)this.comment, (Object)other.comment) && Objects.equal((Object)this.readRepairChance, (Object)other.readRepairChance) && Objects.equal((Object)this.dcLocalReadRepairChance, (Object)other.dcLocalReadRepairChance) && Objects.equal((Object)this.gcGraceSeconds, (Object)other.gcGraceSeconds) && Objects.equal(this.defaultValidator, other.defaultValidator) && Objects.equal(this.keyValidator, other.keyValidator) && Objects.equal((Object)this.minCompactionThreshold, (Object)other.minCompactionThreshold) && Objects.equal((Object)this.maxCompactionThreshold, (Object)other.maxCompactionThreshold) && Objects.equal(this.columnMetadata, other.columnMetadata) && Objects.equal(this.compactionStrategyClass, other.compactionStrategyClass) && Objects.equal(this.compactionStrategyOptions, other.compactionStrategyOptions) && Objects.equal((Object)this.compressionParameters, (Object)other.compressionParameters) && Objects.equal((Object)this.getBloomFilterFpChance(), (Object)other.getBloomFilterFpChance()) && Objects.equal((Object)this.memtableFlushPeriod, (Object)other.memtableFlushPeriod) && Objects.equal((Object)this.caching, (Object)other.caching) && Objects.equal((Object)this.defaultTimeToLive, (Object)other.defaultTimeToLive) && Objects.equal((Object)this.minIndexInterval, (Object)other.minIndexInterval) && Objects.equal((Object)this.maxIndexInterval, (Object)other.maxIndexInterval) && Objects.equal((Object)this.speculativeRetry, (Object)other.speculativeRetry) && Objects.equal(this.droppedColumns, other.droppedColumns) && Objects.equal(this.triggers, other.triggers) && Objects.equal((Object)this.isDense, (Object)other.isDense);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.cfId).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append((Object)this.comparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append(this.columnMetadata).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append(this.getBloomFilterFpChance()).append(this.memtableFlushPeriod).append((Object)this.caching).append(this.defaultTimeToLive).append(this.minIndexInterval).append(this.maxIndexInterval).append((Object)this.speculativeRetry).append(this.droppedColumns).append(this.triggers).append((Object)this.isDense).toHashCode();
    }

    public AbstractType<?> getValueValidator(CellName cellName) {
        ColumnDefinition def = this.getColumnDefinition(cellName);
        return def == null ? this.defaultValidator : def.type;
    }

    public boolean reload() {
        return this.apply(LegacySchemaTables.createTableFromName(this.ksName, this.cfName));
    }

    @VisibleForTesting
    public boolean apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        this.validateCompatility(cfm);
        this.comparator = cfm.comparator;
        this.comment = Strings.nullToEmpty((String)cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.defaultValidator = cfm.defaultValidator;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        this.bloomFilterFpChance = cfm.getBloomFilterFpChance();
        this.caching = cfm.caching;
        this.minIndexInterval = cfm.minIndexInterval;
        this.maxIndexInterval = cfm.maxIndexInterval;
        this.memtableFlushPeriod = cfm.memtableFlushPeriod;
        this.defaultTimeToLive = cfm.defaultTimeToLive;
        this.speculativeRetry = cfm.speculativeRetry;
        if (!cfm.droppedColumns.isEmpty()) {
            this.droppedColumns = cfm.droppedColumns;
        }
        MapDifference columnDiff = Maps.difference(this.columnMetadata, cfm.columnMetadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            this.removeColumnDefinition(cd);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            this.addColumnDefinition(cd);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition oldDef = this.columnMetadata.get(name);
            ColumnDefinition def = cfm.columnMetadata.get(name);
            this.addOrReplaceColumnDefinition(oldDef.apply(def));
        }
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters;
        this.triggers = cfm.triggers;
        this.isDense(cfm.isDense);
        this.rebuild();
        logger.debug("application result is {}", (Object)this);
        return !columnDiff.entriesOnlyOnLeft().isEmpty() || !columnDiff.entriesOnlyOnRight().isEmpty() || !columnDiff.entriesDiffering().isEmpty();
    }

    public void validateCompatility(CFMetaData cfm) throws ConfigurationException {
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (cfm.cfType != this.cfType) {
            throw new ConfigurationException(String.format("Column family types do not match (found %s; expected %s).", new Object[]{cfm.cfType, this.cfType}));
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException(String.format("Column family comparators do not match or are not compatible (found %s; expected %s).", cfm.comparator.getClass().getSimpleName(), this.comparator.getClass().getSimpleName()));
        }
    }

    public static void validateCompactionOptions(Class<? extends AbstractCompactionStrategy> strategyClass, Map<String, String> options) throws ConfigurationException {
        try {
            if (options == null) {
                return;
            }
            Map unknownOptions = (Map)strategyClass.getMethod("validateOptions", Map.class).invoke(null, options);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), strategyClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Compaction Strategy {} does not have a static validateOptions method. Validation ignored", (Object)strategyClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate compaction options: " + options);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate compaction options: " + options);
        }
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className;
        Class strategyClass = FBUtilities.classForName(className, "compaction strategy");
        if (className.equals(WrappingCompactionStrategy.class.getName())) {
            throw new ConfigurationException("You can't set WrappingCompactionStrategy as the compaction strategy!");
        }
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified compaction strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public static AbstractCompactionStrategy createCompactionStrategyInstance(Class<? extends AbstractCompactionStrategy> compactionStrategyClass, ColumnFamilyStore cfs, Map<String, String> compactionStrategyOptions) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, compactionStrategyOptions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        return CFMetaData.createCompactionStrategyInstance(this.compactionStrategyClass, cfs, this.compactionStrategyOptions);
    }

    public ColumnDefinition getColumnDefinition(ColumnIdentifier name) {
        return this.columnMetadata.get(name.bytes);
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.columnMetadata.get(name);
    }

    public ColumnDefinition getColumnDefinition(CellName cellName) {
        ColumnIdentifier id = cellName.cql3ColumnName(this);
        ColumnDefinition def = id == null ? this.getColumnDefinition(cellName.toByteBuffer()) : this.getColumnDefinition(id);
        return def != null && def.isPartOfCellName() ? def : null;
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.allColumns()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public void addDefaultIndexNames() throws ConfigurationException {
        UUID cfId = Schema.instance.getId(this.ksName, this.cfName);
        if (cfId != null) {
            CFMetaData cfm = Schema.instance.getCFMetaData(cfId);
            for (ColumnDefinition newDef : this.allColumns()) {
                String oldIndexName;
                if (!cfm.columnMetadata.containsKey(newDef.name.bytes) || newDef.getIndexType() == null || (oldIndexName = cfm.getColumnDefinition(newDef.name).getIndexName()) == null) continue;
                if (newDef.getIndexName() != null && !oldIndexName.equals(newDef.getIndexName())) {
                    throw new ConfigurationException("Can't modify index name: was '" + oldIndexName + "' changed to '" + newDef.getIndexName() + "'.");
                }
                newDef.setIndexName(oldIndexName);
            }
        }
        Set<String> existingNames = CFMetaData.existingIndexNames(null);
        for (ColumnDefinition column : this.allColumns()) {
            String baseName;
            if (column.getIndexType() == null || column.getIndexName() != null) continue;
            String indexName = baseName = CFMetaData.getDefaultIndexName(this.cfName, column.name);
            int i = 0;
            while (existingNames.contains(indexName)) {
                indexName = baseName + '_' + ++i;
            }
            column.setIndexName(indexName);
        }
    }

    public static String getDefaultIndexName(String cfName, ColumnIdentifier columnName) {
        return (cfName + "_" + columnName + "_idx").replaceAll("\\W", "");
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(FileDataInput in, Version version) {
        return this.getOnDiskIterator(in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(FileDataInput in, ColumnSerializer.Flag flag, int expireBefore, Version version) {
        return version.getSSTableFormat().getOnDiskIterator(in, flag, expireBefore, this, version);
    }

    public AtomDeserializer getOnDiskDeserializer(DataInput in, Version version) {
        return new AtomDeserializer(this.comparator, in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public static boolean isIndexNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        this.rebuild();
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("ColumnFamily name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.cfName));
        }
        if (this.cfType == null) {
            throw new ConfigurationException(String.format("Invalid column family type for %s", this.cfName));
        }
        for (int i = 0; i < this.comparator.size(); ++i) {
            if (!(this.comparator.subtype(i) instanceof CounterColumnType)) continue;
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.regularAndStaticColumns()) {
                if (def.type instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + def.name + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.allColumns()) {
                if (!(def.type instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + def.name + ") in a non counter column family");
            }
        }
        Set<String> indexNames = CFMetaData.existingIndexNames(this.cfName);
        for (ColumnDefinition c : this.allColumns()) {
            if (c.getIndexType() == null) {
                if (c.getIndexName() == null) continue;
                throw new ConfigurationException("Index name cannot be set without index type");
            }
            if (this.cfType == ColumnFamilyType.Super) {
                throw new ConfigurationException("Secondary indexes are not supported on super column families");
            }
            if (!CFMetaData.isIndexNameValid(c.getIndexName())) {
                throw new ConfigurationException("Illegal index name " + c.getIndexName());
            }
            if (indexNames.contains(c.getIndexName())) {
                throw new ConfigurationException("Duplicate index name " + c.getIndexName());
            }
            indexNames.add(c.getIndexName());
            if (!(c.getIndexType() != IndexType.CUSTOM || c.getIndexOptions() != null && c.hasIndexOption("class_name"))) {
                throw new ConfigurationException("Required index option missing: class_name");
            }
            SecondaryIndex.createInstance(null, c);
        }
        this.validateCompactionThresholds();
        if (this.bloomFilterFpChance != null && this.bloomFilterFpChance == 0.0) {
            throw new ConfigurationException("Zero false positives is impossible; bloom filter false positive chance bffpc must be 0 < bffpc <= 1");
        }
        this.validateIndexIntervalThresholds();
        return this;
    }

    private static Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfToExclude != null && cfs.name.equals(cfToExclude)) continue;
            for (ColumnDefinition cd : cfs.metadata.allColumns()) {
                indexNames.add(cd.getIndexName());
            }
        }
        return indexNames;
    }

    private void validateCompactionThresholds() throws ConfigurationException {
        if (this.maxCompactionThreshold == 0) {
            logger.warn("Disabling compaction by setting max or min compaction has been deprecated, set the compaction strategy option 'enabled' to 'false' instead");
            return;
        }
        if (this.minCompactionThreshold <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d).", this.minCompactionThreshold));
        }
        if (this.minCompactionThreshold > this.maxCompactionThreshold) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold, this.maxCompactionThreshold));
        }
    }

    private void validateIndexIntervalThresholds() throws ConfigurationException {
        if (this.minIndexInterval <= 0) {
            throw new ConfigurationException(String.format("Min index interval must be greater than 0 (got %d).", this.minIndexInterval));
        }
        if (this.maxIndexInterval < this.minIndexInterval) {
            throw new ConfigurationException(String.format("Max index interval (%d) must be greater than the min index interval (%d).", this.maxIndexInterval, this.minIndexInterval));
        }
    }

    public boolean isPurged() {
        return this.isPurged;
    }

    void markPurged() {
        this.isPurged = true;
    }

    public AbstractType<?> getColumnDefinitionComparator(ColumnDefinition def) {
        return this.getComponentComparator(def.isOnAllComponents() ? null : Integer.valueOf(def.position()), def.kind);
    }

    public AbstractType<?> getComponentComparator(Integer componentIndex, ColumnDefinition.Kind kind) {
        switch (kind) {
            case REGULAR: {
                if (componentIndex == null) {
                    return this.comparator.asAbstractType();
                }
                AbstractType<?> t = this.comparator.subtype(componentIndex);
                assert (t != null) : "Non-sensical component index";
                return t;
            }
        }
        return UTF8Type.instance;
    }

    public CFMetaData addAllColumnDefinitions(Collection<ColumnDefinition> defs) {
        for (ColumnDefinition def : defs) {
            this.addOrReplaceColumnDefinition(def);
        }
        return this;
    }

    public CFMetaData addColumnDefinition(ColumnDefinition def) throws ConfigurationException {
        if (this.columnMetadata.containsKey(def.name.bytes)) {
            throw new ConfigurationException(String.format("Cannot add column %s, a column with the same name already exists", def.name));
        }
        return this.addOrReplaceColumnDefinition(def);
    }

    public CFMetaData addOrReplaceColumnDefinition(ColumnDefinition def) {
        if (def.kind == ColumnDefinition.Kind.REGULAR) {
            this.comparator.addCQL3Column(def.name);
        }
        this.columnMetadata.put(def.name.bytes, def);
        return this;
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        if (def.kind == ColumnDefinition.Kind.REGULAR) {
            this.comparator.removeCQL3Column(def.name);
        }
        return this.columnMetadata.remove(def.name.bytes) != null;
    }

    public void addTriggerDefinition(TriggerDefinition def) throws InvalidRequestException {
        if (this.containsTriggerDefinition(def)) {
            throw new InvalidRequestException(String.format("Cannot create trigger %s, a trigger with the same name already exists", def.name));
        }
        this.triggers.put(def.name, def);
    }

    public boolean containsTriggerDefinition(TriggerDefinition def) {
        return this.triggers.containsKey(def.name);
    }

    public boolean removeTrigger(String name) {
        return this.triggers.remove(name) != null;
    }

    public void recordColumnDrop(ColumnDefinition def) {
        assert (!def.isOnAllComponents());
        this.droppedColumns.put(def.name, FBUtilities.timestampMicros());
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) throws InvalidRequestException {
        ColumnDefinition def = this.getColumnDefinition(from);
        if (def == null) {
            throw new InvalidRequestException(String.format("Cannot rename unknown column %s in keyspace %s", from, this.cfName));
        }
        if (this.getColumnDefinition(to) != null) {
            throw new InvalidRequestException(String.format("Cannot rename column %s to %s in keyspace %s; another column of that name already exist", from, to, this.cfName));
        }
        if (def.isPartOfCellName()) {
            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", from));
        }
        if (def.isIndexed()) {
            throw new InvalidRequestException(String.format("Cannot rename column %s because it is secondary indexed", from));
        }
        ColumnDefinition newDef = def.withNewName(to);
        this.addOrReplaceColumnDefinition(newDef);
        this.removeColumnDefinition(def);
    }

    public CFMetaData rebuild() {
        if (this.isDense == null) {
            this.isDense(CFMetaData.calculateIsDense(this.comparator.asAbstractType(), this.allColumns()));
        }
        List<ColumnDefinition> pkCols = CFMetaData.nullInitializedList(this.keyValidator.componentsCount());
        List<ColumnDefinition> ckCols = CFMetaData.nullInitializedList(this.comparator.clusteringPrefixSize());
        TreeSet<ColumnDefinition> regCols = new TreeSet<ColumnDefinition>(regularColumnComparator);
        TreeSet<ColumnDefinition> statCols = new TreeSet<ColumnDefinition>(regularColumnComparator);
        ColumnDefinition compactCol = null;
        for (ColumnDefinition def : this.allColumns()) {
            switch (def.kind) {
                case PARTITION_KEY: {
                    assert (!def.isOnAllComponents() || !(this.keyValidator instanceof CompositeType));
                    pkCols.set(def.position(), def);
                    break;
                }
                case CLUSTERING_COLUMN: {
                    assert (!def.isOnAllComponents() || !this.comparator.isCompound());
                    ckCols.set(def.position(), def);
                    break;
                }
                case REGULAR: {
                    regCols.add(def);
                    break;
                }
                case STATIC: {
                    statCols.add(def);
                    break;
                }
                case COMPACT_VALUE: {
                    assert (compactCol == null) : "There shouldn't be more than one compact value defined: got " + compactCol + " and " + def;
                    compactCol = def;
                }
            }
        }
        this.partitionKeyColumns = this.addDefaultKeyAliases(pkCols);
        this.clusteringColumns = this.addDefaultColumnAliases(ckCols);
        this.regularColumns = regCols;
        this.staticColumns = statCols;
        this.compactValueColumn = this.addDefaultValueAlias(compactCol);
        return this;
    }

    private List<ColumnDefinition> addDefaultKeyAliases(List<ColumnDefinition> pkCols) {
        for (int i = 0; i < pkCols.size(); ++i) {
            if (pkCols.get(i) != null) continue;
            Integer idx = null;
            AbstractType<?> type = this.keyValidator;
            if (this.keyValidator instanceof CompositeType) {
                idx = i;
                type = ((CompositeType)this.keyValidator).types.get(i);
            }
            ByteBuffer name = ByteBufferUtil.bytes(i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.partitionKeyDef(this, name, type, idx);
            this.addOrReplaceColumnDefinition(newDef);
            pkCols.set(i, newDef);
        }
        return pkCols;
    }

    private List<ColumnDefinition> addDefaultColumnAliases(List<ColumnDefinition> ckCols) {
        for (int i = 0; i < ckCols.size(); ++i) {
            AbstractType<?> type;
            Integer idx;
            if (ckCols.get(i) != null) continue;
            if (this.comparator.isCompound()) {
                idx = i;
                type = this.comparator.subtype(i);
            } else {
                idx = null;
                type = this.comparator.asAbstractType();
            }
            ByteBuffer name = ByteBufferUtil.bytes(DEFAULT_COLUMN_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.clusteringKeyDef(this, name, type, idx);
            this.addOrReplaceColumnDefinition(newDef);
            ckCols.set(i, newDef);
        }
        return ckCols;
    }

    private ColumnDefinition addDefaultValueAlias(ColumnDefinition compactValueDef) {
        if (this.comparator.isDense()) {
            if (compactValueDef != null) {
                return compactValueDef;
            }
            ColumnDefinition newDef = ColumnDefinition.compactValueDef(this, ByteBufferUtil.bytes(DEFAULT_VALUE_ALIAS), this.defaultValidator);
            this.addOrReplaceColumnDefinition(newDef);
            return newDef;
        }
        assert (compactValueDef == null);
        return null;
    }

    public static boolean calculateIsDense(AbstractType<?> comparator, Collection<ColumnDefinition> defs) {
        boolean hasRegular = false;
        int maxClusteringIdx = -1;
        for (ColumnDefinition def : defs) {
            switch (def.kind) {
                case CLUSTERING_COLUMN: {
                    maxClusteringIdx = Math.max(maxClusteringIdx, def.position());
                    break;
                }
                case REGULAR: {
                    hasRegular = true;
                }
            }
        }
        return maxClusteringIdx >= 0 ? maxClusteringIdx == comparator.componentsCount() - 1 : !hasRegular && !CFMetaData.isCQL3OnlyPKComparator(comparator);
    }

    private static boolean isCQL3OnlyPKComparator(AbstractType<?> comparator) {
        if (!(comparator instanceof CompositeType)) {
            return false;
        }
        CompositeType ct = (CompositeType)comparator;
        return ct.types.size() == 1 && ct.types.get(0) instanceof UTF8Type;
    }

    public boolean isCQL3Table() {
        return !this.isSuper() && !this.comparator.isDense() && this.comparator.isCompound();
    }

    private static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public boolean isThriftCompatible() {
        if (this.isSuper()) {
            return true;
        }
        for (ColumnDefinition def : this.allColumns()) {
            if (def.kind != ColumnDefinition.Kind.REGULAR || def.isThriftCompatible()) continue;
            return false;
        }
        return !CFMetaData.isCQL3OnlyPKComparator(this.comparator.asAbstractType()) || this.isDense != false;
    }

    public boolean isCounter() {
        return this.defaultValidator.isCounter();
    }

    public boolean hasStaticColumns() {
        return !this.staticColumns.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", (Object)this.comparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dcLocalReadRepairChance", this.dcLocalReadRepairChance).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("columnMetadata", this.columnMetadata.values()).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionParameters", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", this.getBloomFilterFpChance()).append("memtableFlushPeriod", this.memtableFlushPeriod).append("caching", (Object)this.caching).append("defaultTimeToLive", this.defaultTimeToLive).append("minIndexInterval", this.minIndexInterval).append("maxIndexInterval", this.maxIndexInterval).append("speculativeRetry", (Object)this.speculativeRetry).append("droppedColumns", this.droppedColumns).append("triggers", this.triggers.values()).append("isDense", (Object)this.isDense).toString();
    }

    public static class SpeculativeRetry {
        public final RetryType type;
        public final double value;

        private SpeculativeRetry(RetryType type, double value) {
            this.type = type;
            this.value = value;
        }

        public static SpeculativeRetry fromString(String retry) throws ConfigurationException {
            String name = retry.toUpperCase();
            try {
                if (name.endsWith(RetryType.PERCENTILE.toString())) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 10));
                    if (value > 100.0 || value < 0.0) {
                        throw new ConfigurationException("PERCENTILE should be between 0 and 100, but was " + value);
                    }
                    return new SpeculativeRetry(RetryType.PERCENTILE, value / 100.0);
                }
                if (name.endsWith("MS")) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 2));
                    return new SpeculativeRetry(RetryType.CUSTOM, value);
                }
                return new SpeculativeRetry(RetryType.valueOf(name), 0.0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("invalid speculative_retry type: " + retry);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpeculativeRetry)) {
                return false;
            }
            SpeculativeRetry rhs = (SpeculativeRetry)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)rhs.type)) && Objects.equal((Object)this.value, (Object)rhs.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.value});
        }

        public String toString() {
            switch (this.type) {
                case PERCENTILE: {
                    return this.value * 100.0 + "PERCENTILE";
                }
                case CUSTOM: {
                    return this.value + "ms";
                }
            }
            return this.type.toString();
        }

        public static enum RetryType {
            NONE,
            CUSTOM,
            PERCENTILE,
            ALWAYS;

        }
    }
}

