/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellName;
import org.apache.cassandra.db.composites.CompoundSparseCellName;
import org.apache.cassandra.db.composites.CompoundSparseCellNameType;
import org.apache.cassandra.db.composites.SimpleDenseCellName;
import org.apache.cassandra.db.composites.SimpleSparseCellName;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.HeapAllocator;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.NativeAllocator;

public abstract class AbstractNativeCell
extends AbstractCell
implements CellName {
    static final int TIMESTAMP_OFFSET = 4;
    private static final int VALUE_OFFSET_OFFSET = 12;
    private static final int CELL_NAME_SIZE_OFFSET = 16;
    private static final int CELL_NAME_EXTRA_OFFSET = 18;
    private static final int CELL_NAME_OFFSETS_OFFSET = 19;
    private static final int CELL_NAME_SIZE_DELTA_MASK = 3;
    private static final int CELL_NAME_TYPE_SHIFT = 2;
    private static final int CELL_NAME_TYPE_MASK = 7;
    private final long peer;
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[256];
        }
    };
    private static final ByteBuffer[] EMPTY = new ByteBuffer[0];

    AbstractNativeCell() {
        this.peer = -1L;
    }

    public AbstractNativeCell(NativeAllocator allocator, OpOrder.Group writeOp, Cell copyOf) {
        int size = this.sizeOf(copyOf);
        this.peer = allocator.allocate(size, writeOp);
        MemoryUtil.setInt(this.peer, size);
        this.construct(copyOf);
    }

    protected int sizeOf(Cell cell) {
        int size = 19 + Math.max(0, cell.name().size() - 1) * 2 + cell.value().remaining();
        CellName name = cell.name();
        for (int i = 0; i < name.size(); ++i) {
            size += name.get(i).remaining();
        }
        return size;
    }

    protected void construct(Cell from) {
        int i;
        this.setLong(4L, from.timestamp());
        CellName name = from.name();
        int nameSize = name.size();
        int offset = 16;
        this.setShort(offset, (short)nameSize);
        assert (nameSize - name.clusteringSize() <= 2);
        byte cellNameExtraBits = (byte)(nameSize - name.clusteringSize() | NameType.typeOf((CellName)name).bits);
        this.setByte(offset += 2, cellNameExtraBits);
        ++offset;
        short cellNameDelta = 0;
        for (i = 1; i < nameSize; ++i) {
            cellNameDelta = (short)(cellNameDelta + name.get(i - 1).remaining());
            this.setShort(offset, cellNameDelta);
            offset += 2;
        }
        for (i = 0; i < nameSize; ++i) {
            ByteBuffer bb = name.get(i);
            this.setBytes(offset, bb);
            offset += bb.remaining();
        }
        this.setInt(12L, offset);
        this.setBytes(offset, from.value());
    }

    private int nameDeltaOffset(int i) {
        return 19 + (i - 1) * 2;
    }

    int valueStartOffset() {
        return this.getInt(12L);
    }

    private int valueEndOffset() {
        return (int)(this.internalSize() - (long)this.postfixSize());
    }

    protected int postfixSize() {
        return 0;
    }

    @Override
    public ByteBuffer value() {
        long offset = this.valueStartOffset();
        return this.getByteBuffer(offset, (int)(this.internalSize() - ((long)this.postfixSize() + offset))).order(ByteOrder.BIG_ENDIAN);
    }

    private int clusteringSizeDelta() {
        return this.getByte(18L) & 3;
    }

    @Override
    public boolean isStatic() {
        return this.nametype() == NameType.COMPOUND_SPARSE_STATIC;
    }

    NameType nametype() {
        return NameType.TYPES[this.getByte(18L) >> 2 & 7];
    }

    public long minTimestamp() {
        return this.timestamp();
    }

    public long maxTimestamp() {
        return this.timestamp();
    }

    @Override
    public int clusteringSize() {
        return this.size() - this.clusteringSizeDelta();
    }

    @Override
    public ColumnIdentifier cql3ColumnName(CFMetaData metadata) {
        switch (this.nametype()) {
            case SIMPLE_SPARSE: {
                return AbstractNativeCell.getIdentifier(metadata, this.get(this.clusteringSize()));
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: {
                ByteBuffer buffer = this.get(this.clusteringSize());
                if (buffer.remaining() == 0) {
                    return CompoundSparseCellNameType.rowMarkerId;
                }
                return AbstractNativeCell.getIdentifier(metadata, buffer);
            }
            case SIMPLE_DENSE: 
            case COMPOUND_DENSE: {
                return null;
            }
        }
        throw new AssertionError();
    }

    @Override
    public ByteBuffer collectionElement() {
        return this.isCollectionCell() ? this.get(this.size() - 1) : null;
    }

    @Override
    public boolean isCollectionCell() {
        return this.clusteringSizeDelta() == 2;
    }

    @Override
    public boolean isSameCQL3RowAs(CellNameType type, CellName other) {
        switch (this.nametype()) {
            case SIMPLE_DENSE: 
            case COMPOUND_DENSE: {
                return type.compare(this, other) == 0;
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: {
                int clusteringSize = this.clusteringSize();
                if (clusteringSize != other.clusteringSize() || other.isStatic() != this.isStatic()) {
                    return false;
                }
                for (int i = 0; i < clusteringSize; ++i) {
                    if (type.subtype(i).compare(this.get(i), other.get(i)) == 0) continue;
                    return false;
                }
                return true;
            }
            case SIMPLE_SPARSE: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public int size() {
        return this.getShort(16L);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteBuffer get(int i) {
        return this.get(i, null);
    }

    private ByteBuffer get(int i, AbstractAllocator copy) {
        int size = this.size();
        assert (i >= 0 && i < this.size());
        int cellNamesOffset = this.nameDeltaOffset(size);
        int startDelta = i == 0 ? 0 : this.getShort(this.nameDeltaOffset(i));
        int endDelta = i < size - 1 ? this.getShort(this.nameDeltaOffset(i + 1)) : this.valueStartOffset() - cellNamesOffset;
        int length = endDelta - startDelta;
        if (copy == null) {
            return this.getByteBuffer(cellNamesOffset + startDelta, length).order(ByteOrder.BIG_ENDIAN);
        }
        ByteBuffer result = copy.allocate(length);
        FastByteOperations.UnsafeOperations.copy(null, this.peer + (long)cellNamesOffset + (long)startDelta, result, 0, length);
        return result;
    }

    protected void writeComponentTo(MessageDigest digest, int i, boolean includeSize) {
        int size = this.size();
        assert (i >= 0 && i < this.size());
        int cellNamesOffset = this.nameDeltaOffset(size);
        int startDelta = i == 0 ? 0 : this.getShort(this.nameDeltaOffset(i));
        int endDelta = i < size - 1 ? this.getShort(this.nameDeltaOffset(i + 1)) : this.valueStartOffset() - cellNamesOffset;
        int componentStart = cellNamesOffset + startDelta;
        int count = endDelta - startDelta;
        if (includeSize) {
            FBUtilities.updateWithShort(digest, count);
        }
        this.writeMemoryTo(digest, componentStart, count);
    }

    protected void writeMemoryTo(MessageDigest digest, int from, int count) {
        int i = 0;
        int batchEnd = count - 16;
        if (i < batchEnd) {
            byte[] buffer = BUFFER.get();
            while (i < batchEnd) {
                int transfer = Math.min(count - i, 256);
                this.getBytes(from + i, buffer, 0, transfer);
                digest.update(buffer, 0, transfer);
                i += transfer;
            }
        }
        while (i < count) {
            digest.update(this.getByte(from + i++));
        }
    }

    @Override
    public Composite.EOC eoc() {
        return Composite.EOC.NONE;
    }

    @Override
    public Composite withEOC(Composite.EOC eoc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Composite start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Composite end() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnSlice slice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrefixOf(CType type, Composite c) {
        if (this.size() > c.size() || this.isStatic() != c.isStatic()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (type.subtype(i).compare(this.get(i), c.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        switch (this.nametype()) {
            case SIMPLE_SPARSE: 
            case SIMPLE_DENSE: {
                return this.get(0);
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: 
            case COMPOUND_DENSE: {
                ByteBuffer result = ByteBuffer.allocate(this.cellDataSize());
                if (this.isStatic()) {
                    ByteBufferUtil.writeShortLength(result, 65535);
                }
                for (int i = 0; i < this.size(); ++i) {
                    ByteBuffer bb = this.get(i);
                    ByteBufferUtil.writeShortLength(result, bb.remaining());
                    result.put(bb);
                    result.put((byte)0);
                }
                result.flip();
                return result;
            }
        }
        throw new AssertionError();
    }

    protected void updateWithName(MessageDigest digest) {
        switch (this.nametype()) {
            case SIMPLE_SPARSE: 
            case SIMPLE_DENSE: {
                this.writeComponentTo(digest, 0, false);
                break;
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: 
            case COMPOUND_DENSE: {
                if (this.isStatic()) {
                    FBUtilities.updateWithShort(digest, 65535);
                }
                for (int i = 0; i < this.size(); ++i) {
                    this.writeComponentTo(digest, i, true);
                    digest.update((byte)0);
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void updateWithValue(MessageDigest digest) {
        int offset = this.valueStartOffset();
        int length = this.valueEndOffset() - offset;
        this.writeMemoryTo(digest, offset, length);
    }

    @Override
    public int dataSize() {
        switch (this.nametype()) {
            case SIMPLE_SPARSE: 
            case SIMPLE_DENSE: {
                return this.valueStartOffset() - this.nameDeltaOffset(this.size());
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: 
            case COMPOUND_DENSE: {
                int size = this.size();
                return this.valueStartOffset() - this.nameDeltaOffset(size) + 3 * size + (this.isStatic() ? 2 : 0);
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CellName) {
            return this.equals((CellName)obj);
        }
        if (obj instanceof Cell) {
            return this.equals((Cell)obj);
        }
        return false;
    }

    public boolean equals(CellName that) {
        int size = this.size();
        if (size != that.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.get(i).equals(that.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
        switch (this.nametype()) {
            case SIMPLE_DENSE: {
                return CellNames.simpleDense(this.get(0, allocator));
            }
            case COMPOUND_DENSE: {
                ByteBuffer[] r = new ByteBuffer[this.size()];
                for (int i = 0; i < r.length; ++i) {
                    r[i] = this.get(i, allocator);
                }
                return CellNames.compositeDense(r);
            }
            case COMPOUND_SPARSE_STATIC: 
            case COMPOUND_SPARSE: {
                int clusteringSize = this.clusteringSize();
                ByteBuffer[] r = clusteringSize == 0 ? EMPTY : new ByteBuffer[this.clusteringSize()];
                for (int i = 0; i < clusteringSize; ++i) {
                    r[i] = this.get(i, allocator);
                }
                ByteBuffer nameBuffer = this.get(r.length);
                ColumnIdentifier name = nameBuffer.remaining() == 0 ? CompoundSparseCellNameType.rowMarkerId : AbstractNativeCell.getIdentifier(cfm, nameBuffer);
                if (this.clusteringSizeDelta() == 2) {
                    ByteBuffer element = allocator.clone(this.get(this.size() - 1));
                    return CellNames.compositeSparseWithCollection(r, element, name, this.isStatic());
                }
                return CellNames.compositeSparse(r, name, this.isStatic());
            }
            case SIMPLE_SPARSE: {
                return CellNames.simpleSparse(AbstractNativeCell.getIdentifier(cfm, this.get(0)));
            }
        }
        throw new IllegalStateException();
    }

    private static ColumnIdentifier getIdentifier(CFMetaData cfMetaData, ByteBuffer name) {
        ColumnDefinition def = cfMetaData.getColumnDefinition(name);
        if (def != null) {
            return def.name;
        }
        AbstractType<?> type = cfMetaData.comparator.subtype(cfMetaData.comparator.clusteringPrefixSize());
        return new ColumnIdentifier(HeapAllocator.instance.clone(name), type);
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        throw new UnsupportedOperationException();
    }

    protected long internalSize() {
        return MemoryUtil.getInt(this.peer);
    }

    private void checkPosition(long offset, long size) {
        assert (size >= 0L);
        assert (this.peer > 0L) : "Memory was freed";
        assert (offset >= 0L && offset + size <= this.internalSize()) : String.format("Illegal range: [%d..%d), size: %s", offset, offset + size, this.internalSize());
    }

    protected final void setByte(long offset, byte b) {
        this.checkPosition(offset, 1L);
        MemoryUtil.setByte(this.peer + offset, b);
    }

    protected final void setShort(long offset, short s) {
        this.checkPosition(offset, 1L);
        MemoryUtil.setShort(this.peer + offset, s);
    }

    protected final void setInt(long offset, int l) {
        this.checkPosition(offset, 4L);
        MemoryUtil.setInt(this.peer + offset, l);
    }

    protected final void setLong(long offset, long l) {
        this.checkPosition(offset, 8L);
        MemoryUtil.setLong(this.peer + offset, l);
    }

    protected final void setBytes(long offset, ByteBuffer buffer) {
        int start = buffer.position();
        int count = buffer.limit() - start;
        if (count == 0) {
            return;
        }
        this.checkPosition(offset, count);
        MemoryUtil.setBytes(this.peer + offset, buffer);
    }

    protected final byte getByte(long offset) {
        this.checkPosition(offset, 1L);
        return MemoryUtil.getByte(this.peer + offset);
    }

    protected final void getBytes(long offset, byte[] trg, int trgOffset, int count) {
        this.checkPosition(offset, count);
        MemoryUtil.getBytes(this.peer + offset, trg, trgOffset, count);
    }

    protected final int getShort(long offset) {
        this.checkPosition(offset, 2L);
        return MemoryUtil.getShort(this.peer + offset);
    }

    protected final int getInt(long offset) {
        this.checkPosition(offset, 4L);
        return MemoryUtil.getInt(this.peer + offset);
    }

    protected final long getLong(long offset) {
        this.checkPosition(offset, 8L);
        return MemoryUtil.getLong(this.peer + offset);
    }

    protected final ByteBuffer getByteBuffer(long offset, int length) {
        this.checkPosition(offset, length);
        return MemoryUtil.getByteBuffer(this.peer + offset, length);
    }

    public final int compareTo(Composite that) {
        if (this.isStatic() != that.isStatic()) {
            if (this.isEmpty()) {
                return that.isEmpty() ? 0 : -1;
            }
            if (that.isEmpty()) {
                return 1;
            }
            return this.isStatic() ? -1 : 1;
        }
        int size = this.size();
        int size2 = that.size();
        int minSize = Math.min(size, size2);
        int startDelta = 0;
        int cellNamesOffset = this.nameDeltaOffset(size);
        for (int i = 0; i < minSize; ++i) {
            long offset = this.peer + (long)cellNamesOffset + (long)startDelta;
            int endDelta = i < size - 1 ? this.getShort(this.nameDeltaOffset(i + 1)) : this.valueStartOffset() - cellNamesOffset;
            int length = endDelta - startDelta;
            int cmp = FastByteOperations.UnsafeOperations.compareTo(null, offset, length, that.get(i));
            if (cmp != 0) {
                return cmp;
            }
            startDelta = endDelta;
        }
        Composite.EOC eoc = that.eoc();
        if (size == size2) {
            return this.eoc().compareTo(eoc);
        }
        return size < size2 ? this.eoc().prefixComparisonResult : -eoc.prefixComparisonResult;
    }

    public final int compareToSimple(Composite that) {
        assert (this.size() == 1 && that.size() == 1);
        int length = this.valueStartOffset() - this.nameDeltaOffset(1);
        long offset = this.peer + (long)this.nameDeltaOffset(1);
        return FastByteOperations.UnsafeOperations.compareTo(null, offset, length, that.get(0));
    }

    private static final class NameType
    extends Enum<NameType> {
        public static final /* enum */ NameType COMPOUND_DENSE = new NameType(0);
        public static final /* enum */ NameType COMPOUND_SPARSE = new NameType(4);
        public static final /* enum */ NameType COMPOUND_SPARSE_STATIC = new NameType(8);
        public static final /* enum */ NameType SIMPLE_DENSE = new NameType(12);
        public static final /* enum */ NameType SIMPLE_SPARSE = new NameType(16);
        static final NameType[] TYPES;
        final int bits;
        private static final /* synthetic */ NameType[] $VALUES;

        public static NameType[] values() {
            return (NameType[])$VALUES.clone();
        }

        public static NameType valueOf(String name) {
            return Enum.valueOf(NameType.class, name);
        }

        private NameType(int bits) {
            this.bits = bits;
        }

        static NameType typeOf(CellName name) {
            if (name instanceof CompoundDenseCellName) {
                assert (!name.isStatic());
                return COMPOUND_DENSE;
            }
            if (name instanceof CompoundSparseCellName) {
                return name.isStatic() ? COMPOUND_SPARSE_STATIC : COMPOUND_SPARSE;
            }
            if (name instanceof SimpleDenseCellName) {
                assert (!name.isStatic());
                return SIMPLE_DENSE;
            }
            if (name instanceof SimpleSparseCellName) {
                assert (!name.isStatic());
                return SIMPLE_SPARSE;
            }
            if (name instanceof NativeCell) {
                return ((NativeCell)name).nametype();
            }
            throw new AssertionError();
        }

        static {
            $VALUES = new NameType[]{COMPOUND_DENSE, COMPOUND_SPARSE, COMPOUND_SPARSE_STATIC, SIMPLE_DENSE, SIMPLE_SPARSE};
            TYPES = NameType.values();
        }
    }
}

