/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutationVerbHandler
implements IVerbHandler<CounterMutation> {
    private static final Logger logger = LoggerFactory.getLogger(CounterMutationVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<CounterMutation> message, final int id) {
        CounterMutation cm = (CounterMutation)message.payload;
        logger.debug("Applying forwarded {}", (Object)cm);
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        StorageProxy.applyCounterMutationOnLeader(cm, localDataCenter, new Runnable(){

            @Override
            public void run() {
                MessagingService.instance().sendReply(new WriteResponse().createMessage(), id, message.from);
            }
        });
    }
}

