/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.hadoop.ColumnFamilyRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Mutation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ColumnFamilyOutputFormat
extends OutputFormat<ByteBuffer, List<Mutation>>
implements org.apache.hadoop.mapred.OutputFormat<ByteBuffer, List<Mutation>> {
    public static final String BATCH_THRESHOLD = "mapreduce.output.columnfamilyoutputformat.batch.threshold";
    public static final String QUEUE_SIZE = "mapreduce.output.columnfamilyoutputformat.queue.size";
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyOutputFormat.class);

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public void checkOutputSpecs(JobContext context) {
        this.checkOutputSpecs(HadoopCompat.getConfiguration(context));
    }

    protected void checkOutputSpecs(Configuration conf) {
        if (ConfigHelper.getOutputKeyspace(conf) == null) {
            throw new UnsupportedOperationException("You must set the keyspace with setOutputKeyspace()");
        }
        if (ConfigHelper.getOutputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the output partitioner to the one used by your Cassandra cluster");
        }
        if (ConfigHelper.getOutputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node");
        }
    }

    @Deprecated
    public void checkOutputSpecs(FileSystem filesystem, JobConf job) throws IOException {
        this.checkOutputSpecs((Configuration)job);
    }

    public static Cassandra.Client createAuthenticatedClient(String host, int port, Configuration conf) throws Exception {
        logger.debug("Creating authenticated client for CF output format");
        TTransport transport = ConfigHelper.getClientTransportFactory(conf).openTransport(host, port);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport, true, true);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        client.set_keyspace(ConfigHelper.getOutputKeyspace(conf));
        String user = ConfigHelper.getOutputKeyspaceUserName(conf);
        String password = ConfigHelper.getOutputKeyspacePassword(conf);
        if (user != null && password != null) {
            ColumnFamilyOutputFormat.login(user, password, client);
        }
        logger.debug("Authenticated client for CF output format created successfully");
        return client;
    }

    public static void login(String user, String password, Cassandra.Client client) throws Exception {
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("username", user);
        creds.put("password", password);
        AuthenticationRequest authRequest = new AuthenticationRequest(creds);
        client.login(authRequest);
    }

    @Deprecated
    public ColumnFamilyRecordWriter getRecordWriter(FileSystem filesystem, JobConf job, String name, Progressable progress) {
        return new ColumnFamilyRecordWriter((Configuration)job, progress);
    }

    public ColumnFamilyRecordWriter getRecordWriter(TaskAttemptContext context) throws InterruptedException {
        return new ColumnFamilyRecordWriter(context);
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

