/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.util.concurrent.RateLimiter;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ICompressedFile;

public class CompressedThrottledReader
extends CompressedRandomAccessReader {
    private final RateLimiter limiter;

    public CompressedThrottledReader(ChannelProxy channel, CompressionMetadata metadata, ICompressedFile file, RateLimiter limiter) {
        super(channel, metadata, file, null);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.capacity());
        super.reBuffer();
    }

    public static CompressedThrottledReader open(ICompressedFile file, RateLimiter limiter) {
        return new CompressedThrottledReader(file.channel(), file.getMetadata(), file, limiter);
    }
}

