/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.FloatSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatType
extends AbstractType<Float> {
    public static final FloatType instance = new FloatType();

    FloatType() {
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((Float)this.compose(o1)).compareTo((Float)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            float f = Float.parseFloat(source);
            return ByteBufferUtil.bytes(f);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("Unable to make float from '%s'", source), e1);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(Float.valueOf(((Number)parsed).floatValue())));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a float value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        Float value = this.getSerializer().deserialize(buffer);
        if (value.isNaN() || value.isInfinite()) {
            return "null";
        }
        return value.toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.FLOAT;
    }

    @Override
    public TypeSerializer<Float> getSerializer() {
        return FloatSerializer.instance;
    }
}

