/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ResourceWatcher;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileSnitch.class);
    public static final String SNITCH_PROPERTIES_FILENAME = "cassandra-topology.properties";
    private static volatile Map<InetAddress, String[]> endpointMap;
    private static volatile String[] defaultDCRack;
    private volatile boolean gossipStarted;

    public PropertyFileSnitch() throws ConfigurationException {
        this.reloadConfiguration(false);
        try {
            FBUtilities.resourceToFile(SNITCH_PROPERTIES_FILENAME);
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws ConfigurationException {
                    PropertyFileSnitch.this.reloadConfiguration(true);
                }
            };
            ResourceWatcher.watch(SNITCH_PROPERTIES_FILENAME, runnable, 60000);
        }
        catch (ConfigurationException ex) {
            logger.error("{} found, but does not look like a plain file. Will not watch it for changes", (Object)SNITCH_PROPERTIES_FILENAME);
        }
    }

    public String[] getEndpointInfo(InetAddress endpoint) {
        String[] rawEndpointInfo = this.getRawEndpointInfo(endpoint);
        if (rawEndpointInfo == null) {
            throw new RuntimeException("Unknown host " + endpoint + " with no default configured");
        }
        return rawEndpointInfo;
    }

    private String[] getRawEndpointInfo(InetAddress endpoint) {
        String[] value = endpointMap.get(endpoint);
        if (value == null) {
            logger.trace("Could not find end point information for {}, will use default", (Object)endpoint);
            return defaultDCRack;
        }
        return value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        String[] info = this.getEndpointInfo(endpoint);
        assert (info != null) : "No location defined for endpoint " + endpoint;
        return info[0];
    }

    @Override
    public String getRack(InetAddress endpoint) {
        String[] info = this.getEndpointInfo(endpoint);
        assert (info != null) : "No location defined for endpoint " + endpoint;
        return info[1];
    }

    public void reloadConfiguration(boolean isUpdate) throws ConfigurationException {
        HashMap<InetAddress, String[]> reloadedMap = new HashMap<InetAddress, String[]>();
        Properties properties = new Properties();
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(SNITCH_PROPERTIES_FILENAME);
            Object object = null;
            try {
                properties.load(stream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to read cassandra-topology.properties", e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            InetAddress host;
            String string = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (string.equals("default")) {
                String[] newDefault = value.split(":");
                if (newDefault.length < 2) {
                    defaultDCRack = new String[]{"default", "default"};
                    continue;
                }
                defaultDCRack = new String[]{newDefault[0].trim(), newDefault[1].trim()};
                continue;
            }
            String hostString = string.replace("/", "");
            try {
                host = InetAddress.getByName(hostString);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host " + hostString, e);
            }
            String[] token = value.split(":");
            token = token.length < 2 ? new String[]{"default", "default"} : new String[]{token[0].trim(), token[1].trim()};
            reloadedMap.put(host, token);
        }
        if (defaultDCRack == null && !reloadedMap.containsKey(FBUtilities.getBroadcastAddress())) {
            throw new ConfigurationException(String.format("Snitch definitions at %s do not define a location for this node's broadcast address %s, nor does it provides a default", SNITCH_PROPERTIES_FILENAME, FBUtilities.getBroadcastAddress()));
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : reloadedMap.entrySet()) {
                sb.append(entry.getKey()).append(":").append(Arrays.toString((Object[])entry.getValue())).append(", ");
            }
            logger.trace("Loaded network topology from property file: {}", (Object)StringUtils.removeEnd((String)sb.toString(), (String)", "));
        }
        endpointMap = reloadedMap;
        if (StorageService.instance != null) {
            if (isUpdate) {
                StorageService.instance.updateTopology();
            } else {
                StorageService.instance.getTokenMetadata().invalidateCachedRings();
            }
        }
        if (this.gossipStarted) {
            StorageService.instance.gossipSnitchInfo();
        }
    }

    @Override
    public void gossiperStarting() {
        this.gossipStarted = true;
    }
}

