/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryPager
extends AbstractQueryPager
implements SinglePartitionPager {
    private static final Logger logger = LoggerFactory.getLogger(SliceQueryPager.class);
    private final SliceFromReadCommand command;
    private final ClientState cstate;
    private volatile CellName lastReturned;

    SliceQueryPager(SliceFromReadCommand command, ConsistencyLevel consistencyLevel, ClientState cstate, boolean localQuery) {
        super(consistencyLevel, command.filter.count, localQuery, command.ksName, command.cfName, command.filter, command.timestamp);
        this.command = command;
        this.cstate = cstate;
    }

    SliceQueryPager(SliceFromReadCommand command, ConsistencyLevel consistencyLevel, ClientState cstate, boolean localQuery, PagingState state) {
        this(command, consistencyLevel, cstate, localQuery);
        if (state != null) {
            if (state.cellName.hasRemaining()) {
                this.lastReturned = (CellName)this.cfm.comparator.fromByteBuffer(state.cellName);
            }
            this.restoreState(state.remaining, true);
        }
    }

    @Override
    public ByteBuffer key() {
        return this.command.key;
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, this.lastReturned.toByteBuffer(), this.maxRemaining());
    }

    @Override
    protected List<Row> queryNextPage(int pageSize, ConsistencyLevel consistencyLevel, boolean localQuery) throws RequestValidationException, RequestExecutionException {
        SliceQueryFilter filter = this.command.filter.withUpdatedCount(Math.min(this.command.filter.count, pageSize));
        if (this.lastReturned != null) {
            filter = filter.withUpdatedStart(this.lastReturned, this.cfm);
        }
        logger.debug("Querying next page of slice query; new filter: {}", (Object)filter);
        SliceFromReadCommand pageCmd = this.command.withUpdatedFilter(filter);
        return localQuery ? Collections.singletonList(((ReadCommand)pageCmd).getRow(Keyspace.open(this.command.ksName))) : StorageProxy.read(Collections.singletonList(pageCmd), consistencyLevel, this.cstate);
    }

    @Override
    protected boolean containsPreviousLast(Row first) {
        if (this.lastReturned == null) {
            return false;
        }
        Cell firstCell = this.isReversed() ? SliceQueryPager.lastCell(first.cf) : this.firstNonStaticCell(first.cf);
        CFMetaData metadata = Schema.instance.getCFMetaData(this.command.getKeyspace(), this.command.getColumnFamilyName());
        return !first.cf.deletionInfo().isDeleted(firstCell) && firstCell.isLive(this.timestamp()) && firstCell.name().isSameCQL3RowAs(metadata.comparator, this.lastReturned);
    }

    @Override
    protected boolean recordLast(Row last) {
        Cell lastCell = this.isReversed() ? this.firstNonStaticCell(last.cf) : SliceQueryPager.lastCell(last.cf);
        this.lastReturned = lastCell.name();
        return true;
    }

    @Override
    protected boolean isReversed() {
        return this.command.filter.reversed;
    }
}

