/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.clearspring.analytics.stream.Counter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Runnables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.CounterCacheKey;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.CollationController;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.WrappingCompactionStrategy;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamLockfile;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.BatchRemoveIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TopKSampler;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorService flushExecutor = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtableFlushWriter"), "internal");
    private static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor(1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtablePostFlush"), "internal");
    private static final ExecutorService reclaimExecutor = new JMXEnabledThreadPoolExecutor(1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtableReclaimMemory"), "internal");
    private static final String[] COUNTER_NAMES = new String[]{"raw", "count", "error", "string"};
    private static final String[] COUNTER_DESCS = new String[]{"partition key in raw hex bytes", "value of this partition for given sampler", "value is within the error bounds plus or minus of this", "the partition key turned into a human readable format"};
    private static final CompositeType COUNTER_COMPOSITE_TYPE;
    private static final TabularType COUNTER_TYPE;
    private static final String[] SAMPLER_NAMES;
    private static final String[] SAMPLER_DESCS;
    private static final String SAMPLING_RESULTS_NAME = "SAMPLING_RESULTS";
    private static final CompositeType SAMPLING_RESULT;
    public final Keyspace keyspace;
    public final String name;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private volatile boolean valid = true;
    private final Tracker data;
    public final OpOrder readOrdering = new OpOrder();
    private final AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private final WrappingCompactionStrategy compactionStrategyWrapper;
    public final Directories directories;
    public final ColumnFamilyMetrics metric;
    public volatile long sampleLatencyNanos;
    private final ScheduledFuture<?> latencyCalculator;
    public static final Function<View, List<SSTableReader>> CANONICAL_SSTABLES;
    public static final Function<View, List<SSTableReader>> UNREPAIRED_SSTABLES;

    public static void shutdownPostFlushExecutor() throws InterruptedException {
        postFlushExecutor.shutdown();
        postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
    }

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        this.compactionStrategyWrapper.maybeReloadCompactionStrategy(this.metadata);
        this.scheduleFlush();
        this.indexManager.reload();
        if (this.data.getView().getCurrentMemtable().initialComparator != this.metadata.comparator) {
            this.switchMemtable();
        }
    }

    void scheduleFlush() {
        int period = this.metadata.getMemtableFlushPeriod();
        if (period > 0) {
            logger.trace("scheduling flush in {} ms", (Object)period);
            WrappedRunnable runnable = new WrappedRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void runMayThrow() throws Exception {
                    Tracker tracker = ColumnFamilyStore.this.data;
                    synchronized (tracker) {
                        Memtable current = ColumnFamilyStore.this.data.getView().getCurrentMemtable();
                        if (current.isExpired()) {
                            if (current.isClean()) {
                                ColumnFamilyStore.this.scheduleFlush();
                            } else {
                                ColumnFamilyStore.this.forceFlush();
                            }
                        }
                    }
                }
            };
            ScheduledExecutors.scheduledTasks.schedule(runnable, (long)period, TimeUnit.MILLISECONDS);
        }
    }

    public static Runnable getBackgroundCompactionTaskSubmitter() {
        return new Runnable(){

            @Override
            public void run() {
                for (Keyspace keyspace : Keyspace.all()) {
                    for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                        CompactionManager.instance.submitBackground(cfs);
                    }
                }
            }
        };
    }

    @Override
    public void setCompactionParametersJson(String options) {
        this.setCompactionParameters(FBUtilities.fromJsonMap(options));
    }

    @Override
    public String getCompactionParametersJson() {
        return FBUtilities.json(this.getCompactionParameters());
    }

    @Override
    public void setCompactionParameters(Map<String, String> options) {
        try {
            HashMap<String, String> optionsCopy = new HashMap<String, String>(options);
            Class<? extends AbstractCompactionStrategy> compactionStrategyClass = CFMetaData.createCompactionStrategy((String)optionsCopy.get("class"));
            optionsCopy.remove("class");
            CFMetaData.validateCompactionOptions(compactionStrategyClass, optionsCopy);
            this.compactionStrategyWrapper.setNewLocalCompactionStrategy(compactionStrategyClass, optionsCopy);
        }
        catch (Throwable t) {
            logger.error("Could not set new local compaction strategy", t);
            throw new IllegalArgumentException("Could not set new local compaction strategy: " + t.getMessage());
        }
    }

    @Override
    public Map<String, String> getCompactionParameters() {
        HashMap<String, String> options = new HashMap<String, String>(this.compactionStrategyWrapper.options);
        options.put("class", this.compactionStrategyWrapper.getName());
        return options;
    }

    @Override
    public void setCompactionStrategyClass(String compactionStrategyClass) {
        try {
            this.metadata.compactionStrategyClass = CFMetaData.createCompactionStrategy(compactionStrategyClass);
            this.compactionStrategyWrapper.maybeReloadCompactionStrategy(this.metadata);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String getCompactionStrategyClass() {
        return this.metadata.compactionStrategyClass.getName();
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata.compressionParameters().asThriftOptions();
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) {
        try {
            this.metadata.compressionParameters = CompressionParameters.create(opts);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setCrcCheckChance(double crcCheckChance) {
        try {
            for (SSTableReader sstable : this.keyspace.getAllSSTables()) {
                if (!sstable.compression) continue;
                sstable.getCompressionMetadata().parameters.setCrcCheckChance(crcCheckChance);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ColumnFamilyStore(Keyspace keyspace, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata, Directories directories, boolean loadSSTables) {
        this(keyspace, columnFamilyName, partitioner, generation, metadata, directories, loadSSTables, true);
    }

    @VisibleForTesting
    public ColumnFamilyStore(Keyspace keyspace, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata, Directories directories, boolean loadSSTables, boolean registerBookkeeping) {
        assert (metadata != null) : "null metadata for " + keyspace + ":" + columnFamilyName;
        this.keyspace = keyspace;
        this.name = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.partitioner = partitioner;
        this.directories = directories;
        this.indexManager = new SecondaryIndexManager(this);
        this.metric = new ColumnFamilyMetrics(this);
        this.fileIndexGenerator.set(generation);
        this.sampleLatencyNanos = DatabaseDescriptor.getReadRpcTimeout() / 2L;
        logger.info("Initializing {}.{}", (Object)keyspace.getName(), (Object)this.name);
        this.data = new Tracker(this, loadSSTables);
        if (this.data.loadsstables) {
            Directories.SSTableLister sstableFiles = directories.sstableLister().skipTemporary(true);
            Collection<SSTableReader> sstables = SSTableReader.openAll(sstableFiles.list().entrySet(), metadata, this.partitioner);
            this.data.addInitialSSTables(sstables);
        }
        this.compactionStrategyWrapper = new WrappingCompactionStrategy(this);
        if (this.maxCompactionThreshold.value() <= 0 || this.minCompactionThreshold.value() <= 0) {
            logger.warn("Disabling compaction strategy by setting compaction thresholds to 0 is deprecated, set the compaction option 'enabled' to 'false' instead.");
            this.compactionStrategyWrapper.disable();
        }
        for (ColumnDefinition info : metadata.allColumns()) {
            if (info.getIndexType() == null) continue;
            this.indexManager.addIndexedColumn(info);
        }
        if (registerBookkeeping) {
            String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
            this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.keyspace.getName() + ",columnfamily=" + this.name;
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName nameObj = new ObjectName(this.mbeanName);
                mbs.registerMBean(this, nameObj);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("retryPolicy for {} is {}", (Object)this.name, (Object)this.metadata.getSpeculativeRetry());
            this.latencyCalculator = ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    CFMetaData.SpeculativeRetry retryPolicy = ColumnFamilyStore.this.metadata.getSpeculativeRetry();
                    switch (retryPolicy.type) {
                        case PERCENTILE: {
                            ColumnFamilyStore.this.sampleLatencyNanos = (long)(ColumnFamilyStore.this.metric.coordinatorReadLatency.getSnapshot().getValue(retryPolicy.value) * 1000.0);
                            break;
                        }
                        case CUSTOM: {
                            ColumnFamilyStore.this.sampleLatencyNanos = (long)(retryPolicy.value * 1000.0 * 1000.0);
                            break;
                        }
                        default: {
                            ColumnFamilyStore.this.sampleLatencyNanos = Long.MAX_VALUE;
                        }
                    }
                }
            }, DatabaseDescriptor.getReadRpcTimeout(), DatabaseDescriptor.getReadRpcTimeout(), TimeUnit.MILLISECONDS);
        } else {
            this.latencyCalculator = ScheduledExecutors.optionalTasks.schedule(Runnables.doNothing(), 0L, TimeUnit.NANOSECONDS);
            this.mbeanName = null;
        }
    }

    public void invalidate() {
        this.invalidate(true);
    }

    public void invalidate(boolean expectMBean) {
        block2: {
            this.valid = false;
            try {
                this.unregisterMBean();
            }
            catch (Exception e) {
                if (!expectMBean) break block2;
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Failed unregistering mbean: {}", (Object)this.mbeanName, (Object)e);
            }
        }
        this.latencyCalculator.cancel(false);
        SystemKeyspace.removeTruncationRecord(this.metadata.cfId);
        this.data.dropSSTables();
        this.indexManager.invalidate();
        this.invalidateCaches();
    }

    void maybeRemoveUnreadableSSTables(File directory) {
        this.data.removeUnreadableSSTables(directory);
    }

    void unregisterMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName nameObj;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(nameObj = new ObjectName(this.mbeanName))) {
            mbs.unregisterMBean(nameObj);
        }
        this.metric.release();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, boolean loadSSTables) {
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, columnFamily, StorageService.getPartitioner(), Schema.instance.getCFMetaData(keyspace.getName(), columnFamily), loadSSTables);
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, IPartitioner partitioner, CFMetaData metadata, boolean loadSSTables) {
        Directories directories = new Directories(metadata);
        Directories.SSTableLister lister = directories.sstableLister().includeBackups(true);
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            Descriptor desc = entry.getKey();
            generations.add(desc.generation);
            if (desc.isCompatible()) continue;
            throw new RuntimeException(String.format("Incompatible SSTable found. Current version %s is unable to read file: %s. Please run upgradesstables.", desc.getFormat().getLatestVersion(), desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(keyspace, columnFamily, partitioner, value, metadata, directories, loadSSTables);
    }

    public static void scrubDataDirectories(CFMetaData metadata) {
        Directories directories = new Directories(metadata);
        ColumnFamilyStore.clearEphemeralSnapshots(directories);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".lockfile");
            }
        };
        for (File file : directories.getCFDirectories()) {
            File[] lockfiles = file.listFiles(filter);
            if (lockfiles == null || lockfiles.length == 0) continue;
            logger.info("Removing SSTables from failed streaming session. Found {} files to cleanup.", (Object)lockfiles.length);
            for (File lockfile : lockfiles) {
                StreamLockfile streamLockfile = new StreamLockfile(lockfile);
                streamLockfile.cleanup();
                streamLockfile.delete();
            }
        }
        logger.trace("Removing compacted SSTable files from {} (see http://wiki.apache.org/cassandra/MemtableSSTable)", (Object)metadata.cfName);
        for (Map.Entry entry : directories.sstableLister().list().entrySet()) {
            Descriptor desc = (Descriptor)entry.getKey();
            Set components = (Set)entry.getValue();
            if (desc.type.isTemporary) {
                SSTable.delete(desc, components);
                continue;
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, (Object)components);
            for (Component component : components) {
                FileUtils.deleteWithConfirm(desc.filenameFor(component));
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(metadata.ksName + "-" + metadata.cfName + "-(Key|Row)Cache.*\\.tmp$");
        File file = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (file.exists()) {
            assert (file.isDirectory());
            for (File file2 : file.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file2.getName()).matches() || file2.delete()) continue;
                logger.warn("could not delete {}", (Object)file2.getAbsolutePath());
            }
        }
        for (ColumnDefinition def : metadata.allColumns()) {
            CellNameType indexComparator;
            if (!def.isIndexed() || (indexComparator = SecondaryIndex.getIndexComparator(metadata, def)) == null) continue;
            CFMetaData indexMetadata = CFMetaData.newIndexMetadata(metadata, def, indexComparator);
            ColumnFamilyStore.scrubDataDirectories(indexMetadata);
        }
    }

    public static void removeUnfinishedCompactionLeftovers(CFMetaData metadata, Map<Integer, UUID> unfinishedCompactions) {
        Descriptor desc;
        Directories directories = new Directories(metadata);
        HashSet<Integer> allGenerations = new HashSet<Integer>();
        for (Descriptor desc2 : directories.sstableLister().list().keySet()) {
            allGenerations.add(desc2.generation);
        }
        Set<Integer> unfinishedGenerations = unfinishedCompactions.keySet();
        if (!allGenerations.containsAll(unfinishedGenerations)) {
            HashSet<Integer> missingGenerations = new HashSet<Integer>(unfinishedGenerations);
            missingGenerations.removeAll(allGenerations);
            logger.trace("Unfinished compactions of {}.{} reference missing sstables of generations {}", new Object[]{metadata.ksName, metadata.cfName, missingGenerations});
        }
        HashSet<Integer> completedAncestors = new HashSet<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().skipTemporary(true).list().entrySet()) {
            Set<Integer> ancestors;
            if (!sstableFiles.getValue().contains(Component.DATA)) continue;
            desc = sstableFiles.getKey();
            try {
                CompactionMetadata compactionMetadata = (CompactionMetadata)desc.getMetadataSerializer().deserialize(desc, MetadataType.COMPACTION);
                ancestors = compactionMetadata.ancestors;
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, desc.filenameFor(Component.STATS));
            }
            catch (NullPointerException e) {
                throw new FSReadError((Throwable)e, "Failed to remove unfinished compaction leftovers (file: " + desc.filenameFor(Component.STATS) + ").  See log for details.");
            }
            if (!ancestors.isEmpty() && unfinishedGenerations.containsAll(ancestors) && allGenerations.containsAll(ancestors)) {
                UUID compactionTaskID = unfinishedCompactions.get(ancestors.iterator().next());
                assert (compactionTaskID != null);
                logger.trace("Going to delete unfinished compaction product {}", (Object)desc);
                SSTable.delete(desc, sstableFiles.getValue());
                SystemKeyspace.finishCompaction(compactionTaskID);
                continue;
            }
            completedAncestors.addAll(ancestors);
        }
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().list().entrySet()) {
            desc = sstableFiles.getKey();
            if (!completedAncestors.contains(desc.generation)) continue;
            logger.trace("Going to delete leftover compaction ancestor {}", (Object)desc);
            SSTable.delete(desc, sstableFiles.getValue());
            UUID compactionTaskID = unfinishedCompactions.get(desc.generation);
            if (compactionTaskID == null) continue;
            SystemKeyspace.finishCompaction(unfinishedCompactions.get(desc.generation));
        }
    }

    public static synchronized void loadNewSSTables(String ksName, String cfName) {
        Keyspace keyspace = Keyspace.open(ksName);
        keyspace.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    @Override
    public synchronized void loadNewSSTables() {
        logger.info("Loading new SSTables for {}/{}...", (Object)this.keyspace.getName(), (Object)this.name);
        HashSet<Descriptor> currentDescriptors = new HashSet<Descriptor>();
        for (SSTableReader sstable : this.data.getView().sstables) {
            currentDescriptors.add(sstable.descriptor);
        }
        HashSet<SSTableReader> newSSTables = new HashSet<SSTableReader>();
        Directories.SSTableLister lister = this.directories.sstableLister().skipTemporary(true);
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            SSTableReader reader;
            Descriptor newDescriptor;
            Descriptor descriptor;
            block21: {
                descriptor = entry.getKey();
                if (currentDescriptors.contains(descriptor) || descriptor.type.isTemporary) continue;
                if (!descriptor.isCompatible()) {
                    throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", descriptor.getFormat().getLatestVersion(), descriptor));
                }
                try {
                    if (!new File(descriptor.filenameFor(Component.STATS)).exists()) break block21;
                    descriptor.getMetadataSerializer().mutateLevel(descriptor, 0);
                }
                catch (IOException e) {
                    SSTableReader.logOpenException(entry.getKey(), e);
                    continue;
                }
            }
            while (new File((newDescriptor = new Descriptor(descriptor.version, descriptor.directory, descriptor.ksname, descriptor.cfname, this.fileIndexGenerator.incrementAndGet(), Descriptor.Type.FINAL, descriptor.formatType)).filenameFor(Component.DATA)).exists()) {
            }
            logger.info("Renaming new SSTable {} to {}", (Object)descriptor, (Object)newDescriptor);
            SSTableWriter.rename(descriptor, newDescriptor, entry.getValue());
            try {
                reader = SSTableReader.open(newDescriptor, entry.getValue(), this.metadata, this.partitioner);
            }
            catch (IOException e) {
                SSTableReader.logOpenException(entry.getKey(), e);
                continue;
            }
            newSSTables.add(reader);
        }
        if (newSSTables.isEmpty()) {
            logger.info("No new SSTables were found for {}/{}", (Object)this.keyspace.getName(), (Object)this.name);
            return;
        }
        logger.info("Loading new SSTables and building secondary indexes for {}/{}: {}", new Object[]{this.keyspace.getName(), this.name, newSSTables});
        try (Refs refs = Refs.ref(newSSTables);){
            this.data.addSSTables(newSSTables);
            this.indexManager.maybeBuildSecondaryIndexes(newSSTables, this.indexManager.allIndexesNames());
        }
        logger.info("Done loading load new SSTables for {}/{}", (Object)this.keyspace.getName(), (Object)this.name);
    }

    public void rebuildSecondaryIndex(String idxName) {
        ColumnFamilyStore.rebuildSecondaryIndex(this.keyspace.getName(), this.metadata.cfName, idxName);
    }

    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        HashSet<String> indexes = new HashSet<String>(Arrays.asList(idxNames));
        Collection<SSTableReader> sstables = cfs.getSSTables();
        try (Refs<SSTableReader> refs = Refs.ref(sstables);){
            cfs.indexManager.setIndexRemoved(indexes);
            logger.info(String.format("User Requested secondary index re-build for %s/%s indexes", ksName, cfName));
            cfs.indexManager.maybeBuildSecondaryIndexes(sstables, indexes);
            cfs.indexManager.setIndexBuilt(indexes);
        }
    }

    @Override
    public String getColumnFamilyName() {
        return this.name;
    }

    public String getTempSSTablePath(File directory) {
        return this.getTempSSTablePath(directory, DatabaseDescriptor.getSSTableFormat().info.getLatestVersion(), DatabaseDescriptor.getSSTableFormat());
    }

    public String getTempSSTablePath(File directory, SSTableFormat.Type format) {
        return this.getTempSSTablePath(directory, format.info.getLatestVersion(), format);
    }

    private String getTempSSTablePath(File directory, Version version, SSTableFormat.Type format) {
        Descriptor desc = new Descriptor(version, directory, this.keyspace.getName(), this.name, this.fileIndexGenerator.incrementAndGet(), Descriptor.Type.TEMP, format);
        return desc.filenameFor(Component.DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> switchMemtableIfCurrent(Memtable memtable) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            if (this.data.getView().getCurrentMemtable() == memtable) {
                return this.switchMemtable();
            }
        }
        return Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> switchMemtable() {
        Tracker tracker = this.data;
        synchronized (tracker) {
            this.logFlush();
            Flush flush = new Flush(false);
            flushExecutor.execute(flush);
            ListenableFutureTask task = ListenableFutureTask.create((Runnable)flush.postFlush, null);
            postFlushExecutor.submit((Runnable)task);
            return task;
        }
    }

    private void logFlush() {
        float onHeapRatio = 0.0f;
        float offHeapRatio = 0.0f;
        long onHeapTotal = 0L;
        long offHeapTotal = 0L;
        Memtable memtable = this.getTracker().getView().getCurrentMemtable();
        onHeapRatio += memtable.getAllocator().onHeap().ownershipRatio();
        offHeapRatio += memtable.getAllocator().offHeap().ownershipRatio();
        onHeapTotal += memtable.getAllocator().onHeap().owns();
        offHeapTotal += memtable.getAllocator().offHeap().owns();
        for (SecondaryIndex index : this.indexManager.getIndexes()) {
            if (index.getIndexCfs() == null) continue;
            MemtableAllocator allocator = index.getIndexCfs().getTracker().getView().getCurrentMemtable().getAllocator();
            onHeapRatio += allocator.onHeap().ownershipRatio();
            offHeapRatio += allocator.offHeap().ownershipRatio();
            onHeapTotal += allocator.onHeap().owns();
            offHeapTotal += allocator.offHeap().owns();
        }
        logger.debug("Enqueuing flush of {}: {}", (Object)this.name, (Object)String.format("%d (%.0f%%) on-heap, %d (%.0f%%) off-heap", onHeapTotal, Float.valueOf(onHeapRatio * 100.0f), offHeapTotal, Float.valueOf(offHeapRatio * 100.0f)));
    }

    public ListenableFuture<?> forceFlush() {
        return this.forceFlush(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> forceFlush(ReplayPosition flushIfDirtyBefore) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            boolean clean = true;
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                clean &= cfs.data.getView().getCurrentMemtable().isCleanAfter(flushIfDirtyBefore);
            }
            if (clean) {
                ListenableFutureTask task = ListenableFutureTask.create((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        logger.trace("forceFlush requested but everything is clean in {}", (Object)ColumnFamilyStore.this.name);
                    }
                }, null);
                postFlushExecutor.execute((Runnable)task);
                return task;
            }
            return this.switchMemtable();
        }
    }

    public void forceBlockingFlush() {
        FBUtilities.waitOnFuture(this.forceFlush());
    }

    private static String ratio(float onHeap, float offHeap) {
        return String.format("%.2f/%.2f", Float.valueOf(onHeap), Float.valueOf(offHeap));
    }

    public void maybeUpdateRowCache(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        RowCacheKey cacheKey = new RowCacheKey(this.metadata.ksAndCFName, key);
        this.invalidateCachedRow(cacheKey);
    }

    public void apply(DecoratedKey key, ColumnFamily columnFamily, SecondaryIndexManager.Updater indexer, OpOrder.Group opGroup, ReplayPosition replayPosition) {
        long start = System.nanoTime();
        Memtable mt = this.data.getMemtableFor(opGroup, replayPosition);
        long timeDelta = mt.put(key, columnFamily, indexer, opGroup);
        this.maybeUpdateRowCache(key);
        this.metric.samplers.get((Object)ColumnFamilyMetrics.Sampler.WRITES).addSample(key.getKey(), key.hashCode(), 1);
        this.metric.writeLatency.addNano(System.nanoTime() - start);
        if (timeDelta < Long.MAX_VALUE) {
            this.metric.colUpdateTimeDeltaHistogram.update(timeDelta);
        }
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        cf.purgeTombstones(gcBefore);
        return !cf.hasColumns() && !cf.isMarkedForDelete() ? null : cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        return ColumnFamilyStore.removeDeleted(cf, gcBefore, SecondaryIndexManager.nullUpdater);
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        if (cf == null) {
            return null;
        }
        return ColumnFamilyStore.removeDeletedCF(ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore, indexer), gcBefore);
    }

    public static ColumnFamily removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        boolean hasDroppedColumns;
        BatchRemoveIterator<Cell> iter = cf.batchRemoveIterator();
        DeletionInfo.InOrderTester tester = cf.inOrderDeletionTester();
        boolean bl = hasDroppedColumns = !cf.metadata.getDroppedColumns().isEmpty();
        while (iter.hasNext()) {
            Cell c = (Cell)iter.next();
            if (c.getLocalDeletionTime() >= gcBefore && !tester.isDeleted(c) && (!hasDroppedColumns || !ColumnFamilyStore.isDroppedColumn(c, cf.metadata()))) continue;
            iter.remove();
            indexer.remove(c);
        }
        iter.commit();
        return cf;
    }

    private static boolean isDroppedColumn(Cell c, CFMetaData meta) {
        Long droppedAt = meta.getDroppedColumns().get(c.name().cql3ColumnName(meta));
        return droppedAt != null && c.timestamp() <= droppedAt;
    }

    private void removeDroppedColumns(ColumnFamily cf) {
        if (cf == null || cf.metadata.getDroppedColumns().isEmpty()) {
            return;
        }
        BatchRemoveIterator<Cell> iter = cf.batchRemoveIterator();
        while (iter.hasNext()) {
            if (!ColumnFamilyStore.isDroppedColumn((Cell)iter.next(), this.metadata)) continue;
            iter.remove();
        }
        iter.commit();
    }

    public Collection<SSTableReader> getOverlappingSSTables(Iterable<SSTableReader> sstables) {
        logger.trace("Checking for sstables overlapping {}", sstables);
        if (!sstables.iterator().hasNext()) {
            return ImmutableSet.of();
        }
        ArrayList sortedByFirst = Lists.newArrayList(sstables);
        Collections.sort(sortedByFirst, new Comparator<SSTableReader>(){

            @Override
            public int compare(SSTableReader o1, SSTableReader o2) {
                return o1.first.compareTo(o2.first);
            }
        });
        ArrayList intervals = new ArrayList();
        DecoratedKey first = null;
        DecoratedKey last = null;
        for (SSTableReader sstable : sortedByFirst) {
            if (first == null) {
                first = sstable.first;
                last = sstable.last;
                continue;
            }
            if (sstable.first.compareTo(last) <= 0) {
                if (sstable.last.compareTo(last) <= 0) continue;
                last = sstable.last;
                continue;
            }
            intervals.add(Interval.create(first, last));
            first = sstable.first;
            last = sstable.last;
        }
        intervals.add(Interval.create(first, last));
        SSTableIntervalTree tree = this.data.getView().intervalTree;
        HashSet results = new HashSet();
        for (Interval interval : intervals) {
            results.addAll(tree.search(interval));
        }
        return Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
    }

    public Refs<SSTableReader> getAndReferenceOverlappingSSTables(Iterable<SSTableReader> sstables) {
        Collection<SSTableReader> overlapped;
        Refs<SSTableReader> refs;
        while ((refs = Refs.tryRef(overlapped = this.getOverlappingSSTables(sstables))) == null) {
        }
        return refs;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.name));
        this.addSSTables(Arrays.asList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        if (operation != OperationType.CLEANUP || this.isIndex()) {
            return SSTableReader.getTotalBytes(sstables);
        }
        long expectedFileSize = 0L;
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.keyspace.getName());
        for (SSTableReader sstable : sstables) {
            List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(ranges);
            for (Pair<Long, Long> position : positions) {
                expectedFileSize += (Long)position.right - (Long)position.left;
            }
        }
        double compressionRatio = (Double)this.metric.compressionRatio.getValue();
        if (compressionRatio > 0.0) {
            expectedFileSize = (long)((double)expectedFileSize * compressionRatio);
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public CompactionManager.AllSSTableOpStatus forceCleanup() throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performCleanup(this);
    }

    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData) throws ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, false, checkData);
    }

    @VisibleForTesting
    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean alwaysFail, boolean checkData) throws ExecutionException, InterruptedException {
        if (!disableSnapshot) {
            this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        }
        try {
            return CompactionManager.instance.performScrub(this, skipCorrupted, checkData);
        }
        catch (Throwable t) {
            if (!this.rebuildOnFailedScrub(t)) {
                throw t;
            }
            return alwaysFail ? CompactionManager.AllSSTableOpStatus.ABORTED : CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        }
    }

    public boolean rebuildOnFailedScrub(Throwable failure) {
        if (!this.isIndex()) {
            return false;
        }
        SecondaryIndex index = null;
        if (this.metadata.cfName.contains(".")) {
            String[] parts = this.metadata.cfName.split("\\.", 2);
            ColumnFamilyStore parentCfs = this.keyspace.getColumnFamilyStore(parts[0]);
            index = parentCfs.indexManager.getIndexByName(this.metadata.cfName);
            assert (index != null);
        }
        if (index == null) {
            return false;
        }
        this.truncateBlocking();
        logger.warn("Rebuilding index for {} because of <{}>", (Object)this.name, (Object)failure.getMessage());
        index.getBaseCfs().rebuildSecondaryIndex(index.getIndexName());
        return true;
    }

    public CompactionManager.AllSSTableOpStatus verify(boolean extendedVerify) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performVerify(this, extendedVerify);
    }

    public CompactionManager.AllSSTableOpStatus sstablesRewrite(boolean excludeCurrentVersion) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performSSTableRewrite(this, excludeCurrentVersion);
    }

    public void markObsolete(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        org.apache.cassandra.utils.Throwables.maybeFail(this.data.dropSSTables((Predicate<SSTableReader>)Predicates.in(sstables), compactionType, null));
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.compactionStrategyWrapper.replaceFlushed(memtable, sstable);
    }

    public boolean isValid() {
        return this.valid;
    }

    public Tracker getTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    public Set<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompacting();
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, Composite start, Composite finish, boolean reversed, int limit, long timestamp) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, this.name, start, finish, reversed, limit, timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getThroughCache(UUID cfId, QueryFilter filter) {
        assert (this.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [" + this.name + "]", new Object[0]);
        RowCacheKey key = new RowCacheKey(this.metadata.ksAndCFName, filter.key);
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                this.metric.rowCacheMiss.inc();
                return this.getTopLevelColumns(filter, Integer.MIN_VALUE);
            }
            ColumnFamily cachedCf = (ColumnFamily)cached;
            if (this.isFilterFullyCoveredBy(filter.filter, cachedCf, filter.timestamp)) {
                this.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                return this.filterColumnFamily(cachedCf, filter);
            }
            this.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.getTopLevelColumns(filter, Integer.MIN_VALUE);
        }
        this.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        RowCacheSentinel sentinel = new RowCacheSentinel();
        boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
        ColumnFamily data = null;
        ColumnFamily toCache = null;
        try {
            if (this.metadata.getCaching().rowCache.cacheFullPartitions()) {
                toCache = data = this.getTopLevelColumns(QueryFilter.getIdentityFilter(filter.key, this.name, filter.timestamp), Integer.MIN_VALUE);
                Tracing.trace("Populating row cache with the whole partition");
                if (sentinelSuccess && toCache != null) {
                    CacheService.instance.rowCache.replace(key, sentinel, toCache);
                }
                ColumnFamily columnFamily = this.filterColumnFamily(data, filter);
                return columnFamily;
            }
            if (filter.filter.isHeadFilter() && filter.filter.countCQL3Rows(this.metadata.comparator)) {
                SliceQueryFilter sliceFilter = (SliceQueryFilter)filter.filter;
                int rowsToCache = this.metadata.getCaching().rowCache.rowsToCache;
                SliceQueryFilter cacheSlice = this.readFilterForCache();
                QueryFilter cacheFilter = new QueryFilter(filter.key, this.name, cacheSlice, filter.timestamp);
                if (sliceFilter.count < rowsToCache) {
                    toCache = this.getTopLevelColumns(cacheFilter, Integer.MIN_VALUE);
                    if (toCache != null) {
                        Tracing.trace("Populating row cache ({} rows cached)", (Object)cacheSlice.lastCounted());
                        data = this.filterColumnFamily(toCache, filter);
                    }
                } else {
                    data = this.getTopLevelColumns(filter, Integer.MIN_VALUE);
                    if (data != null) {
                        if (sliceFilter.finish().isEmpty() || sliceFilter.lastCounted() >= rowsToCache) {
                            toCache = this.filterColumnFamily(data, cacheFilter);
                            Tracing.trace("Caching {} rows (out of {} requested)", (Object)cacheSlice.lastCounted(), (Object)sliceFilter.count);
                        } else {
                            Tracing.trace("Not populating row cache, not enough rows fetched ({} fetched but {} required for the cache)", (Object)sliceFilter.lastCounted(), (Object)rowsToCache);
                        }
                    }
                }
                if (sentinelSuccess && toCache != null) {
                    CacheService.instance.rowCache.replace(key, sentinel, toCache);
                }
                ColumnFamily columnFamily = data;
                return columnFamily;
            }
            Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
            ColumnFamily columnFamily = this.getTopLevelColumns(filter, Integer.MIN_VALUE);
            return columnFamily;
        }
        finally {
            if (sentinelSuccess && toCache == null) {
                this.invalidateCachedRow(key);
            }
        }
    }

    public SliceQueryFilter readFilterForCache() {
        return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, this.metadata.getCaching().rowCache.rowsToCache, this.metadata.clusteringColumns().size());
    }

    public boolean isFilterFullyCoveredBy(IDiskAtomFilter filter, ColumnFamily cachedCf, long now) {
        boolean wholePartitionCached = cachedCf.liveCQL3RowCount(Integer.MIN_VALUE) < this.metadata.getCaching().rowCache.rowsToCache;
        return wholePartitionCached || filter.isFullyCoveredBy(cachedCf, now);
    }

    public int gcBefore(long now) {
        return (int)(now / 1000L) - this.metadata.getGcGraceSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamily getColumnFamily(QueryFilter filter) {
        assert (this.name.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        ColumnFamily result = null;
        long start = System.nanoTime();
        try {
            int gcBefore = this.gcBefore(filter.timestamp);
            if (this.isRowCacheEnabled()) {
                assert (!this.isIndex());
                UUID cfId = this.metadata.cfId;
                ColumnFamily cached = this.getThroughCache(cfId, filter);
                if (cached == null) {
                    logger.trace("cached row is empty");
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = cached;
            } else {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore);
                if (cf == null) {
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
            }
            this.removeDroppedColumns(result);
            if (filter.filter instanceof SliceQueryFilter) {
                this.metric.tombstoneScannedHistogram.update(((SliceQueryFilter)filter.filter).lastTombstones());
                this.metric.liveScannedHistogram.update(((SliceQueryFilter)filter.filter).lastLive());
            }
        }
        finally {
            this.metric.readLatency.addNano(System.nanoTime() - start);
        }
        return result;
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter) {
        if (cached == null) {
            return null;
        }
        ArrayBackedSortedColumns cf = cached.cloneMeShallow(ArrayBackedSortedColumns.factory, filter.filter.isReversed());
        int gcBefore = this.gcBefore(filter.timestamp);
        filter.collateOnDiskAtom((ColumnFamily)cf, filter.getIterator(cached), gcBefore);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    public Set<SSTableReader> getUnrepairedSSTables() {
        HashSet<SSTableReader> unRepairedSSTables = new HashSet<SSTableReader>(this.getSSTables());
        Iterator sstableIterator = unRepairedSSTables.iterator();
        while (sstableIterator.hasNext()) {
            SSTableReader sstable = (SSTableReader)sstableIterator.next();
            if (!sstable.isRepaired()) continue;
            sstableIterator.remove();
        }
        return unRepairedSSTables;
    }

    public Set<SSTableReader> getRepairedSSTables() {
        HashSet<SSTableReader> repairedSSTables = new HashSet<SSTableReader>(this.getSSTables());
        Iterator sstableIterator = repairedSSTables.iterator();
        while (sstableIterator.hasNext()) {
            SSTableReader sstable = (SSTableReader)sstableIterator.next();
            if (sstable.isRepaired()) continue;
            sstableIterator.remove();
        }
        return repairedSSTables;
    }

    public RefViewFragment selectAndReference(Function<View, List<SSTableReader>> filter) {
        long failingSince = -1L;
        while (true) {
            ViewFragment view = this.select(filter);
            Refs<SSTableReader> refs = Refs.tryRef(view.sstables);
            if (refs != null) {
                return new RefViewFragment(view.sstables, view.memtables, refs);
            }
            if (failingSince <= 0L) {
                failingSince = System.nanoTime();
                continue;
            }
            if (TimeUnit.MILLISECONDS.toNanos(100L) <= System.nanoTime() - failingSince) continue;
            ArrayList<SSTableReader> released = new ArrayList<SSTableReader>();
            for (SSTableReader reader : view.sstables) {
                if (reader.selfRef().globalCount() != 0) continue;
                released.add(reader);
            }
            logger.info("Spinning trying to capture released readers {}", released);
            logger.info("Spinning trying to capture all readers {}", view.sstables);
            failingSince = System.nanoTime();
        }
    }

    public ViewFragment select(Function<View, List<SSTableReader>> filter) {
        View view = this.data.getView();
        List sstables = view.intervalTree.isEmpty() ? Collections.emptyList() : (List)filter.apply((Object)view);
        return new ViewFragment(sstables, view.getAllMemtables());
    }

    public Function<View, List<SSTableReader>> viewFilter(final DecoratedKey key) {
        assert (!key.isMinimum());
        return new Function<View, List<SSTableReader>>(){

            public List<SSTableReader> apply(View view) {
                return ColumnFamilyStore.this.compactionStrategyWrapper.filterSSTablesForReads(view.intervalTree.search(key));
            }
        };
    }

    public Function<View, List<SSTableReader>> viewFilter(final AbstractBounds<RowPosition> rowBounds) {
        assert (!AbstractBounds.strictlyWrapsAround(rowBounds.left, rowBounds.right));
        return new Function<View, List<SSTableReader>>(){

            public List<SSTableReader> apply(View view) {
                return view.sstablesInBounds((RowPosition)rowBounds.left, (RowPosition)rowBounds.right);
            }
        };
    }

    public Function<View, List<SSTableReader>> viewFilter(final Collection<AbstractBounds<RowPosition>> rowBoundsCollection, final boolean includeRepaired) {
        assert (AbstractBounds.noneStrictlyWrapsAround(rowBoundsCollection));
        return new Function<View, List<SSTableReader>>(){

            public List<SSTableReader> apply(View view) {
                HashSet sstables = Sets.newHashSet();
                for (AbstractBounds rowBounds : rowBoundsCollection) {
                    for (SSTableReader sstable : view.sstablesInBounds((RowPosition)rowBounds.left, (RowPosition)rowBounds.right)) {
                        if (!includeRepaired && sstable.isRepaired()) continue;
                        sstables.add(sstable);
                    }
                }
                logger.trace("ViewFilter for {}/{} sstables", (Object)sstables.size(), (Object)ColumnFamilyStore.this.getSSTables().size());
                return ImmutableList.copyOf((Collection)sstables);
            }
        };
    }

    @Override
    public List<String> getSSTablesForKey(String key) {
        DecoratedKey dk = this.partitioner.decorateKey(this.metadata.getKeyValidator().fromString(key));
        try (OpOrder.Group op = this.readOrdering.start();){
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : this.select(this.viewFilter((DecoratedKey)dk)).sstables) {
                if (sstr.getPosition(dk, SSTableReader.Operator.EQ, false) == null) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    public ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore) {
        ColumnFamily columns;
        Tracing.trace("Executing single-partition query on {}", (Object)this.name);
        CollationController controller = new CollationController(this, filter, gcBefore);
        try (OpOrder.Group op = this.readOrdering.start();){
            columns = controller.getTopLevelColumns(Memtable.MEMORY_POOL.needToCopyOnHeap());
        }
        if (columns != null) {
            this.metric.samplers.get((Object)ColumnFamilyMetrics.Sampler.READS).addSample(filter.key.getKey(), filter.key.hashCode(), 1);
        }
        this.metric.updateSSTableIterated(controller.getSstablesIterated());
        return columns;
    }

    @Override
    public void beginLocalSampling(String sampler, int capacity) {
        this.metric.samplers.get((Object)ColumnFamilyMetrics.Sampler.valueOf(sampler)).beginSampling(capacity);
    }

    @Override
    public CompositeData finishLocalSampling(String sampler, int count) throws OpenDataException {
        TopKSampler.SamplerResult<ByteBuffer> samplerResults = this.metric.samplers.get((Object)ColumnFamilyMetrics.Sampler.valueOf(sampler)).finishSampling(count);
        TabularDataSupport result = new TabularDataSupport(COUNTER_TYPE);
        for (Counter counter : samplerResults.topK) {
            byte[] key = ((ByteBuffer)counter.getItem()).array();
            result.put(new CompositeDataSupport(COUNTER_COMPOSITE_TYPE, COUNTER_NAMES, new Object[]{Hex.bytesToHex(key), counter.getCount(), counter.getError(), this.metadata.getKeyValidator().getString(ByteBuffer.wrap(key))}));
        }
        return new CompositeDataSupport(SAMPLING_RESULT, SAMPLER_NAMES, new Object[]{samplerResults.cardinality, result});
    }

    public void cleanupCache() {
        DecoratedKey dk;
        CacheKey key;
        Collection ranges = StorageService.instance.getLocalRanges(this.keyspace.getName());
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            key = (RowCacheKey)keyIter.next();
            dk = this.partitioner.decorateKey(ByteBuffer.wrap(key.key));
            if (!key.ksAndCFName.equals(this.metadata.ksAndCFName) || Range.isInRanges(dk.getToken(), ranges)) continue;
            this.invalidateCachedRow(dk);
        }
        if (this.metadata.isCounter()) {
            keyIter = CacheService.instance.counterCache.keyIterator();
            while (keyIter.hasNext()) {
                key = (CounterCacheKey)keyIter.next();
                dk = this.partitioner.decorateKey(ByteBuffer.wrap(((CounterCacheKey)key).partitionKey));
                if (!((CounterCacheKey)key).ksAndCFName.equals(this.metadata.ksAndCFName) || Range.isInRanges(dk.getToken(), ranges)) continue;
                CacheService.instance.counterCache.remove((CounterCacheKey)key);
            }
        }
    }

    private AbstractScanIterator getSequentialIterator(final DataRange range, long now) {
        assert (!(range.keyRange() instanceof Range) || !((Range)range.keyRange()).isWrapAround() || ((RowPosition)range.keyRange().right).isMinimum()) : range.keyRange();
        ViewFragment view = this.select(this.viewFilter(range.keyRange()));
        Tracing.trace("Executing seq scan across {} sstables for {}", (Object)view.sstables.size(), (Object)range.keyRange().getString(this.metadata.getKeyValidator()));
        final CloseableIterator<Row> iterator = RowIteratorFactory.getIterator(view.memtables, view.sstables, range, this, now);
        return new AbstractScanIterator(){

            protected Row computeNext() {
                Row current;
                DecoratedKey key;
                do {
                    if (!iterator.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    current = (Row)iterator.next();
                    key = current.key;
                    if (range.stopKey().isMinimum() || range.stopKey().compareTo(key) >= 0) continue;
                    return (Row)this.endOfData();
                } while (!range.contains(key));
                if (logger.isTraceEnabled()) {
                    logger.trace("scanned {}", (Object)ColumnFamilyStore.this.metadata.getKeyValidator().getString(key.getKey()));
                }
                return current;
            }

            @Override
            public void close() throws IOException {
                iterator.close();
            }
        };
    }

    @VisibleForTesting
    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults) {
        return this.getRangeSlice(range, rowFilter, columnFilter, maxResults, System.currentTimeMillis());
    }

    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults, long now) {
        return this.getRangeSlice(this.makeExtendedFilter(range, columnFilter, rowFilter, maxResults, false, false, now));
    }

    public ExtendedFilter makeExtendedFilter(AbstractBounds<RowPosition> keyRange, SliceQueryFilter columnRange, Composite columnStart, Composite columnStop, List<IndexExpression> rowFilter, int maxResults, boolean countCQL3Rows, long now) {
        DataRange.Paging dataRange = new DataRange.Paging(keyRange, columnRange, columnStart, columnStop, this.metadata);
        return ExtendedFilter.create(this, dataRange, rowFilter, maxResults, countCQL3Rows, now);
    }

    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults, long now, boolean countCQL3Rows, boolean isPaging) {
        return this.getRangeSlice(this.makeExtendedFilter(range, columnFilter, rowFilter, maxResults, countCQL3Rows, isPaging, now));
    }

    public ExtendedFilter makeExtendedFilter(AbstractBounds<RowPosition> range, IDiskAtomFilter columnFilter, List<IndexExpression> rowFilter, int maxResults, boolean countCQL3Rows, boolean isPaging, long timestamp) {
        DataRange dataRange;
        if (isPaging) {
            assert (columnFilter instanceof SliceQueryFilter);
            SliceQueryFilter sfilter = (SliceQueryFilter)columnFilter;
            assert (sfilter.slices.length == 1);
            SliceQueryFilter newFilter = new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, sfilter.isReversed(), sfilter.count);
            dataRange = new DataRange.Paging(range, newFilter, sfilter.start(), sfilter.finish(), this.metadata);
        } else {
            dataRange = new DataRange(range, columnFilter);
        }
        return ExtendedFilter.create(this, dataRange, rowFilter, maxResults, countCQL3Rows, timestamp);
    }

    /*
     * Loose catch block
     */
    public List<Row> getRangeSlice(ExtendedFilter filter) {
        long start = System.nanoTime();
        try {
            try (OpOrder.Group op = this.readOrdering.start();){
                List<Row> list = this.filter(this.getSequentialIterator(filter.dataRange, filter.timestamp), filter);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.metric.rangeLatency.addNano(System.nanoTime() - start);
        }
    }

    @VisibleForTesting
    public List<Row> search(AbstractBounds<RowPosition> range, List<IndexExpression> clause, IDiskAtomFilter dataFilter, int maxResults) {
        return this.search(range, clause, dataFilter, maxResults, System.currentTimeMillis());
    }

    public List<Row> search(AbstractBounds<RowPosition> range, List<IndexExpression> clause, IDiskAtomFilter dataFilter, int maxResults, long now) {
        return this.search(this.makeExtendedFilter(range, dataFilter, clause, maxResults, false, false, now));
    }

    public List<Row> search(ExtendedFilter filter) {
        Tracing.trace("Executing indexed scan for {}", (Object)filter.dataRange.keyRange().getString(this.metadata.getKeyValidator()));
        return this.indexManager.search(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> filter(AbstractScanIterator rowIterator, ExtendedFilter filter) {
        logger.trace("Filtering {} for rows matching {}", (Object)rowIterator, (Object)filter);
        ArrayList<Row> rows = new ArrayList<Row>();
        int columnsCount = 0;
        int total = 0;
        int matched = 0;
        boolean ignoreTombstonedPartitions = filter.ignoreTombstonedPartitions();
        try {
            while (rowIterator.hasNext() && matched < filter.maxRows() && columnsCount < filter.maxColumns()) {
                Row rawRow = (Row)rowIterator.next();
                ++total;
                ColumnFamily data = rawRow.cf;
                if (rowIterator.needsFiltering()) {
                    ColumnFamily cf;
                    IDiskAtomFilter extraFilter = filter.getExtraFilter(rawRow.key, data);
                    if (extraFilter != null && (cf = filter.cfs.getColumnFamily(new QueryFilter(rawRow.key, this.name, extraFilter, filter.timestamp))) != null) {
                        data.addAll(cf);
                    }
                    this.removeDroppedColumns(data);
                    if (!filter.isSatisfiedBy(rawRow.key, data, null, null)) continue;
                    logger.trace("{} satisfies all filter expressions", (Object)data);
                    data = filter.prune(rawRow.key, data);
                } else {
                    this.removeDroppedColumns(data);
                }
                rows.add(new Row(rawRow.key, data));
                if (!ignoreTombstonedPartitions || !data.hasOnlyTombstones(filter.timestamp)) {
                    ++matched;
                }
                if (data != null) {
                    columnsCount += filter.lastCounted(data);
                }
                filter.updateFilter(columnsCount);
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        finally {
            try {
                rowIterator.close();
                Tracing.trace("Scanned {} rows and matched {}", (Object)total, (Object)matched);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public CellNameType getComparator() {
        return this.metadata.comparator;
    }

    public void snapshotWithoutFlush(String snapshotName) {
        this.snapshotWithoutFlush(snapshotName, null, false);
    }

    public Set<SSTableReader> snapshotWithoutFlush(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral) {
        HashSet<SSTableReader> snapshottedSSTables = new HashSet<SSTableReader>();
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            JSONArray filesJSONArr = new JSONArray();
            RefViewFragment currentView = cfs.selectAndReference(CANONICAL_SSTABLES);
            Throwable throwable = null;
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    if (predicate != null && !predicate.apply((Object)ssTable)) continue;
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.getPath());
                    filesJSONArr.add((Object)ssTable.descriptor.relativeFilenameFor(Component.DATA));
                    if (logger.isTraceEnabled()) {
                        logger.trace("Snapshot for {} keyspace data file {} created in {}", new Object[]{this.keyspace, ssTable.getFilename(), snapshotDirectory});
                    }
                    snapshottedSSTables.add(ssTable);
                }
                this.writeSnapshotManifest(filesJSONArr, snapshotName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (currentView == null) continue;
                if (throwable != null) {
                    try {
                        currentView.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                currentView.close();
            }
        }
        if (ephemeral) {
            this.createEphemeralSnapshotMarkerFile(snapshotName);
        }
        return snapshottedSSTables;
    }

    private void writeSnapshotManifest(JSONArray filesJSONArr, String snapshotName) {
        File manifestFile = this.directories.getSnapshotManifestFile(snapshotName);
        try {
            if (!manifestFile.getParentFile().exists()) {
                manifestFile.getParentFile().mkdirs();
            }
            try (PrintStream out = new PrintStream(manifestFile);){
                JSONObject manifestJSON = new JSONObject();
                manifestJSON.put((Object)"files", (Object)filesJSONArr);
                out.println(manifestJSON.toJSONString());
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, manifestFile);
        }
    }

    private void createEphemeralSnapshotMarkerFile(String snapshot) {
        File ephemeralSnapshotMarker = this.directories.getNewEphemeralSnapshotMarkerFile(snapshot);
        try {
            if (!ephemeralSnapshotMarker.getParentFile().exists()) {
                ephemeralSnapshotMarker.getParentFile().mkdirs();
            }
            Files.createFile(ephemeralSnapshotMarker.toPath(), new FileAttribute[0]);
            logger.trace("Created ephemeral snapshot marker file on {}.", (Object)ephemeralSnapshotMarker.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warn(String.format("Could not create marker file %s for ephemeral snapshot %s. In case there is a failure in the operation that created this snapshot, you may need to clean it manually afterwards.", ephemeralSnapshotMarker.getAbsolutePath(), snapshot), (Throwable)e);
        }
    }

    protected static void clearEphemeralSnapshots(Directories directories) {
        for (String ephemeralSnapshot : directories.listEphemeralSnapshots()) {
            logger.trace("Clearing ephemeral snapshot {} leftover from previous session.", (Object)ephemeralSnapshot);
            Directories.clearSnapshot(ephemeralSnapshot, directories.getCFDirectories());
        }
    }

    public Refs<SSTableReader> getSnapshotSSTableReader(String tag) throws IOException {
        HashMap<Integer, SSTableReader> active = new HashMap<Integer, SSTableReader>();
        for (SSTableReader sstable : this.data.getView().sstables) {
            active.put(sstable.descriptor.generation, sstable);
        }
        Map<Descriptor, Set<Component>> snapshots = this.directories.sstableLister().snapshots(tag).list();
        Refs<SSTableReader> refs = new Refs<SSTableReader>();
        try {
            for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
                SSTableReader sstable = (SSTableReader)active.get(entries.getKey().generation);
                if (sstable == null || !refs.tryRef(sstable)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("using snapshot sstable {}", (Object)entries.getKey());
                    }
                    sstable = SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, this.partitioner, true, false);
                    refs.tryRef(sstable);
                    sstable.selfRef().release();
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("using active sstable {}", (Object)entries.getKey());
            }
        }
        catch (IOException | RuntimeException e) {
            refs.release();
            throw e;
        }
        return refs;
    }

    public Set<SSTableReader> snapshot(String snapshotName) {
        return this.snapshot(snapshotName, null, false);
    }

    public Set<SSTableReader> snapshot(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral) {
        this.forceBlockingFlush();
        return this.snapshotWithoutFlush(snapshotName, predicate, ephemeral);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.directories.snapshotExists(snapshotName);
    }

    public long getSnapshotCreationTime(String snapshotName) {
        return this.directories.snapshotCreationTime(snapshotName);
    }

    public void clearSnapshot(String snapshotName) {
        List<File> snapshotDirs = this.directories.getCFDirectories();
        Directories.clearSnapshot(snapshotName, snapshotDirs);
    }

    public Map<String, Pair<Long, Long>> getSnapshotDetails() {
        return this.directories.getSnapshotDetails();
    }

    public boolean hasUnreclaimedSpace() {
        return this.metric.liveDiskSpaceUsed.getCount() < this.metric.totalDiskSpaceUsed.getCount();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return null;
        }
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(new RowCacheKey(this.metadata.ksAndCFName, key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (ColumnFamily)cached;
    }

    private void invalidateCaches() {
        CacheService.instance.invalidateKeyCacheForCf(this.metadata.ksAndCFName);
        CacheService.instance.invalidateRowCacheForCf(this.metadata.ksAndCFName);
        if (this.metadata.isCounter()) {
            CacheService.instance.invalidateCounterCacheForCf(this.metadata.ksAndCFName);
        }
    }

    public int invalidateRowCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            RowCacheKey key = (RowCacheKey)keyIter.next();
            DecoratedKey dk = this.partitioner.decorateKey(ByteBuffer.wrap(key.key));
            if (!key.ksAndCFName.equals(this.metadata.ksAndCFName) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            this.invalidateCachedRow(dk);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public int invalidateCounterCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.counterCache.keyIterator();
        while (keyIter.hasNext()) {
            CounterCacheKey key = (CounterCacheKey)keyIter.next();
            DecoratedKey dk = this.partitioner.decorateKey(ByteBuffer.wrap(key.partitionKey));
            if (!key.ksAndCFName.equals(this.metadata.ksAndCFName) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            CacheService.instance.counterCache.remove(key);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public boolean containsCachedRow(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey(this.metadata.ksAndCFName, key));
    }

    public void invalidateCachedRow(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        UUID cfId = Schema.instance.getId(this.keyspace.getName(), this.name);
        if (cfId == null) {
            return;
        }
        this.invalidateCachedRow(new RowCacheKey(this.metadata.ksAndCFName, key));
    }

    public ClockAndCount getCachedCounter(ByteBuffer partitionKey, CellName cellName) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return null;
        }
        return (ClockAndCount)CacheService.instance.counterCache.get(CounterCacheKey.create(this.metadata.ksAndCFName, partitionKey, cellName));
    }

    public void putCachedCounter(ByteBuffer partitionKey, CellName cellName, ClockAndCount clockAndCount) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return;
        }
        CacheService.instance.counterCache.put(CounterCacheKey.create(this.metadata.ksAndCFName, partitionKey, cellName), clockAndCount);
    }

    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        this.forceMajorCompaction(false);
    }

    @Override
    public void forceMajorCompaction(boolean splitOutput) throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this, splitOutput);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getKeyspaces().size());
        for (Keyspace keyspace : Keyspace.all()) {
            stores.add(keyspace.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public Iterable<DecoratedKey> keySamples(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(CANONICAL_SSTABLES);){
            Iterable[] samples = new Iterable[view.sstables.size()];
            int i = 0;
            for (SSTableReader sstable : view.sstables) {
                samples[i++] = sstable.getKeySamples(range);
            }
            Iterable iterable = Iterables.concat((Iterable[])samples);
            return iterable;
        }
    }

    public long estimatedKeysForRange(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(CANONICAL_SSTABLES);){
            long count = 0L;
            for (SSTableReader sstable : view.sstables) {
                count += sstable.estimatedKeysForRanges(Collections.singleton(range));
            }
            long l = count;
            return l;
        }
    }

    @VisibleForTesting
    public void clearUnsafe() {
        for (final ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.runWithCompactionsDisabled(new Callable<Void>(){

                @Override
                public Void call() {
                    cfs.data.reset();
                    return null;
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateBlocking() {
        logger.trace("truncating {}", (Object)this.name);
        if (this.keyspace.getMetadata().durableWrites || DatabaseDescriptor.isAutoSnapshot()) {
            this.forceBlockingFlush();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            Tracker tracker = this.data;
            synchronized (tracker) {
                Flush flush = new Flush(true);
                flushExecutor.execute(flush);
                postFlushExecutor.submit(flush.postFlush);
            }
        }
        Runnable truncateRunnable = new Runnable(){

            @Override
            public void run() {
                logger.trace("Discarding sstable data for truncated CF + indexes");
                long truncatedAt = System.currentTimeMillis();
                ColumnFamilyStore.this.data.notifyTruncated(truncatedAt);
                if (DatabaseDescriptor.isAutoSnapshot()) {
                    ColumnFamilyStore.this.snapshot(Keyspace.getTimestampedSnapshotName(ColumnFamilyStore.this.name));
                }
                ReplayPosition replayAfter = ColumnFamilyStore.this.discardSSTables(truncatedAt);
                for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexes()) {
                    index.truncateBlocking(truncatedAt);
                }
                SystemKeyspace.saveTruncationRecord(ColumnFamilyStore.this, truncatedAt, replayAfter);
                logger.trace("cleaning out row cache");
                ColumnFamilyStore.this.invalidateCaches();
            }
        };
        this.runWithCompactionsDisabled(Executors.callable(truncateRunnable), true);
        logger.trace("truncate complete");
    }

    /*
     * Exception decompiling
     */
    public <V> V runWithCompactionsDisabled(Callable<V> callable, boolean interruptValidation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public LifecycleTransaction markAllCompacting(final OperationType operationType) {
        Callable<LifecycleTransaction> callable = new Callable<LifecycleTransaction>(){

            @Override
            public LifecycleTransaction call() throws Exception {
                assert (ColumnFamilyStore.this.data.getCompacting().isEmpty()) : ColumnFamilyStore.access$000(ColumnFamilyStore.this).getCompacting();
                ArrayList sstables = Lists.newArrayList(AbstractCompactionStrategy.filterSuspectSSTables(ColumnFamilyStore.this.getSSTables()));
                LifecycleTransaction modifier = ColumnFamilyStore.this.data.tryModify(sstables, operationType);
                assert (modifier != null) : "something marked things compacting while compactions are disabled";
                return modifier;
            }
        };
        return this.runWithCompactionsDisabled(callable, false);
    }

    public String toString() {
        return "CFS(Keyspace='" + this.keyspace.getName() + '\'' + ", ColumnFamily='" + this.name + '\'' + ')';
    }

    public void disableAutoCompaction() {
        this.compactionStrategyWrapper.disable();
    }

    public void enableAutoCompaction() {
        this.enableAutoCompaction(false);
    }

    @VisibleForTesting
    public void enableAutoCompaction(boolean waitForFutures) {
        this.compactionStrategyWrapper.enable();
        List<Future<?>> futures = CompactionManager.instance.submitBackground(this);
        if (waitForFutures) {
            FBUtilities.waitOnFutures(futures);
        }
    }

    @Override
    public boolean isAutoCompactionDisabled() {
        return !this.compactionStrategyWrapper.isEnabled();
    }

    public AbstractCompactionStrategy getCompactionStrategy() {
        return this.compactionStrategyWrapper;
    }

    @Override
    public void setCompactionThresholds(int minThreshold, int maxThreshold) {
        this.validateCompactionThresholds(minThreshold, maxThreshold);
        this.minCompactionThreshold.set(minThreshold);
        this.maxCompactionThreshold.set(maxThreshold);
        CompactionManager.instance.submitBackground(this);
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        this.validateCompactionThresholds(minCompactionThreshold, this.maxCompactionThreshold.value());
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        this.validateCompactionThresholds(this.minCompactionThreshold.value(), maxCompactionThreshold);
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    private void validateCompactionThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold > maxThreshold) {
            throw new RuntimeException(String.format("The min_compaction_threshold cannot be larger than the max_compaction_threshold. Min is '%d', Max is '%d'.", minThreshold, maxThreshold));
        }
        if (maxThreshold == 0 || minThreshold == 0) {
            throw new RuntimeException("Disabling compaction by setting min_compaction_threshold or max_compaction_threshold to 0 is deprecated, set the compaction strategy option 'enabled' to 'false' instead or use the nodetool command 'disableautocompaction'.");
        }
    }

    public int getMeanColumns() {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : this.getSSTables()) {
            long n = sstable.getEstimatedColumnCount().count();
            sum += sstable.getEstimatedColumnCount().mean() * n;
            count += n;
        }
        return count > 0L ? (int)(sum / count) : 0;
    }

    @Override
    public long estimateKeys() {
        long n = 0L;
        for (SSTableReader sstable : this.getSSTables()) {
            n += sstable.estimatedKeys();
        }
        return n;
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(Collections.singleton(this), this.indexManager.getIndexesBackedByCfs());
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexes();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategyWrapper.getUnleveledSSTables();
    }

    @Override
    public int[] getSSTableCountPerLevel() {
        return this.compactionStrategyWrapper.getSSTableCountPerLevel();
    }

    public boolean isEmpty() {
        View view = this.data.getView();
        return view.sstables.isEmpty() && view.getCurrentMemtable().getOperations() == 0L && view.liveMemtables.size() <= 1 && view.flushingMemtables.size() == 0;
    }

    public boolean isRowCacheEnabled() {
        return this.metadata.getCaching().rowCache.isEnabled() && CacheService.instance.rowCache.getCapacity() > 0L;
    }

    public boolean isCounterCacheEnabled() {
        return this.metadata.isCounter() && CacheService.instance.counterCache.getCapacity() > 0L;
    }

    public boolean isKeyCacheEnabled() {
        return this.metadata.getCaching().keyCache.isEnabled() && CacheService.instance.keyCache.getCapacity() > 0L;
    }

    public ReplayPosition discardSSTables(long truncatedAt) {
        assert (this.data.getCompacting().isEmpty()) : this.data.getCompacting();
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables()) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (truncatedSSTables.isEmpty()) {
            return ReplayPosition.NONE;
        }
        this.markObsolete(truncatedSSTables, OperationType.UNKNOWN);
        return ReplayPosition.getReplayPosition(truncatedSSTables);
    }

    @Override
    public double getDroppableTombstoneRatio() {
        double allDroppable = 0.0;
        long allColumns = 0L;
        int localTime = (int)(System.currentTimeMillis() / 1000L);
        for (SSTableReader sstable : this.getSSTables()) {
            allDroppable += sstable.getDroppableTombstonesBefore(localTime - sstable.metadata.getGcGraceSeconds());
            allColumns += sstable.getEstimatedColumnCount().mean() * sstable.getEstimatedColumnCount().count();
        }
        return allColumns > 0L ? allDroppable / (double)allColumns : 0.0;
    }

    @Override
    public long trueSnapshotsSize() {
        return this.directories.trueSnapshotsSize();
    }

    @VisibleForTesting
    void resetFileIndexGenerator() {
        this.fileIndexGenerator.set(0);
    }

    static {
        SAMPLER_NAMES = new String[]{"cardinality", "partitions"};
        SAMPLER_DESCS = new String[]{"cardinality of partitions", "list of counter results"};
        try {
            OpenType[] counterTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING};
            COUNTER_COMPOSITE_TYPE = new CompositeType(SAMPLING_RESULTS_NAME, SAMPLING_RESULTS_NAME, COUNTER_NAMES, COUNTER_DESCS, counterTypes);
            COUNTER_TYPE = new TabularType(SAMPLING_RESULTS_NAME, SAMPLING_RESULTS_NAME, COUNTER_COMPOSITE_TYPE, COUNTER_NAMES);
            OpenType[] samplerTypes = new OpenType[]{SimpleType.LONG, COUNTER_TYPE};
            SAMPLING_RESULT = new CompositeType(SAMPLING_RESULTS_NAME, SAMPLING_RESULTS_NAME, SAMPLER_NAMES, SAMPLER_DESCS, samplerTypes);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
        CANONICAL_SSTABLES = new Function<View, List<SSTableReader>>(){

            public List<SSTableReader> apply(View view) {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
                for (SSTableReader sstable : view.compacting) {
                    if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                    sstables.add(sstable);
                }
                for (SSTableReader sstable : view.sstables) {
                    if (view.compacting.contains(sstable) || sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                    sstables.add(sstable);
                }
                return sstables;
            }
        };
        UNREPAIRED_SSTABLES = new Function<View, List<SSTableReader>>(){

            public List<SSTableReader> apply(View view) {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
                for (SSTableReader sstable : (List)CANONICAL_SSTABLES.apply((Object)view)) {
                    if (sstable.isRepaired()) continue;
                    sstables.add(sstable);
                }
                return sstables;
            }
        };
    }

    public static class RefViewFragment
    extends ViewFragment
    implements AutoCloseable {
        public final Refs<SSTableReader> refs;

        public RefViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables, Refs<SSTableReader> refs) {
            super(sstables, memtables);
            this.refs = refs;
        }

        public void release() {
            this.refs.release();
        }

        @Override
        public void close() {
            this.refs.release();
        }
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static abstract class AbstractScanIterator
    extends AbstractIterator<Row>
    implements CloseableIterator<Row> {
        public boolean needsFiltering() {
            return true;
        }
    }

    public static class FlushLargestColumnFamily
    implements Runnable {
        @Override
        public void run() {
            float largestRatio = 0.0f;
            Memtable largest = null;
            float liveOnHeap = 0.0f;
            float liveOffHeap = 0.0f;
            for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
                Memtable current = cfs.getTracker().getView().getCurrentMemtable();
                float onHeap = 0.0f;
                float offHeap = 0.0f;
                onHeap += current.getAllocator().onHeap().ownershipRatio();
                offHeap += current.getAllocator().offHeap().ownershipRatio();
                for (SecondaryIndex index : cfs.indexManager.getIndexes()) {
                    if (index.getIndexCfs() == null) continue;
                    MemtableAllocator allocator = index.getIndexCfs().getTracker().getView().getCurrentMemtable().getAllocator();
                    onHeap += allocator.onHeap().ownershipRatio();
                    offHeap += allocator.offHeap().ownershipRatio();
                }
                float ratio = Math.max(onHeap, offHeap);
                if (ratio > largestRatio) {
                    largest = current;
                    largestRatio = ratio;
                }
                liveOnHeap += onHeap;
                liveOffHeap += offHeap;
            }
            if (largest != null) {
                float usedOnHeap = Memtable.MEMORY_POOL.onHeap.usedRatio();
                float usedOffHeap = Memtable.MEMORY_POOL.offHeap.usedRatio();
                float flushingOnHeap = Memtable.MEMORY_POOL.onHeap.reclaimingRatio();
                float flushingOffHeap = Memtable.MEMORY_POOL.offHeap.reclaimingRatio();
                float thisOnHeap = largest.getAllocator().onHeap().ownershipRatio();
                float thisOffHeap = largest.getAllocator().onHeap().ownershipRatio();
                logger.debug("Flushing largest {} to free up room. Used total: {}, live: {}, flushing: {}, this: {}", new Object[]{largest.cfs, ColumnFamilyStore.ratio(usedOnHeap, usedOffHeap), ColumnFamilyStore.ratio(liveOnHeap, liveOffHeap), ColumnFamilyStore.ratio(flushingOnHeap, flushingOffHeap), ColumnFamilyStore.ratio(thisOnHeap, thisOffHeap)});
                largest.cfs.switchMemtableIfCurrent(largest);
            }
        }
    }

    private final class Flush
    implements Runnable {
        final OpOrder.Barrier writeBarrier;
        final List<Memtable> memtables;
        final PostFlush postFlush;
        final boolean truncate;

        private Flush(boolean truncate) {
            Memtable.LastReplayPosition lastReplayPosition;
            ReplayPosition currentLast;
            this.truncate = truncate;
            ColumnFamilyStore.this.metric.pendingFlushes.inc();
            this.writeBarrier = ColumnFamilyStore.this.keyspace.writeOrder.newBarrier();
            this.memtables = new ArrayList<Memtable>();
            AtomicReference<ReplayPosition> lastReplayPositionHolder = new AtomicReference<ReplayPosition>();
            for (ColumnFamilyStore cfs : ColumnFamilyStore.this.concatWithIndexes()) {
                Memtable mt = cfs.data.switchMemtable(truncate);
                mt.setDiscarding(this.writeBarrier, lastReplayPositionHolder);
                this.memtables.add(mt);
            }
            do {
                lastReplayPosition = new Memtable.LastReplayPosition(CommitLog.instance.getContext());
            } while ((currentLast = (ReplayPosition)lastReplayPositionHolder.get()) != null && currentLast.compareTo(lastReplayPosition) > 0 || !lastReplayPositionHolder.compareAndSet(currentLast, lastReplayPosition));
            this.writeBarrier.issue();
            this.postFlush = new PostFlush(!truncate, this.writeBarrier, lastReplayPosition);
        }

        @Override
        public void run() {
            this.writeBarrier.markBlocking();
            this.writeBarrier.await();
            Iterator<Memtable> iter = this.memtables.iterator();
            while (iter.hasNext()) {
                Memtable memtable = iter.next();
                memtable.cfs.data.markFlushing(memtable);
                if (!memtable.isClean() && !this.truncate) continue;
                memtable.cfs.replaceFlushed(memtable, null);
                this.reclaim(memtable);
                iter.remove();
            }
            if (this.memtables.isEmpty()) {
                this.postFlush.latch.countDown();
                return;
            }
            ColumnFamilyStore.this.metric.memtableSwitchCount.inc();
            for (Memtable memtable : this.memtables) {
                MoreExecutors.sameThreadExecutor().execute((Runnable)memtable.flushRunnable());
                this.reclaim(memtable);
            }
            this.postFlush.latch.countDown();
        }

        private void reclaim(final Memtable memtable) {
            final OpOrder.Barrier readBarrier = ColumnFamilyStore.this.readOrdering.newBarrier();
            readBarrier.issue();
            reclaimExecutor.execute(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws InterruptedException, ExecutionException {
                    readBarrier.await();
                    memtable.setDiscarded();
                }
            });
        }
    }

    private final class PostFlush
    implements Runnable {
        final boolean flushSecondaryIndexes;
        final OpOrder.Barrier writeBarrier;
        final CountDownLatch latch = new CountDownLatch(1);
        final ReplayPosition lastReplayPosition;

        private PostFlush(boolean flushSecondaryIndexes, OpOrder.Barrier writeBarrier, ReplayPosition lastReplayPosition) {
            this.writeBarrier = writeBarrier;
            this.flushSecondaryIndexes = flushSecondaryIndexes;
            this.lastReplayPosition = lastReplayPosition;
        }

        @Override
        public void run() {
            this.writeBarrier.await();
            if (this.flushSecondaryIndexes) {
                for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexesNotBackedByCfs()) {
                    logger.info("Flushing SecondaryIndex {}", (Object)index);
                    index.forceBlockingFlush();
                }
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException();
            }
            if (this.lastReplayPosition != null) {
                CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, this.lastReplayPosition);
            }
            ColumnFamilyStore.this.metric.pendingFlushes.dec();
        }
    }
}

