/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimeSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TimeType
extends AbstractType<Long> {
    public static final TimeType instance = new TimeType();

    private TimeType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        return this.decompose(TimeSerializer.timeStringToLong(source));
    }

    @Override
    public boolean isByteOrderComparable() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return super.isCompatibleWith(previous);
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == LongType.instance;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a time value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + TimeSerializer.instance.toString(TimeSerializer.instance.deserialize(buffer)) + '\"';
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIME;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return TimeSerializer.instance;
    }
}

