/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;

public class NativeSSTableLoaderClient
extends SSTableLoader.Client {
    protected final Map<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
    private final Collection<InetAddress> hosts;
    private final int port;
    private final String username;
    private final String password;
    private final SSLOptions sslOptions;

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, String username, String password, SSLOptions sslOptions) {
        this.hosts = hosts;
        this.port = port;
        this.username = username;
        this.password = password;
        this.sslOptions = sslOptions;
    }

    @Override
    public void init(String keyspace) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(this.hosts).withPort(this.port);
        if (this.sslOptions != null) {
            builder.withSSL(this.sslOptions);
        }
        if (this.username != null && this.password != null) {
            builder = builder.withCredentials(this.username, this.password);
        }
        try (Cluster cluster = builder.build();
             Session session = cluster.connect();){
            Metadata metadata = cluster.getMetadata();
            this.setPartitioner(metadata.getPartitioner());
            Set tokenRanges = metadata.getTokenRanges();
            Token.TokenFactory tokenFactory = this.getPartitioner().getTokenFactory();
            for (TokenRange tokenRange : tokenRanges) {
                Set endpoints = metadata.getReplicas(keyspace, tokenRange);
                Range<Token> range = new Range<Token>(tokenFactory.fromString(tokenRange.getStart().getValue().toString()), tokenFactory.fromString(tokenRange.getEnd().getValue().toString()));
                for (Host endpoint : endpoints) {
                    this.addRangeForEndpoint(range, endpoint.getAddress());
                }
            }
            this.tables.putAll(NativeSSTableLoaderClient.fetchTablesMetadata(keyspace, session));
        }
    }

    @Override
    public CFMetaData getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    @Override
    public void setTableMetadata(CFMetaData cfm) {
        this.tables.put(cfm.cfName, cfm);
    }

    private static Map<String, CFMetaData> fetchTablesMetadata(String keyspace, Session session) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT columnfamily_name, cf_id, type, comparator, subcomparator, is_dense FROM %s.%s WHERE keyspace_name = '%s'", "system", "schema_columnfamilies", keyspace);
        for (Row row : session.execute(query)) {
            String name = row.getString("columnfamily_name");
            UUID id = row.getUUID("cf_id");
            ColumnFamilyType type = ColumnFamilyType.valueOf(row.getString("type"));
            AbstractType<?> rawComparator = TypeParser.parse(row.getString("comparator"));
            AbstractType<?> subComparator = row.isNull("subcomparator") ? null : TypeParser.parse(row.getString("subcomparator"));
            boolean isDense = row.getBool("is_dense");
            CellNameType comparator = CellNames.fromAbstractType(CFMetaData.makeRawAbstractType(rawComparator, subComparator), isDense);
            tables.put(name, new CFMetaData(keyspace, name, type, comparator, id));
        }
        return tables;
    }
}

