/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class CleanupMessage
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new CleanupMessageSerializer();
    public final UUID parentRepairSession;

    public CleanupMessage(UUID parentRepairSession) {
        super(RepairMessage.Type.CLEANUP, null);
        this.parentRepairSession = parentRepairSession;
    }

    public static class CleanupMessageSerializer
    implements RepairMessage.MessageSerializer<CleanupMessage> {
        @Override
        public void serialize(CleanupMessage message, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(message.parentRepairSession, out, version);
        }

        @Override
        public CleanupMessage deserialize(DataInput in, int version) throws IOException {
            UUID parentRepairSession = UUIDSerializer.serializer.deserialize(in, version);
            return new CleanupMessage(parentRepairSession);
        }

        @Override
        public long serializedSize(CleanupMessage message, int version) {
            return UUIDSerializer.serializer.serializedSize(message.parentRepairSession, version);
        }
    }
}

