/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public class CounterCacheKey
implements CacheKey {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new CounterCacheKey(null, ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBuffer.allocate(1))) + ObjectSizes.measure(new UUID(0L, 0L));
    public final UUID cfId;
    public final byte[] partitionKey;
    public final byte[] cellName;

    public CounterCacheKey(UUID cfId, ByteBuffer partitionKey, ByteBuffer cellName) {
        this.cfId = cfId;
        this.partitionKey = ByteBufferUtil.getArray(partitionKey);
        this.cellName = ByteBufferUtil.getArray(cellName);
    }

    public static CounterCacheKey create(UUID cfId, ByteBuffer partitionKey, Clustering clustering, ColumnDefinition c, CellPath path) {
        return new CounterCacheKey(cfId, partitionKey, CounterCacheKey.makeCellName(clustering, c, path));
    }

    private static ByteBuffer makeCellName(Clustering clustering, ColumnDefinition c, CellPath path) {
        int i;
        int cs = clustering.size();
        ByteBuffer[] values = new ByteBuffer[cs + 1 + (path == null ? 0 : path.size())];
        for (i = 0; i < cs; ++i) {
            values[i] = clustering.get(i);
        }
        values[cs] = c.name.bytes;
        if (path != null) {
            for (i = 0; i < path.size(); ++i) {
                values[cs + 1 + i] = path.get(i);
            }
        }
        return CompositeType.build(values);
    }

    @Override
    public UUID getCFId() {
        return this.cfId;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.partitionKey) + ObjectSizes.sizeOfArray(this.cellName);
    }

    public String toString() {
        return String.format("CounterCacheKey(%s, %s, %s)", this.cfId, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.partitionKey)), ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.cellName)));
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.cfId, this.partitionKey, this.cellName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CounterCacheKey)) {
            return false;
        }
        CounterCacheKey cck = (CounterCacheKey)o;
        return this.cfId.equals(cck.cfId) && Arrays.equals(this.partitionKey, cck.partitionKey) && Arrays.equals(this.cellName, cck.cellName);
    }
}

