/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeAggregateFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;

public abstract class AggregateFcts {
    public static final AggregateFunction countRowsFunction = new NativeAggregateFunction("countRows", (AbstractType)LongType.instance, new AbstractType[0]){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private long count;

                @Override
                public void reset() {
                    this.count = 0L;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((LongType)this.returnType()).decompose(this.count);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ++this.count;
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForDecimal = new NativeAggregateFunction("sum", (AbstractType)DecimalType.instance, new AbstractType[]{DecimalType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigDecimal sum = BigDecimal.ZERO;

                @Override
                public void reset() {
                    this.sum = BigDecimal.ZERO;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((DecimalType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    BigDecimal number = (BigDecimal)this.argTypes().get(0).compose(value);
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForDecimal = new NativeAggregateFunction("avg", (AbstractType)DecimalType.instance, new AbstractType[]{DecimalType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigDecimal sum = BigDecimal.ZERO;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = BigDecimal.ZERO;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    if (this.count == 0) {
                        return ((DecimalType)this.returnType()).decompose(BigDecimal.ZERO);
                    }
                    return ((DecimalType)this.returnType()).decompose(this.sum.divide(BigDecimal.valueOf(this.count)));
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    BigDecimal number = (BigDecimal)this.argTypes().get(0).compose(value);
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForVarint = new NativeAggregateFunction("sum", (AbstractType)IntegerType.instance, new AbstractType[]{IntegerType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigInteger sum = BigInteger.ZERO;

                @Override
                public void reset() {
                    this.sum = BigInteger.ZERO;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((IntegerType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    BigInteger number = (BigInteger)this.argTypes().get(0).compose(value);
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForVarint = new NativeAggregateFunction("avg", (AbstractType)IntegerType.instance, new AbstractType[]{IntegerType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigInteger sum = BigInteger.ZERO;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = BigInteger.ZERO;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    if (this.count == 0) {
                        return ((IntegerType)this.returnType()).decompose(BigInteger.ZERO);
                    }
                    return ((IntegerType)this.returnType()).decompose(this.sum.divide(BigInteger.valueOf(this.count)));
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    BigInteger number = (BigInteger)this.argTypes().get(0).compose(value);
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForByte = new NativeAggregateFunction("sum", (AbstractType)ByteType.instance, new AbstractType[]{ByteType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private byte sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((ByteType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum = (byte)(this.sum + number.byteValue());
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForByte = new NativeAggregateFunction("avg", (AbstractType)ByteType.instance, new AbstractType[]{ByteType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private byte sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    int avg = this.count == 0 ? 0 : this.sum / this.count;
                    return ((ByteType)this.returnType()).decompose((byte)avg);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum = (byte)(this.sum + number.byteValue());
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForShort = new NativeAggregateFunction("sum", (AbstractType)ShortType.instance, new AbstractType[]{ShortType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private short sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((ShortType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum = (short)(this.sum + number.shortValue());
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForShort = new NativeAggregateFunction("avg", (AbstractType)ShortType.instance, new AbstractType[]{ShortType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private short sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    int avg = this.count == 0 ? 0 : this.sum / this.count;
                    return ((ShortType)this.returnType()).decompose((short)avg);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum = (short)(this.sum + number.shortValue());
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForInt32 = new NativeAggregateFunction("sum", (AbstractType)Int32Type.instance, new AbstractType[]{Int32Type.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private int sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((Int32Type)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.intValue();
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForInt32 = new NativeAggregateFunction("avg", (AbstractType)Int32Type.instance, new AbstractType[]{Int32Type.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private int sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    int avg = this.count == 0 ? 0 : this.sum / this.count;
                    return ((Int32Type)this.returnType()).decompose(avg);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.intValue();
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForLong = new NativeAggregateFunction("sum", (AbstractType)LongType.instance, new AbstractType[]{LongType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private long sum;

                @Override
                public void reset() {
                    this.sum = 0L;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((LongType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.longValue();
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForLong = new NativeAggregateFunction("avg", (AbstractType)LongType.instance, new AbstractType[]{LongType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private long sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0L;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    long avg = this.count == 0 ? 0L : this.sum / (long)this.count;
                    return ((LongType)this.returnType()).decompose(avg);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.longValue();
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForFloat = new NativeAggregateFunction("sum", (AbstractType)FloatType.instance, new AbstractType[]{FloatType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private float sum;

                @Override
                public void reset() {
                    this.sum = 0.0f;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((FloatType)this.returnType()).decompose(Float.valueOf(this.sum));
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.floatValue();
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForFloat = new NativeAggregateFunction("avg", (AbstractType)FloatType.instance, new AbstractType[]{FloatType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private float sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0.0f;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    float avg = this.count == 0 ? 0.0f : this.sum / (float)this.count;
                    return ((FloatType)this.returnType()).decompose(Float.valueOf(avg));
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.floatValue();
                }
            };
        }
    };
    public static final AggregateFunction sumFunctionForDouble = new NativeAggregateFunction("sum", (AbstractType)DoubleType.instance, new AbstractType[]{DoubleType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private double sum;

                @Override
                public void reset() {
                    this.sum = 0.0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    return ((DoubleType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.doubleValue();
                }
            };
        }
    };
    public static final AggregateFunction avgFunctionForDouble = new NativeAggregateFunction("avg", (AbstractType)DoubleType.instance, new AbstractType[]{DoubleType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private double sum;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = 0.0;
                }

                @Override
                public ByteBuffer compute(int protocolVersion) {
                    double avg = this.count == 0 ? 0.0 : this.sum / (double)this.count;
                    return ((DoubleType)this.returnType()).decompose(avg);
                }

                @Override
                public void addInput(int protocolVersion, List<ByteBuffer> values) {
                    ByteBuffer value = values.get(0);
                    if (value == null) {
                        return;
                    }
                    ++this.count;
                    Number number = (Number)this.argTypes().get(0).compose(value);
                    this.sum += number.doubleValue();
                }
            };
        }
    };

    public static Collection<AggregateFunction> all() {
        ArrayList<AggregateFunction> functions = new ArrayList<AggregateFunction>();
        functions.add(countRowsFunction);
        functions.add(sumFunctionForByte);
        functions.add(sumFunctionForShort);
        functions.add(sumFunctionForInt32);
        functions.add(sumFunctionForLong);
        functions.add(sumFunctionForFloat);
        functions.add(sumFunctionForDouble);
        functions.add(sumFunctionForDecimal);
        functions.add(sumFunctionForVarint);
        functions.add(avgFunctionForByte);
        functions.add(avgFunctionForShort);
        functions.add(avgFunctionForInt32);
        functions.add(avgFunctionForLong);
        functions.add(avgFunctionForFloat);
        functions.add(avgFunctionForDouble);
        functions.add(avgFunctionForDecimal);
        functions.add(avgFunctionForVarint);
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            if (type == CQL3Type.Native.VARCHAR) continue;
            functions.add(AggregateFcts.makeCountFunction(type.getType()));
            functions.add(AggregateFcts.makeMaxFunction(type.getType()));
            functions.add(AggregateFcts.makeMinFunction(type.getType()));
        }
        return functions;
    }

    public static boolean isCountRows(Function function) {
        return function == countRowsFunction;
    }

    public static AggregateFunction makeMaxFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("max", (AbstractType)inputType, new AbstractType[]{inputType}){

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private ByteBuffer max;

                    @Override
                    public void reset() {
                        this.max = null;
                    }

                    @Override
                    public ByteBuffer compute(int protocolVersion) {
                        return this.max;
                    }

                    @Override
                    public void addInput(int protocolVersion, List<ByteBuffer> values) {
                        ByteBuffer value = values.get(0);
                        if (value == null) {
                            return;
                        }
                        if (this.max == null || this.returnType().compare(this.max, value) < 0) {
                            this.max = value;
                        }
                    }
                };
            }
        };
    }

    public static AggregateFunction makeMinFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("min", (AbstractType)inputType, new AbstractType[]{inputType}){

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private ByteBuffer min;

                    @Override
                    public void reset() {
                        this.min = null;
                    }

                    @Override
                    public ByteBuffer compute(int protocolVersion) {
                        return this.min;
                    }

                    @Override
                    public void addInput(int protocolVersion, List<ByteBuffer> values) {
                        ByteBuffer value = values.get(0);
                        if (value == null) {
                            return;
                        }
                        if (this.min == null || this.returnType().compare(this.min, value) > 0) {
                            this.min = value;
                        }
                    }
                };
            }
        };
    }

    public static AggregateFunction makeCountFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("count", (AbstractType)LongType.instance, new AbstractType[]{inputType}){

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private long count;

                    @Override
                    public void reset() {
                        this.count = 0L;
                    }

                    @Override
                    public ByteBuffer compute(int protocolVersion) {
                        return ((LongType)this.returnType()).decompose(this.count);
                    }

                    @Override
                    public void addInput(int protocolVersion, List<ByteBuffer> values) {
                        ByteBuffer value = values.get(0);
                        if (value == null) {
                            return;
                        }
                        ++this.count;
                    }
                };
            }
        };
    }
}

