/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class RowUpdateBuilder {
    private final PartitionUpdate update;
    private final long timestamp;
    private final int ttl;
    private final int localDeletionTime;
    private final DeletionTime deletionTime;
    private final Mutation mutation;
    private Row.Builder regularBuilder;
    private Row.Builder staticBuilder;
    private boolean useRowMarker = true;

    private RowUpdateBuilder(PartitionUpdate update, long timestamp, int ttl, int localDeletionTime, Mutation mutation) {
        this.update = update;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = localDeletionTime;
        this.deletionTime = new DeletionTime(timestamp, localDeletionTime);
        this.mutation = mutation == null ? new Mutation(update.metadata().ksName, update.partitionKey()).add(update) : mutation;
    }

    private RowUpdateBuilder(PartitionUpdate update, long timestamp, int ttl, Mutation mutation) {
        this(update, timestamp, ttl, FBUtilities.nowInSeconds(), mutation);
    }

    private void startRow(Clustering clustering) {
        assert (this.staticBuilder == null) : "Cannot update both static and non-static columns with the same RowUpdateBuilder object";
        assert (this.regularBuilder == null) : "Cannot add the clustering twice to the same row";
        this.regularBuilder = BTreeRow.unsortedBuilder(this.update.columns().regulars, FBUtilities.nowInSeconds());
        this.regularBuilder.newRow(clustering);
        if (this.update.metadata().isCQLTable() && this.useRowMarker) {
            this.regularBuilder.addPrimaryKeyLivenessInfo(LivenessInfo.create(this.update.metadata(), this.timestamp, this.ttl, this.localDeletionTime));
        }
    }

    private Row.Builder builder() {
        assert (this.staticBuilder == null) : "Cannot update both static and non-static columns with the same RowUpdateBuilder object";
        if (this.regularBuilder == null) {
            assert (this.update.metadata().comparator.size() == 0) : "Missing call to clustering()";
            this.startRow(Clustering.EMPTY);
        }
        return this.regularBuilder;
    }

    private Row.Builder staticBuilder() {
        assert (this.regularBuilder == null) : "Cannot update both static and non-static columns with the same RowUpdateBuilder object";
        if (this.staticBuilder == null) {
            this.staticBuilder = BTreeRow.unsortedBuilder(this.update.columns().statics, FBUtilities.nowInSeconds());
            this.staticBuilder.newRow(Clustering.STATIC_CLUSTERING);
        }
        return this.staticBuilder;
    }

    private Row.Builder builder(ColumnDefinition c) {
        return c.isStatic() ? this.staticBuilder() : this.builder();
    }

    public RowUpdateBuilder(CFMetaData metadata, long timestamp, Object partitionKey) {
        this(metadata, FBUtilities.nowInSeconds(), timestamp, partitionKey);
    }

    public RowUpdateBuilder(CFMetaData metadata, int localDeletionTime, long timestamp, Object partitionKey) {
        this(metadata, localDeletionTime, timestamp, metadata.params.defaultTimeToLive, partitionKey);
    }

    public RowUpdateBuilder(CFMetaData metadata, long timestamp, int ttl, Object partitionKey) {
        this(metadata, FBUtilities.nowInSeconds(), timestamp, ttl, partitionKey);
    }

    public RowUpdateBuilder(CFMetaData metadata, int localDeletionTime, long timestamp, int ttl, Object partitionKey) {
        this(new PartitionUpdate(metadata, RowUpdateBuilder.makeKey(metadata, partitionKey), metadata.partitionColumns(), 1), timestamp, ttl, localDeletionTime, null);
    }

    public RowUpdateBuilder(CFMetaData metadata, long timestamp, Mutation mutation) {
        this(metadata, timestamp, 0, mutation);
    }

    public RowUpdateBuilder(CFMetaData metadata, long timestamp, int ttl, Mutation mutation) {
        this(RowUpdateBuilder.getOrAdd(metadata, mutation), timestamp, ttl, mutation);
    }

    public RowUpdateBuilder(PartitionUpdate update, long timestamp, int ttl) {
        this(update, timestamp, ttl, null);
    }

    public RowUpdateBuilder noRowMarker() {
        this.useRowMarker = false;
        return this;
    }

    public RowUpdateBuilder clustering(Object ... clusteringValues) {
        assert (clusteringValues.length == this.update.metadata().comparator.size()) : "Invalid clustering values length. Expected: " + this.update.metadata().comparator.size() + " got: " + clusteringValues.length;
        this.startRow(clusteringValues.length == 0 ? Clustering.EMPTY : this.update.metadata().comparator.make(clusteringValues));
        return this;
    }

    public Mutation build() {
        Row.Builder builder;
        Row.Builder builder2 = builder = this.regularBuilder == null ? this.staticBuilder : this.regularBuilder;
        if (builder != null) {
            this.update.add(builder.build());
        }
        return this.mutation;
    }

    public PartitionUpdate buildUpdate() {
        this.build();
        return this.update;
    }

    private static void deleteRow(PartitionUpdate update, long timestamp, int localDeletionTime, Object ... clusteringValues) {
        assert (clusteringValues.length == update.metadata().comparator.size() || clusteringValues.length == 0 && !update.columns().statics.isEmpty());
        boolean isStatic = clusteringValues.length != update.metadata().comparator.size();
        Row.Builder builder = BTreeRow.sortedBuilder(isStatic ? update.columns().statics : update.columns().regulars);
        if (isStatic) {
            builder.newRow(Clustering.STATIC_CLUSTERING);
        } else {
            builder.newRow(clusteringValues.length == 0 ? Clustering.EMPTY : update.metadata().comparator.make(clusteringValues));
        }
        builder.addRowDeletion(new DeletionTime(timestamp, localDeletionTime));
        update.add(builder.build());
    }

    public static Mutation deleteRow(CFMetaData metadata, long timestamp, Mutation mutation, Object ... clusteringValues) {
        RowUpdateBuilder.deleteRow(RowUpdateBuilder.getOrAdd(metadata, mutation), timestamp, FBUtilities.nowInSeconds(), clusteringValues);
        return mutation;
    }

    public static Mutation deleteRow(CFMetaData metadata, long timestamp, Object key, Object ... clusteringValues) {
        return RowUpdateBuilder.deleteRowAt(metadata, timestamp, FBUtilities.nowInSeconds(), key, clusteringValues);
    }

    public static Mutation deleteRowAt(CFMetaData metadata, long timestamp, int localDeletionTime, Object key, Object ... clusteringValues) {
        PartitionUpdate update = new PartitionUpdate(metadata, RowUpdateBuilder.makeKey(metadata, key), metadata.partitionColumns(), 0);
        RowUpdateBuilder.deleteRow(update, timestamp, localDeletionTime, clusteringValues);
        return new Mutation(update.metadata().ksName, update.partitionKey()).add(update);
    }

    private static DecoratedKey makeKey(CFMetaData metadata, Object ... partitionKey) {
        if (partitionKey.length == 1 && partitionKey[0] instanceof DecoratedKey) {
            return (DecoratedKey)partitionKey[0];
        }
        ByteBuffer key = CFMetaData.serializePartitionKey(metadata.getKeyValidatorAsClusteringComparator().make(partitionKey));
        return metadata.decorateKey(key);
    }

    private static PartitionUpdate getOrAdd(CFMetaData metadata, Mutation mutation) {
        PartitionUpdate upd = mutation.get(metadata);
        if (upd == null) {
            upd = new PartitionUpdate(metadata, mutation.key(), metadata.partitionColumns(), 1);
            mutation.add(upd);
        }
        return upd;
    }

    public RowUpdateBuilder resetCollection(String columnName) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c != null) : "Cannot find column " + columnName;
        assert (c.isStatic() || this.update.metadata().comparator.size() == 0 || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type.isCollection() && c.type.isMultiCell());
        this.builder(c).addComplexDeletion(c, new DeletionTime(this.timestamp - 1L, this.localDeletionTime));
        return this;
    }

    public RowUpdateBuilder addRangeTombstone(RangeTombstone rt) {
        this.update.add(rt);
        return this;
    }

    public RowUpdateBuilder addRangeTombstone(Slice slice) {
        return this.addRangeTombstone(new RangeTombstone(slice, this.deletionTime));
    }

    public RowUpdateBuilder addRangeTombstone(Object start, Object end) {
        ClusteringComparator cmp = this.update.metadata().comparator;
        Slice slice = Slice.make(cmp.make(start), cmp.make(end));
        return this.addRangeTombstone(slice);
    }

    public RowUpdateBuilder add(String columnName, Object value) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c != null) : "Cannot find column " + columnName;
        return this.add(c, value);
    }

    private Cell makeCell(ColumnDefinition c, ByteBuffer value, CellPath path) {
        return value == null ? BufferCell.tombstone(c, this.timestamp, this.localDeletionTime) : (this.ttl == 0 ? BufferCell.live(this.update.metadata(), c, this.timestamp, value, path) : BufferCell.expiring(c, this.timestamp, this.ttl, this.localDeletionTime, value, path));
    }

    public RowUpdateBuilder add(ColumnDefinition columnDefinition, Object value) {
        assert (columnDefinition.isStatic() || this.update.metadata().comparator.size() == 0 || this.regularBuilder != null) : "Cannot set non static column " + columnDefinition + " since no clustering hasn't been provided";
        this.builder(columnDefinition).addCell(this.makeCell(columnDefinition, RowUpdateBuilder.bb(value, columnDefinition.type), null));
        return this;
    }

    public RowUpdateBuilder delete(String columnName) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c != null) : "Cannot find column " + columnName;
        return this.delete(c);
    }

    public RowUpdateBuilder delete(ColumnDefinition columnDefinition) {
        return this.add(columnDefinition, null);
    }

    private static ByteBuffer bb(Object value, AbstractType<?> type) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        if (type.isCounter()) {
            assert (value instanceof Long) : "Attempted to adjust Counter cell with non-long value.";
            return CounterContext.instance().createGlobal(CounterId.getLocalId(), 1L, (Long)value);
        }
        return type.decompose(value);
    }

    public RowUpdateBuilder map(String columnName, Map<?, ?> map) {
        this.resetCollection(columnName);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.addMapEntry(columnName, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RowUpdateBuilder set(String columnName, Set<?> set) {
        this.resetCollection(columnName);
        for (Object element : set) {
            this.addSetEntry(columnName, element);
        }
        return this;
    }

    public RowUpdateBuilder frozenList(String columnName, List<?> list) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof ListType && !c.type.isMultiCell()) : "Column " + c + " is not a frozen list";
        this.builder(c).addCell(this.makeCell(c, RowUpdateBuilder.bb(c.type.decompose(list), c.type), null));
        return this;
    }

    public RowUpdateBuilder frozenSet(String columnName, Set<?> set) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof SetType && !c.type.isMultiCell()) : "Column " + c + " is not a frozen set";
        this.builder(c).addCell(this.makeCell(c, RowUpdateBuilder.bb(c.type.decompose(set), c.type), null));
        return this;
    }

    public RowUpdateBuilder frozenMap(String columnName, Map<?, ?> map) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof MapType && !c.type.isMultiCell()) : "Column " + c + " is not a frozen map";
        this.builder(c).addCell(this.makeCell(c, RowUpdateBuilder.bb(c.type.decompose(map), c.type), null));
        return this;
    }

    public RowUpdateBuilder addMapEntry(String columnName, Object key, Object value) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.update.metadata().comparator.size() == 0 || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof MapType && c.type.isMultiCell()) : "Column " + c + " is not a non-frozen map";
        MapType mt = (MapType)c.type;
        this.builder(c).addCell(this.makeCell(c, RowUpdateBuilder.bb(value, mt.getValuesType()), CellPath.create(RowUpdateBuilder.bb(key, mt.getKeysType()))));
        return this;
    }

    public RowUpdateBuilder addListEntry(String columnName, Object value) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof ListType && c.type.isMultiCell()) : "Column " + c + " is not a non-frozen list";
        ListType lt = (ListType)c.type;
        this.builder(c).addCell(this.makeCell(c, RowUpdateBuilder.bb(value, lt.getElementsType()), CellPath.create(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes()))));
        return this;
    }

    public RowUpdateBuilder addSetEntry(String columnName, Object value) {
        ColumnDefinition c = this.getDefinition(columnName);
        assert (c.isStatic() || this.regularBuilder != null) : "Cannot set non static column " + c + " since no clustering has been provided";
        assert (c.type instanceof SetType && c.type.isMultiCell()) : "Column " + c + " is not a non-frozen set";
        SetType st = (SetType)c.type;
        this.builder(c).addCell(this.makeCell(c, ByteBufferUtil.EMPTY_BYTE_BUFFER, CellPath.create(RowUpdateBuilder.bb(value, st.getElementsType()))));
        return this;
    }

    private ColumnDefinition getDefinition(String name) {
        return this.update.metadata().getColumnDefinition(new ColumnIdentifier(name, true));
    }

    public UnfilteredRowIterator unfilteredIterator() {
        return this.update.unfilteredIterator();
    }
}

