/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.columniterator.AbstractSSTableIterator;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.btree.BTree;

public class SSTableReversedIterator
extends AbstractSSTableIterator {
    public SSTableReversedIterator(SSTableReader sstable, DecoratedKey key, ColumnFilter columns, boolean isForThrift) {
        this(sstable, null, key, sstable.getPosition(key, SSTableReader.Operator.EQ), columns, isForThrift);
    }

    public SSTableReversedIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, ColumnFilter columns, boolean isForThrift) {
        super(sstable, file, key, indexEntry, columns, isForThrift);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReader(RowIndexEntry indexEntry, FileDataInput file, boolean isAtPartitionStart, boolean shouldCloseFile) {
        return indexEntry.isIndexed() ? new ReverseIndexedReader(indexEntry, file, isAtPartitionStart, shouldCloseFile) : new ReverseReader(file, isAtPartitionStart, shouldCloseFile);
    }

    @Override
    public boolean isReverseOrder() {
        return true;
    }

    private class ReusablePartitionData {
        private final CFMetaData metadata;
        private final DecoratedKey partitionKey;
        private final PartitionColumns columns;
        private MutableDeletionInfo.Builder deletionBuilder;
        private MutableDeletionInfo deletionInfo;
        private BTree.Builder<Row> rowBuilder;
        private ImmutableBTreePartition built;

        private ReusablePartitionData(CFMetaData metadata, DecoratedKey partitionKey, PartitionColumns columns, int initialRowCapacity) {
            this.metadata = metadata;
            this.partitionKey = partitionKey;
            this.columns = columns;
            this.rowBuilder = BTree.builder(metadata.comparator, initialRowCapacity);
        }

        public void add(Unfiltered unfiltered) {
            if (unfiltered.isRow()) {
                this.rowBuilder.add((Row)unfiltered);
            } else {
                this.deletionBuilder.add((RangeTombstoneMarker)unfiltered);
            }
        }

        public void reset() {
            this.built = null;
            this.rowBuilder.reuse();
            this.deletionBuilder = MutableDeletionInfo.builder(SSTableReversedIterator.this.partitionLevelDeletion, SSTableReversedIterator.this.metadata().comparator, false);
        }

        public void build() {
            this.deletionInfo = this.deletionBuilder.build();
            this.built = new ImmutableBTreePartition(this.metadata, this.partitionKey, this.columns, Rows.EMPTY_STATIC_ROW, this.rowBuilder.build(), DeletionInfo.LIVE, EncodingStats.NO_STATS);
            this.deletionBuilder = null;
        }
    }

    private class ReverseIndexedReader
    extends ReverseReader {
        private final AbstractSSTableIterator.IndexState indexState;
        private Slice slice;
        private int lastBlockIdx;

        private ReverseIndexedReader(RowIndexEntry indexEntry, FileDataInput file, boolean isAtPartitionStart, boolean shouldCloseFile) {
            super(file, isAtPartitionStart, shouldCloseFile);
            this.indexState = new AbstractSSTableIterator.IndexState(this, SSTableReversedIterator.this.sstable.metadata.comparator, indexEntry, true);
        }

        @Override
        protected void init() throws IOException {
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            this.slice = slice;
            this.isInit = true;
            if (this.indexState.isDone()) {
                this.iterator = Collections.emptyIterator();
                return;
            }
            int startIdx = this.indexState.findBlockIndex(slice.end(), this.indexState.currentBlockIdx());
            if (startIdx < 0) {
                this.iterator = Collections.emptyIterator();
                return;
            }
            this.lastBlockIdx = this.indexState.findBlockIndex(slice.start(), startIdx);
            if (this.lastBlockIdx >= this.indexState.blocksCount()) {
                assert (startIdx >= this.indexState.blocksCount());
                this.iterator = Collections.emptyIterator();
                return;
            }
            if (startIdx >= this.indexState.blocksCount()) {
                startIdx = this.indexState.blocksCount() - 1;
            }
            if (startIdx != this.indexState.currentBlockIdx()) {
                this.indexState.setToBlock(startIdx);
                this.readCurrentBlock(true);
            }
            this.setIterator(slice);
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            if (super.hasNextInternal()) {
                return true;
            }
            int previousBlockIdx = this.indexState.currentBlockIdx() - 1;
            if (previousBlockIdx < 0 || previousBlockIdx < this.lastBlockIdx) {
                return false;
            }
            this.indexState.setToBlock(previousBlockIdx);
            this.readCurrentBlock(false);
            this.setIterator(this.slice);
            return this.iterator.hasNext();
        }

        private void readCurrentBlock(boolean canIncludeSliceEnd) throws IOException {
            if (this.buffer == null) {
                this.buffer = this.createBuffer(this.indexState.blocksCount());
            }
            boolean canIncludeSliceStart = this.indexState.currentBlockIdx() == this.lastBlockIdx;
            this.loadFromDisk(canIncludeSliceStart ? this.slice.start() : null, canIncludeSliceEnd ? this.slice.end() : null);
        }

        @Override
        protected boolean stopReadingDisk() {
            return this.indexState.isPastCurrentBlock();
        }
    }

    private class ReverseReader
    extends AbstractSSTableIterator.Reader {
        protected ReusablePartitionData buffer;
        protected Iterator<Unfiltered> iterator;

        private ReverseReader(FileDataInput file, boolean isAtPartitionStart, boolean shouldCloseFile) {
            super(file, isAtPartitionStart, shouldCloseFile);
        }

        protected ReusablePartitionData createBuffer(int blocksCount) {
            int estimatedRowCount = 16;
            int columnCount = SSTableReversedIterator.this.metadata().partitionColumns().regulars.columnCount();
            if (columnCount == 0 || SSTableReversedIterator.this.metadata().clusteringColumns().isEmpty()) {
                estimatedRowCount = 1;
            } else {
                try {
                    int estimatedRowsPerPartition = (int)(SSTableReversedIterator.this.sstable.getEstimatedColumnCount().percentile(0.75) / (long)columnCount);
                    estimatedRowCount = Math.max(estimatedRowsPerPartition / blocksCount, 1);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return new ReusablePartitionData(SSTableReversedIterator.this.metadata(), SSTableReversedIterator.this.partitionKey(), SSTableReversedIterator.this.columns(), estimatedRowCount);
        }

        @Override
        protected void init() throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            if (this.buffer == null) {
                this.buffer = this.createBuffer(1);
                this.loadFromDisk(null, slice.end());
            }
            this.setIterator(slice);
        }

        protected void setIterator(Slice slice) {
            assert (this.buffer != null);
            this.iterator = this.buffer.built.unfilteredIterator(SSTableReversedIterator.this.columns, Slices.with(SSTableReversedIterator.this.metadata().comparator, slice), true);
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            if (this.iterator == null) {
                this.setForSlice(Slice.ALL);
            }
            return this.iterator.hasNext();
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        protected boolean stopReadingDisk() {
            return false;
        }

        protected void loadFromDisk(Slice.Bound start, Slice.Bound end) throws IOException {
            this.buffer.reset();
            if (start != null) {
                while (this.deserializer.hasNext() && this.deserializer.compareNextTo(start) <= 0 && !this.stopReadingDisk()) {
                    if (this.deserializer.nextIsRow()) {
                        this.deserializer.skipNext();
                        continue;
                    }
                    this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
                }
            }
            if (this.openMarker != null) {
                RangeTombstone.Bound markerStart = start == null ? RangeTombstone.Bound.BOTTOM : RangeTombstone.Bound.fromSliceBound(start);
                this.buffer.add(new RangeTombstoneBoundMarker(markerStart, this.openMarker));
            }
            while (this.deserializer.hasNext() && (end == null || this.deserializer.compareNextTo(end) <= 0) && !this.stopReadingDisk()) {
                Unfiltered unfiltered = this.deserializer.readNext();
                this.buffer.add(unfiltered);
                if (!unfiltered.isRangeTombstoneMarker()) continue;
                this.updateOpenMarker((RangeTombstoneMarker)unfiltered);
            }
            if (this.openMarker != null) {
                RangeTombstone.Bound markerEnd = end == null ? RangeTombstone.Bound.TOP : RangeTombstone.Bound.fromSliceBound(end);
                this.buffer.add(new RangeTombstoneBoundMarker(markerEnd, this.getAndClearOpenMarker()));
            }
            this.buffer.build();
        }
    }
}

