/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingUnfilteredRowIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.WrappingUnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public class CountingUnfilteredPartitionIterator
extends WrappingUnfilteredPartitionIterator {
    protected final DataLimits.Counter counter;

    public CountingUnfilteredPartitionIterator(UnfilteredPartitionIterator result, DataLimits.Counter counter) {
        super(result);
        this.counter = counter;
    }

    public DataLimits.Counter counter() {
        return this.counter;
    }

    @Override
    public boolean hasNext() {
        if (this.counter.isDone()) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public UnfilteredRowIterator computeNext(UnfilteredRowIterator iter) {
        return new CountingUnfilteredRowIterator(iter, this.counter);
    }
}

